/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.routing.IStaticResourceCacheConfig;
import org.spincast.shaded.org.apache.commons.io.FileUtils;

public class SpincastConfig
implements ISpincastConfig {
    private File spincastBaseWritableDir;
    private IStaticResourceCacheConfig staticResourceCacheConfig;
    private IStaticResourceCacheConfig dynamicResourceCacheConfig;

    public String getEnvironmentName() {
        return "local";
    }

    public int getHttpServerPort() {
        return 44419;
    }

    public int getHttpsServerPort() {
        return -1;
    }

    public String getHttpsKeyStorePath() {
        return null;
    }

    public String getHttpsKeyStoreType() {
        return null;
    }

    public String getHttpsKeyStoreStorePass() {
        return null;
    }

    public String getHttpsKeyStoreKeypass() {
        return null;
    }

    public String getServerHost() {
        return "0.0.0.0";
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isRoutesCaseSensitive() {
        return false;
    }

    public long getServerMaxRequestBodyBytes() {
        return 0x6400000L;
    }

    public List<String> getContentTypesToSkipGziping() {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("image/*");
        prefixes.add("video/*");
        prefixes.add("audio/*");
        prefixes.add("application/pdf");
        prefixes.add("application/octet-stream");
        prefixes.add("application/exe");
        prefixes.add("application/x-font-woff");
        prefixes.add("application/zip");
        prefixes.add("application/x-gzip");
        prefixes.add("application/x-rar-compressed");
        return prefixes;
    }

    public File getSpincastWritableDir() {
        if (this.spincastBaseWritableDir == null) {
            File baseDir = new File(System.getProperty("java.io.tmpdir"));
            if (!baseDir.isDirectory()) {
                throw new RuntimeException("Temporary directory doesn't exist : " + baseDir.getAbsolutePath());
            }
            File spincastDir = new File(baseDir, "spincast");
            if (!spincastDir.isDirectory()) {
                boolean result = spincastDir.mkdirs();
                if (!result) {
                    throw new RuntimeException("Unable to create the Spincast writable directory : " + spincastDir.getAbsolutePath());
                }
            } else {
                this.cleanWritableSpincastDir(spincastDir);
            }
            this.spincastBaseWritableDir = spincastDir;
        }
        return this.spincastBaseWritableDir;
    }

    protected String getSpincastTempDirName() {
        return "temp";
    }

    protected void cleanWritableSpincastDir(File spincastTempDir) {
        try {
            FileUtils.cleanDirectory((File)spincastTempDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to clean the Spincast writable directory: " + spincastTempDir.getAbsolutePath());
        }
    }

    public Locale getDefaultLocale() {
        return Locale.US;
    }

    public int getRouteForwardingMaxNumber() {
        return 2;
    }

    public int getDefaultRouteCacheFilterSecondsNbr() {
        return 3600;
    }

    public boolean isDefaultRouteCacheFilterPrivate() {
        return false;
    }

    public Integer getDefaultRouteCacheFilterSecondsNbrCdns() {
        return null;
    }

    public boolean isDisableWriteToDiskDynamicStaticResource() {
        return this.isDebugEnabled();
    }

    public boolean isAddDefaultTemplateVariablesFilter() {
        return true;
    }

    public int getDefaultTemplateVariablesFilterPosition() {
        return -10;
    }

    public IStaticResourceCacheConfig getDefaultStaticResourceCacheConfig(boolean isDynamicResource) {
        if (this.staticResourceCacheConfig == null) {
            this.staticResourceCacheConfig = new IStaticResourceCacheConfig(){

                public int getCacheSeconds() {
                    return 86400;
                }

                public boolean isCachePrivate() {
                    return false;
                }

                public Integer getCacheSecondsCdn() {
                    return null;
                }
            };
        }
        if (this.dynamicResourceCacheConfig == null) {
            this.dynamicResourceCacheConfig = new IStaticResourceCacheConfig(){

                public int getCacheSeconds() {
                    return 3600;
                }

                public boolean isCachePrivate() {
                    return false;
                }

                public Integer getCacheSecondsCdn() {
                    return null;
                }
            };
        }
        if (isDynamicResource) {
            return this.dynamicResourceCacheConfig;
        }
        return this.staticResourceCacheConfig;
    }
}

