/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.config;

import com.google.inject.Inject;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.dictionary.DictionaryEntryNotFoundBehavior;
import org.spincast.core.routing.StaticResourceCacheConfig;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.config.ConfigFinder;
import org.spincast.plugins.config.SpincastConfigPluginConfig;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastConfigDefault
extends ConfigFinder
implements SpincastConfig {
    public static final String ENVIRONMENT_NAME_DEFAULT = "local";
    private File spincastBaseWritableDir;
    private StaticResourceCacheConfig staticResourceCacheConfig;
    private StaticResourceCacheConfig dynamicResourceCacheConfig;
    private String publicServerSchemeHostPort;
    private URI publicUri;

    @Inject
    protected SpincastConfigDefault(SpincastConfigPluginConfig spincastConfigPluginConfig) {
        super(spincastConfigPluginConfig.getClasspathFilePath(), spincastConfigPluginConfig.getExternalFilePath(), spincastConfigPluginConfig.getEnvironmentVariablesPrefixes(), spincastConfigPluginConfig.isEnvironmentVariablesStripPrefix(), spincastConfigPluginConfig.getSystemPropertiesPrefixes(), spincastConfigPluginConfig.isSystemPropertiesStripPrefix(), spincastConfigPluginConfig.isExternalFileConfigsOverrideEnvironmentVariables(), spincastConfigPluginConfig.isThrowExceptionIfSpecifiedClasspathConfigFileIsNotFound(), spincastConfigPluginConfig.isThrowExceptionIfSpecifiedExternalConfigFileIsNotFound());
    }

    @Inject
    protected void init() {
        this.getRawConfigs();
    }

    public String getEnvironmentName() {
        return ENVIRONMENT_NAME_DEFAULT;
    }

    public int getHttpServerPort() {
        return 44419;
    }

    public int getHttpsServerPort() {
        return -1;
    }

    public String getHttpsKeyStorePath() {
        return null;
    }

    public String getHttpsKeyStoreType() {
        return null;
    }

    public String getHttpsKeyStoreStorePass() {
        return null;
    }

    public String getHttpsKeyStoreKeyPass() {
        return null;
    }

    protected URI getPublicURI() {
        if (this.publicUri == null) {
            try {
                this.publicUri = new URI(this.getPublicUrlBase());
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        return this.publicUri;
    }

    public final String getPublicServerScheme() {
        return this.getPublicURI().getScheme();
    }

    public final String getPublicServerHost() {
        return this.getPublicURI().getHost();
    }

    public final int getPublicServerPort() {
        return this.getPublicURI().getPort();
    }

    public String getPublicUrlBase() {
        if (this.publicServerSchemeHostPort == null) {
            StringBuilder builder = new StringBuilder();
            if (this.getHttpsServerPort() > -1) {
                builder.append("https://");
                builder.append(this.getHostForDefaultPublicServerSchemeHostPort());
                int port = this.getHttpsServerPort();
                if (port != 443) {
                    builder.append(":").append(port);
                }
            } else {
                builder.append("http://");
                builder.append(this.getHostForDefaultPublicServerSchemeHostPort());
                int port = this.getHttpServerPort();
                if (port != 80) {
                    builder.append(":").append(port);
                }
            }
            this.publicServerSchemeHostPort = builder.toString();
        }
        return this.publicServerSchemeHostPort;
    }

    protected String getHostForDefaultPublicServerSchemeHostPort() {
        String serverHost = this.getServerHost();
        if ("0.0.0.0".equals(serverHost)) {
            serverHost = "localhost";
        }
        return serverHost;
    }

    public String getServerHost() {
        return "0.0.0.0";
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isRoutesCaseSensitive() {
        return false;
    }

    public long getServerMaxRequestBodyBytes() {
        return 0x6400000L;
    }

    public List<String> getContentTypesToSkipGziping() {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("image/*");
        prefixes.add("video/*");
        prefixes.add("audio/*");
        prefixes.add("application/pdf");
        prefixes.add("application/octet-stream");
        prefixes.add("application/exe");
        prefixes.add("application/x-font-woff");
        prefixes.add("application/zip");
        prefixes.add("application/x-gzip");
        prefixes.add("application/x-rar-compressed");
        return prefixes;
    }

    public File getWritableRootDir() {
        if (this.spincastBaseWritableDir == null) {
            boolean result;
            File spincastDir;
            File baseDir = null;
            String path = this.getSpincastWritableDirPath();
            if (StringUtils.isBlank((CharSequence)path)) {
                baseDir = new File(System.getProperty("java.io.tmpdir"));
                if (!baseDir.isDirectory()) {
                    throw new RuntimeException("Temporary directory doesn't exist : " + baseDir.getAbsolutePath());
                }
            } else {
                baseDir = new File(path);
                if (!baseDir.isAbsolute()) {
                    String relativePath = StringUtils.stripStart((String)path, (String)"./\\");
                    File jarDir = this.getAppJarDirectory();
                    if (jarDir != null) {
                        baseDir = new File(jarDir.getAbsolutePath() + "/" + relativePath);
                    } else {
                        File noJarDir = this.getAppRootDirectoryNoJar();
                        if (noJarDir != null) {
                            baseDir = new File(noJarDir.getAbsolutePath() + "/" + relativePath);
                        }
                    }
                }
            }
            if (!(spincastDir = new File(baseDir, "spincast")).isDirectory() && !(result = spincastDir.mkdirs())) {
                throw new RuntimeException("Unable to create the Spincast writable directory : " + spincastDir.getAbsolutePath());
            }
            this.spincastBaseWritableDir = spincastDir;
        }
        return this.spincastBaseWritableDir;
    }

    public File getTempDir() {
        return new File(this.getWritableRootDir(), "temp");
    }

    protected String getSpincastWritableDirPath() {
        return null;
    }

    public Locale getDefaultLocale() {
        return Locale.US;
    }

    public TimeZone getDefaultTimeZone() {
        return TimeZone.getTimeZone("UTC");
    }

    public int getRouteForwardingMaxNumber() {
        return 2;
    }

    public int getDefaultRouteCacheFilterSecondsNbr() {
        return 3600;
    }

    public boolean isDefaultRouteCacheFilterPrivate() {
        return false;
    }

    public Integer getDefaultRouteCacheFilterSecondsNbrCdns() {
        return null;
    }

    public boolean isWriteToDiskDynamicStaticResource() {
        return !this.isDebugEnabled();
    }

    public boolean isAddDefaultTemplateVariablesFilter() {
        return true;
    }

    public int getDefaultTemplateVariablesFilterPosition() {
        return -10;
    }

    public StaticResourceCacheConfig getDefaultStaticResourceCacheConfig(boolean isDynamicResource) {
        if (this.staticResourceCacheConfig == null) {
            this.staticResourceCacheConfig = new StaticResourceCacheConfig(){

                public int getCacheSeconds() {
                    return 86400;
                }

                public boolean isCachePrivate() {
                    return false;
                }

                public Integer getCacheSecondsCdn() {
                    return null;
                }
            };
        }
        if (this.dynamicResourceCacheConfig == null) {
            this.dynamicResourceCacheConfig = new StaticResourceCacheConfig(){

                public int getCacheSeconds() {
                    return 3600;
                }

                public boolean isCachePrivate() {
                    return false;
                }

                public Integer getCacheSecondsCdn() {
                    return null;
                }
            };
        }
        if (isDynamicResource) {
            return this.dynamicResourceCacheConfig;
        }
        return this.staticResourceCacheConfig;
    }

    public int getMaxNumberOfKeysWhenConvertingMapToJsonObject() {
        return 100;
    }

    public int getKeyMaxLengthWhenConvertingMapToJsonObject() {
        return 512;
    }

    public int getJsonPathArrayIndexMax() {
        return 10000;
    }

    public boolean isValidateLocalhostHost() {
        return true;
    }

    public boolean isEnableCookiesValidator() {
        return true;
    }

    public String getQueryParamFlashMessageId() {
        return "spincast_flash";
    }

    public String getCookieNameFlashMessage() {
        return "spincast_flash";
    }

    public String getCookieNameLocale() {
        return "spincast_locale";
    }

    public String getCookieNameTimeZoneId() {
        return "spincast_timezone";
    }

    public String getCookiesValidatorCookieName() {
        return "spincast_cookies_enabled";
    }

    public String getSpincastModelRootVariableName() {
        return "spincast";
    }

    public String getValidationElementDefaultName() {
        return "validation";
    }

    public DictionaryEntryNotFoundBehavior getDictionaryEntryNotFoundBehavior() {
        if (this.isDebugEnabled()) {
            return DictionaryEntryNotFoundBehavior.EXCEPTION;
        }
        return DictionaryEntryNotFoundBehavior.RETURN_EMPTY_STRING;
    }
}

