/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.cookies;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Date;
import javax.annotation.Nullable;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.cookies.Cookie;
import org.spincast.shaded.org.apache.commons.lang3.time.DateUtils;

public class CookieDefault
implements Cookie {
    private final String name;
    private String value;
    private String path;
    private String domain;
    private Date expires;
    private boolean secure = false;
    private boolean httpOnly = false;
    private boolean discard = false;
    private int version = 0;

    @AssistedInject
    public CookieDefault(@Assisted(value="name") String name, SpincastConfig spincastConfig) {
        this(name, null, null, null, null, false, false, false, 0, spincastConfig);
    }

    @AssistedInject
    public CookieDefault(@Assisted(value="name") String name, @Assisted(value="value") String value, SpincastConfig spincastConfig) {
        this(name, value, null, null, null, false, false, false, 0, spincastConfig);
    }

    @AssistedInject
    public CookieDefault(@Assisted(value="name") String name, @Assisted(value="value") String value, @Assisted(value="path") @Nullable String path, @Assisted(value="domain") @Nullable String domain, @Assisted(value="expires") @Nullable Date expires, @Assisted(value="secure") boolean secure, @Assisted(value="httpOnly") boolean httpOnly, @Assisted(value="discard") boolean discard, @Assisted(value="version") int version, SpincastConfig spincastConfig) {
        if (domain == null) {
            domain = spincastConfig.getPublicServerHost();
        }
        if (path == null) {
            path = "/";
        }
        this.name = name;
        this.value = value;
        this.path = path;
        this.domain = domain;
        this.expires = expires;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.discard = discard;
        this.version = version;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public void setExpiresUsingMaxAge(int maxAge) {
        if (maxAge == 0) {
            this.setExpires(null);
        } else if (maxAge < 0) {
            Date date = DateUtils.addYears((Date)new Date(), (int)-1);
            this.setExpires(date);
        } else {
            Date date = DateUtils.addSeconds((Date)new Date(), (int)maxAge);
            this.setExpires(date);
        }
    }

    public boolean isExpired() {
        Date expire = this.getExpires();
        if (expire == null) {
            return false;
        }
        return expire.before(new Date());
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return this.getName() + " - " + this.getValue();
    }
}

