/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.crons;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.plugins.crons.SpincastCronJob;

public abstract class SpincastCronJobBase
implements SpincastCronJob {
    protected final Logger logger = LoggerFactory.getLogger(SpincastCronJobBase.class);
    private volatile boolean running = false;

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (this.running) {
            this.logger.debug("Cron " + this.getClass().getSimpleName() + " is still running, returning...");
            return;
        }
        this.running = true;
        try {
            this.logger.debug("Cron " + this.getClass().getSimpleName() + " starting...");
            this.executeSafe(context);
        }
        finally {
            this.running = false;
            this.logger.trace("Cron " + this.getClass().getSimpleName() + " done.");
        }
    }

    @Override
    public abstract Trigger getTrigger();

    protected abstract void executeSafe(JobExecutionContext var1);
}

