/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.crons;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.server.ServerStartedListener;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.crons.SpincastCronJob;
import org.spincast.plugins.crons.SpincastCronJobRegister;

public class SpincastCronJobRegistrerDefault
implements SpincastCronJobRegister,
ServerStartedListener {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastCronJobRegistrerDefault.class);
    private final Set<SpincastCronJob> cronJobs;
    private final Scheduler scheduler;
    private final SpincastConfig spincastConfig;

    @Inject
    public SpincastCronJobRegistrerDefault(@Nullable Set<SpincastCronJob> cronJobs, @Nullable Set<Set<SpincastCronJob>> cronJobsSets, Scheduler scheduler, SpincastConfig spincastConfig) {
        if (cronJobs == null) {
            cronJobs = new HashSet<SpincastCronJob>();
        }
        if (cronJobsSets != null) {
            cronJobs = new HashSet<SpincastCronJob>(cronJobs);
            for (Set<SpincastCronJob> cronJobsSet : cronJobsSets) {
                if (cronJobsSet == null) continue;
                for (SpincastCronJob cronJob : cronJobsSet) {
                    cronJobs.add(cronJob);
                }
            }
        }
        this.cronJobs = cronJobs;
        this.scheduler = scheduler;
        this.spincastConfig = spincastConfig;
    }

    public void serverStartedSuccessfully() {
        if (!this.getSpincastConfig().isTestingMode() || this.registerCronJobInTestingMode()) {
            this.registerBoundedCronJobs();
        }
    }

    protected Set<SpincastCronJob> getCronJobs() {
        return this.cronJobs;
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    @Override
    public void registerCronJob(SpincastCronJob cronJob) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(cronJob.getClass()).withIdentity(cronJob.getClass().getSimpleName()).build();
            System.out.println(jobDetail.getKey());
            this.getScheduler().scheduleJob(jobDetail, cronJob.getTrigger());
            logger.info("Cron job \"" + cronJob.getClass().getSimpleName() + "\" registered.");
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public void registerBoundedCronJobs() {
        for (SpincastCronJob cronJob : this.getCronJobs()) {
            this.registerCronJob(cronJob);
        }
    }

    protected boolean registerCronJobInTestingMode() {
        return false;
    }
}

