/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.crypto;

import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Base64;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.crypto.SpincastCryptoUtils;
import org.spincast.plugins.crypto.config.SpincastCryptoConfig;

public class SpincastCryptoUtilsDefault
implements SpincastCryptoUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastCryptoUtilsDefault.class);
    private final SpincastCryptoConfig spincastCryptoConfig;

    @Inject
    public SpincastCryptoUtilsDefault(SpincastCryptoConfig spincastCryptoConfig) {
        this.spincastCryptoConfig = spincastCryptoConfig;
    }

    protected SpincastCryptoConfig getSpincastCryptoConfig() {
        return this.spincastCryptoConfig;
    }

    @Inject
    protected void init() {
        if (this.getSpincastCryptoConfig().removeJavaCryptoRestrictionsOnInit()) {
            this.removeCryptographyRestrictions();
        }
    }

    @Override
    public String encrypt(String toEncrypt, String secretKey) {
        try {
            SecretKeySpec aesKey = new SecretKeySpec(this.buildKey(secretKey), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, aesKey);
            byte[] encrypted = cipher.doFinal(toEncrypt.getBytes("UTF-8"));
            String encryptedStr = Base64.getUrlEncoder().encodeToString(encrypted);
            return encryptedStr;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public String decrypt(String encrypted, String secretKey) {
        try {
            byte[] decoded = Base64.getUrlDecoder().decode(encrypted);
            SecretKeySpec aesKey = new SecretKeySpec(this.buildKey(secretKey), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, aesKey);
            String decrypted = new String(cipher.doFinal(decoded), "UTF-8");
            return decrypted;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected byte[] buildKey(String original) {
        try {
            return MessageDigest.getInstance("MD5").digest(original.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public String hashSecure(String toHash, String salt) {
        return BCrypt.hashpw((String)toHash, (String)salt);
    }

    @Override
    public String generateNewHashSecureSalt() {
        return BCrypt.gensalt();
    }

    @Override
    public void removeCryptographyRestrictions() {
        if (!this.isRestrictedCryptographyJavaVersion()) {
            logger.info("Cryptography restrictions removal not needed");
            return;
        }
        try {
            Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
            Class<?> cryptoPermissions = Class.forName("javax.crypto.CryptoPermissions");
            Class<?> cryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
            Field isRestrictedField = jceSecurity.getDeclaredField("isRestricted");
            isRestrictedField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(isRestrictedField, isRestrictedField.getModifiers() & 0xFFFFFFEF);
            isRestrictedField.set(null, false);
            Field defaultPolicyField = jceSecurity.getDeclaredField("defaultPolicy");
            defaultPolicyField.setAccessible(true);
            PermissionCollection defaultPolicy = (PermissionCollection)defaultPolicyField.get(null);
            Field perms = cryptoPermissions.getDeclaredField("perms");
            perms.setAccessible(true);
            ((Map)perms.get(defaultPolicy)).clear();
            Field instance = cryptoAllPermission.getDeclaredField("INSTANCE");
            instance.setAccessible(true);
            defaultPolicy.add((Permission)instance.get(null));
            logger.info("Successfully removed cryptography restrictions");
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public boolean isRestrictedCryptographyJavaVersion() {
        String name = System.getProperty("java.runtime.name");
        String ver = System.getProperty("java.version");
        return name != null && name.equals("Java(TM) SE Runtime Environment") && ver != null && (ver.startsWith("1.7") || ver.startsWith("1.8"));
    }
}

