package org.spincast.plugins.crypto;

import org.spincast.core.guice.SpincastPluginBase;

import com.google.inject.Module;
import com.google.inject.util.Modules;

/**
 * Spincast Crypto plugin.
 */
public class SpincastCryptoPlugin extends SpincastPluginBase {

    public static final String PLUGIN_ID = SpincastCryptoPlugin.class.getName();

    @Override
    public String getId() {
        return PLUGIN_ID;
    }

    @Override
    public Module apply(Module module) {

        Module pluginModule = getPluginModule();
        setContextTypes(pluginModule);

        module = Modules.override(module).with(pluginModule);
        return module;
    }

    protected Module getPluginModule() {
        return new SpincastCryptoPluginModule();
    }

}
