/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.cssyuicompressor.config;

import com.google.inject.Inject;
import java.io.File;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.cssyuicompressor.config.SpincastCssYuiCompressorConfig;
import org.spincast.shaded.org.apache.commons.io.FileUtils;

public class SpincastCssYuiCompressorConfigDefault
implements SpincastCssYuiCompressorConfig {
    private final SpincastConfig spincastConfig;
    private File cssBundlesDir = null;

    @Inject
    public SpincastCssYuiCompressorConfigDefault(SpincastConfig spincastConfig) {
        this.spincastConfig = spincastConfig;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    @Override
    public String getCssBundlePebbleFunctionName() {
        return "cssBundle";
    }

    @Override
    public String getCssBundlesUrlPath() {
        return "/spincast/plugins/cssyuicompressor/cssbundles";
    }

    @Override
    public File getCssBundlesDir() {
        if (this.cssBundlesDir == null || !this.cssBundlesDir.isDirectory()) {
            File dir = new File(this.getSpincastConfig().getWritableRootDir(), "spincast/plugins/cssyuicompressor/cssBundles");
            if (!dir.isDirectory()) {
                try {
                    FileUtils.forceMkdir((File)dir);
                }
                catch (Exception ex) {
                    throw SpincastStatics.runtimize((Exception)ex);
                }
            }
            this.cssBundlesDir = dir;
        }
        return this.cssBundlesDir;
    }

    @Override
    public boolean isCssBundlesIgnoreSslCertificateErrors() {
        return this.getSpincastConfig().isDevelopmentMode() || this.getSpincastConfig().isTestingMode();
    }
}

