/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.dateformatter;

import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.util.TimeZone;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.timezone.TimeZoneResolver;

public class TimeZoneResolverDefault
implements TimeZoneResolver {
    private final SpincastConfig spincastConfig;
    private final Provider<RequestContext<?>> requestContextProvider;

    @Inject
    public TimeZoneResolverDefault(SpincastConfig spincastConfig, Provider<RequestContext<?>> requestContextProvider) {
        this.spincastConfig = spincastConfig;
        this.requestContextProvider = requestContextProvider;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Provider<RequestContext<?>> getRequestContextProvider() {
        return this.requestContextProvider;
    }

    public TimeZone getTimeZoneToUse() {
        try {
            RequestContext context = (RequestContext)this.getRequestContextProvider().get();
            String cookieValue = context.request().getCookie(this.getSpincastConfig().getCookieNameTimeZoneId());
            if (cookieValue != null) {
                try {
                    TimeZone timeZone = TimeZone.getTimeZone(cookieValue);
                    return timeZone;
                }
                catch (Exception ex) {
                    context.response().deleteCookie(this.getSpincastConfig().getCookieNameTimeZoneId());
                }
            }
        }
        catch (OutOfScopeException | ProvisionException context) {
            // empty catch block
        }
        TimeZone timeZone = this.getSpincastConfig().getDefaultTimeZone();
        if (timeZone == null) {
            timeZone = TimeZone.getTimeZone("UTC");
        }
        return timeZone;
    }
}

