/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.flywayutils;

import java.util.Objects;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.MigrationExecutor;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.util.ClassUtils;
import org.spincast.plugins.flywayutils.SpincastFlywayJdbcMigrationExecutor;
import org.spincast.plugins.flywayutils.SpincastFlywayMigration;

public class SpincastFlywayResolvedMigration
implements ResolvedMigration {
    private MigrationVersion version;
    private String description;
    private String script;
    private String physicalLocation;
    private MigrationExecutor executor;
    private final SpincastFlywayMigration spincastFlywayMigration;

    public SpincastFlywayResolvedMigration(SpincastFlywayMigration spincastFlywayMigration) {
        Objects.requireNonNull(spincastFlywayMigration, "The spincastFlywayMigration can't be NULL");
        this.spincastFlywayMigration = spincastFlywayMigration;
    }

    protected SpincastFlywayMigration getSpincastFlywayMigration() {
        return this.spincastFlywayMigration;
    }

    public MigrationVersion getVersion() {
        if (this.version == null) {
            String temp = this.getSpincastFlywayMigration().getClass().getSimpleName();
            if (!temp.startsWith("M_")) {
                throw new RuntimeException("Invalid migration class name. Must start with 'M_' followed by the version. For example: 'M_2018_09_18_00' or 'M_1_44_0__someDescription'.");
            }
            int pos = (temp = temp.substring("M_".length())).indexOf("__");
            if (pos > -1) {
                temp = temp.substring(0, pos);
            }
            this.version = MigrationVersion.fromVersion((String)temp);
        }
        return this.version;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "Migration " + this.getSpincastFlywayMigration().getClass().getSimpleName();
        }
        return this.description;
    }

    public String getScript() {
        if (this.script == null) {
            this.script = this.getSpincastFlywayMigration().getClass().getName();
        }
        return this.script;
    }

    public Integer getChecksum() {
        return null;
    }

    public MigrationType getType() {
        return MigrationType.JDBC;
    }

    public String getPhysicalLocation() {
        if (this.physicalLocation == null) {
            this.physicalLocation = ClassUtils.getLocationOnDisk(this.getSpincastFlywayMigration().getClass());
        }
        return this.physicalLocation;
    }

    public MigrationExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new SpincastFlywayJdbcMigrationExecutor(this.getSpincastFlywayMigration());
        }
        return this.executor;
    }
}

