/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.flywayutils;

import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.resolver.Context;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.flywayutils.SpincastFlywayMigration;
import org.spincast.plugins.flywayutils.SpincastFlywayMigrationContext;
import org.spincast.plugins.flywayutils.SpincastFlywayResolvedMigration;
import org.spincast.plugins.jdbc.JdbcUtils;
import org.spincast.plugins.jdbc.SpincastDataSourceFactory;

public class SpincastFlywayMigrationContextDefault
implements SpincastFlywayMigrationContext {
    private final DataSource dataSource;
    private final String migrationsPackage;
    private final Provider<Injector> injectorProvider;
    private final JdbcUtils jdbcUtils;
    private final SpincastConfig spincastConfig;
    private final SpincastDataSourceFactory spincastDataSourceFactory;
    private final String schema;

    @AssistedInject
    public SpincastFlywayMigrationContextDefault(@Assisted DataSource dataSource, @Assisted(value="migrationsPackage") String migrationsPackage, Provider<Injector> injectorProvider, JdbcUtils jdbcUtils, SpincastConfig spincastConfig, SpincastDataSourceFactory spincastDataSourceFactory) {
        this(dataSource, null, migrationsPackage, injectorProvider, jdbcUtils, spincastConfig, spincastDataSourceFactory);
    }

    @AssistedInject
    public SpincastFlywayMigrationContextDefault(@Assisted DataSource dataSource, @Assisted(value="schema") @Nullable String schema, @Assisted(value="migrationsPackage") String migrationsPackage, Provider<Injector> injectorProvider, JdbcUtils jdbcUtils, SpincastConfig spincastConfig, SpincastDataSourceFactory spincastDataSourceFactory) {
        this.dataSource = dataSource;
        this.migrationsPackage = migrationsPackage;
        this.injectorProvider = injectorProvider;
        this.jdbcUtils = jdbcUtils;
        this.spincastConfig = spincastConfig;
        this.spincastDataSourceFactory = spincastDataSourceFactory;
        this.schema = schema;
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected String getMigrationsPackage() {
        return this.migrationsPackage;
    }

    protected Injector getInjector() {
        return (Injector)this.injectorProvider.get();
    }

    protected JdbcUtils getJdbcUtils() {
        return this.jdbcUtils;
    }

    protected String getSchema() {
        return this.schema;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastDataSourceFactory getSpincastDataSourceFactory() {
        return this.spincastDataSourceFactory;
    }

    @Override
    public void migrate() {
        Flyway flyway = this.createFlyway();
        flyway.migrate();
    }

    protected boolean isValidateOnMigrate() {
        return !this.getSpincastConfig().isTestingMode();
    }

    protected Flyway createFlyway() {
        FluentConfiguration builder = Flyway.configure().dataSource(this.getDataSource()).resolvers(new MigrationResolver[]{this}).skipDefaultResolvers(true).validateOnMigrate(this.isValidateOnMigrate()).skipDefaultCallbacks(true);
        String schema = this.getSchema();
        if (schema != null) {
            builder = builder.schemas(new String[]{schema});
        }
        Flyway flyway = new Flyway((Configuration)builder);
        return flyway;
    }

    public Collection<ResolvedMigration> resolveMigrations(Context context) {
        try {
            ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
            Reflections reflections = new Reflections(this.getMigrationsPackage(), new Scanner[0]);
            Set classes = reflections.getSubTypesOf(SpincastFlywayMigration.class);
            for (Class clazz : classes) {
                String classPackage;
                if (Modifier.isAbstract(clazz.getModifiers()) || !(classPackage = clazz.getPackage().getName()).equals(this.getMigrationsPackage()) && !classPackage.startsWith(this.getMigrationsPackage() + ".")) continue;
                SpincastFlywayMigration spincastFlywayMigration = (SpincastFlywayMigration)this.getInjector().getInstance(clazz);
                ResolvedMigration resolvedMigration = this.convertToResolvedMigration(spincastFlywayMigration);
                migrations.add(resolvedMigration);
            }
            Collections.sort(migrations, new ResolvedMigrationComparator());
            return migrations;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected ResolvedMigration convertToResolvedMigration(SpincastFlywayMigration spincastFlywayMigration) {
        return new SpincastFlywayResolvedMigration(spincastFlywayMigration);
    }
}

