/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.flywayutils;

import com.google.inject.Inject;
import java.sql.Connection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.plugins.flywayutils.SpincastFlywayMigration;
import org.spincast.plugins.jdbc.ConnectionScope;
import org.spincast.plugins.jdbc.JdbcUtils;

public abstract class SpincastFlywayMigrationBase
implements SpincastFlywayMigration {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastFlywayMigrationBase.class);
    private final DataSource dataSource;
    private final JdbcUtils jdbcUtils;

    @Inject
    public SpincastFlywayMigrationBase(DataSource dataSource, JdbcUtils jdbcUtils) {
        this.dataSource = dataSource;
        this.jdbcUtils = jdbcUtils;
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected JdbcUtils getJdbcUtils() {
        return this.jdbcUtils;
    }

    @Override
    public final void migrate(Connection connection) throws Exception {
        this.getJdbcUtils().scopes().specificConnection(connection, this.getDataSource(), (ConnectionScope)new ConnectionScope<Void>(){

            public Void run(Connection connection) throws Exception {
                SpincastFlywayMigrationBase.this.runMigration(connection);
                logger.info("Migration \"" + SpincastFlywayMigrationBase.this.getClass().getSimpleName() + "\" applied.");
                return null;
            }
        });
    }

    protected abstract void runMigration(Connection var1);
}

