/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.formsprotection.doublesubmit;

import com.google.inject.Inject;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.dictionary.Dictionary;
import org.spincast.core.exceptions.PublicExceptionDefault;
import org.spincast.core.exceptions.RedirectException;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.flash.FlashMessageFactory;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.crypto.SpincastCryptoUtils;
import org.spincast.plugins.formsprotection.config.SpincastFormsProtectionConfig;
import org.spincast.plugins.formsprotection.dictionary.SpincastFormsProtectionPluginDictionaryEntries;
import org.spincast.plugins.formsprotection.doublesubmit.SpincastFormsDoubleSubmitProtectionFilter;
import org.spincast.plugins.formsprotection.doublesubmit.SpincastFormsDoubleSubmitProtectionRepository;
import org.spincast.plugins.formsprotection.exceptions.FormAlreadySubmittedException;
import org.spincast.plugins.formsprotection.exceptions.FormTooOldException;
import org.spincast.shaded.org.apache.commons.lang3.tuple.Pair;

public class SpincastFormsDoubleSubmitProtectionFilterDefault
implements SpincastFormsDoubleSubmitProtectionFilter {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastFormsDoubleSubmitProtectionFilterDefault.class);
    private final SpincastFormsProtectionConfig spincastFormsProtectionConfig;
    private final FlashMessageFactory flashMessageFactory;
    private final Dictionary dictionary;
    private final SpincastCryptoUtils cryptoUtils;
    private final SpincastFormsDoubleSubmitProtectionRepository spincastFormsDoubleSubmitProtectionRepository;
    private final String formDoubleSubmitPrivateKey;

    @Inject
    public SpincastFormsDoubleSubmitProtectionFilterDefault(SpincastFormsProtectionConfig spincastFormsProtectionConfig, FlashMessageFactory flashMessageFactory, Dictionary dictionary, SpincastCryptoUtils cryptoUtils, SpincastFormsDoubleSubmitProtectionRepository spincastFormsDoubleSubmitProtectionRepository) {
        this.spincastFormsProtectionConfig = spincastFormsProtectionConfig;
        this.flashMessageFactory = flashMessageFactory;
        this.dictionary = dictionary;
        this.cryptoUtils = cryptoUtils;
        this.spincastFormsDoubleSubmitProtectionRepository = spincastFormsDoubleSubmitProtectionRepository;
        this.formDoubleSubmitPrivateKey = UUID.randomUUID().toString();
    }

    protected SpincastFormsProtectionConfig getSpincastFormsProtectionConfig() {
        return this.spincastFormsProtectionConfig;
    }

    protected FlashMessageFactory getFlashMessageFactory() {
        return this.flashMessageFactory;
    }

    protected Dictionary getDictionary() {
        return this.dictionary;
    }

    protected SpincastCryptoUtils getCryptoUtils() {
        return this.cryptoUtils;
    }

    protected SpincastFormsDoubleSubmitProtectionRepository getSpincastFormsDoubleSubmitProtectionRepository() {
        return this.spincastFormsDoubleSubmitProtectionRepository;
    }

    @Override
    public void handle(RequestContext<?> context) throws FormAlreadySubmittedException, FormTooOldException {
        if (context.routing().getRoutingResult().getMainRouteHandlerMatch().getSourceRoute().isStaticResourceRoute()) {
            return;
        }
        if (context.routing().isForwarded()) {
            return;
        }
        try {
            HttpMethod method = context.request().getHttpMethod();
            if (method == HttpMethod.GET || method == HttpMethod.HEAD || method == HttpMethod.OPTIONS || method == HttpMethod.CONNECT) {
                return;
            }
            Map formDatas = context.request().getFormBodyRaw();
            if (formDatas == null || formDatas.size() == 0) {
                return;
            }
            String noDoubleSubmitProtection = context.request().getFormBodyAsJsonObject().getString(this.getSpincastFormsProtectionConfig().getFormDoubleSubmitDisableProtectionIdFieldName());
            if (noDoubleSubmitProtection != null) {
                return;
            }
            String payload = context.request().getFormBodyAsJsonObject().getString(this.getSpincastFormsProtectionConfig().getFormDoubleSubmitProtectionIdFieldName());
            if (payload == null) {
                logger.warn("Submitted form without a protection id: " + context.request().getFullUrl());
                throw new RedirectException("/");
            }
            Pair<Instant, String> info = this.getSubmittedFormInfo(payload);
            if (info == null) {
                logger.warn("Submitted form with an invalid form info payload'" + payload + "' : " + context.request().getFullUrl());
                this.invalidFormMatchAction(context, this.getDictionary().get(SpincastFormsProtectionPluginDictionaryEntries.MESSAGE_KEY_FORM_INVALID_PROTECTION_ID));
                return;
            }
            if (((Instant)info.getKey()).isBefore(Instant.now().minus(this.getSpincastFormsProtectionConfig().getFormDoubleSubmitFormValidForNbrMinutes(), ChronoUnit.MINUTES))) {
                logger.warn("Form too old '" + info.getKey() + "' : " + context.request().getFullUrl());
                this.invalidFormMatchAction(context, this.getDictionary().get(SpincastFormsProtectionPluginDictionaryEntries.MESSAGE_KEY_FORM_TOO_OLD));
            }
            if (this.getSpincastFormsDoubleSubmitProtectionRepository().isFormAlreadySubmitted((String)info.getValue())) {
                logger.debug("Form submitted with an already used protection id : " + context.request().getFullUrl() + " => " + (String)info.getValue());
                this.invalidFormMatchAction(context, this.getDictionary().get(SpincastFormsProtectionPluginDictionaryEntries.MESSAGE_KEY_FORM_ALREADY_SUBMITTED));
            }
            this.getSpincastFormsDoubleSubmitProtectionRepository().saveSubmittedFormProtectionId((Instant)info.getKey(), (String)info.getValue());
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public String createNewFormDoubleSubmitProtectionId() {
        String protectionId = Instant.now() + "|" + UUID.randomUUID().toString();
        protectionId = this.getCryptoUtils().encrypt(protectionId, this.getFormDoubleSubmitPrivateKey());
        return protectionId;
    }

    protected Pair<Instant, String> getSubmittedFormInfo(String payloadEncrypted) {
        try {
            String payload = this.getCryptoUtils().decrypt(payloadEncrypted, this.getFormDoubleSubmitPrivateKey());
            if (payload == null) {
                return null;
            }
            int pos = payload.indexOf("|");
            Instant date = Instant.parse(payload.substring(0, pos));
            String protectionId = payload.substring(pos + 1);
            return Pair.of((Object)date, (Object)protectionId);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected void invalidFormMatchAction(RequestContext<?> context, String message) throws Exception {
        throw new PublicExceptionDefault(message, 400);
    }

    protected String getFormDoubleSubmitPrivateKey() {
        return this.formDoubleSubmitPrivateKey;
    }
}

