/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.formsprotection.csrf;

import com.google.inject.Inject;
import java.net.URI;
import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.dictionary.Dictionary;
import org.spincast.core.exceptions.PublicExceptionDefault;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.json.JsonObject;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.crypto.SpincastCryptoUtils;
import org.spincast.plugins.formsprotection.config.SpincastFormsProtectionConfig;
import org.spincast.plugins.formsprotection.csrf.SpincastCsrfToken;
import org.spincast.plugins.formsprotection.csrf.SpincastFormsCsrfProtectionFilter;
import org.spincast.plugins.formsprotection.dictionary.SpincastFormsProtectionPluginDictionaryEntries;
import org.spincast.plugins.formsprotection.exceptions.FormInvalidCsrfTokenException;
import org.spincast.plugins.formsprotection.exceptions.FormInvalidOriginException;
import org.spincast.plugins.session.SpincastSession;
import org.spincast.plugins.session.SpincastSessionFilter;
import org.spincast.plugins.session.SpincastSessionManager;

public class SpincastFormsCsrfProtectionFilterDefault
implements SpincastFormsCsrfProtectionFilter {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastFormsCsrfProtectionFilterDefault.class);
    private final SpincastFormsProtectionConfig spincastFormsProtectionConfig;
    private final SpincastCryptoUtils spincastCryptoUtils;
    private final SpincastSessionManager spincastSessionManager;
    private final SpincastConfig spincastConfig;
    private final Dictionary dictionary;

    @Inject
    public SpincastFormsCsrfProtectionFilterDefault(SpincastFormsProtectionConfig spincastFormsProtectionConfig, SpincastCryptoUtils spincastCryptoUtils, SpincastSessionManager spincastSessionManager, SpincastConfig spincastConfig, Dictionary dictionary) {
        this.spincastFormsProtectionConfig = spincastFormsProtectionConfig;
        this.spincastCryptoUtils = spincastCryptoUtils;
        this.spincastSessionManager = spincastSessionManager;
        this.spincastConfig = spincastConfig;
        this.dictionary = dictionary;
    }

    protected SpincastFormsProtectionConfig getSpincastFormsProtectionConfig() {
        return this.spincastFormsProtectionConfig;
    }

    protected SpincastCryptoUtils getSpincastCryptoUtils() {
        return this.spincastCryptoUtils;
    }

    protected SpincastSessionManager getSpincastSessionManager() {
        return this.spincastSessionManager;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Dictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public void handle(RequestContext<?> context) throws FormInvalidOriginException, FormInvalidCsrfTokenException {
        if (context.routing().getRoutingResult().getMainRouteHandlerMatch().getSourceRoute().isStaticResourceRoute()) {
            return;
        }
        try {
            SpincastSession currentSession = this.getSpincastSessionManager().getCurrentSession();
            if (currentSession == null) {
                throw new RuntimeException("No Session available. Makes sur the " + SpincastSessionFilter.class.getSimpleName() + " filter is run *before* this " + SpincastFormsCsrfProtectionFilter.class.getSimpleName() + " filter!");
            }
            SpincastCsrfToken userCsrfToken = this.getCurrentCsrfToken(false);
            HttpMethod method = context.request().getHttpMethod();
            if (method == HttpMethod.GET || method == HttpMethod.HEAD || method == HttpMethod.OPTIONS || method == HttpMethod.CONNECT) {
                return;
            }
            if (userCsrfToken == null) {
                logger.debug("No CSRF token found in the user's session...");
                this.csrfDoesntMatchAction(context, this.getDictionary().get(SpincastFormsProtectionPluginDictionaryEntries.MESSAGE_KEY_FORM_CSRF_TOKEN_NOT_FOUND_IN_SESSION));
            }
            String csrfTokenName = this.getSpincastFormsProtectionConfig().getFormCsrfProtectionIdFieldName();
            String csrfTokenSubmitted = context.request().getFormBodyAsJsonObject().getString(csrfTokenName);
            if (csrfTokenSubmitted == null && (csrfTokenSubmitted = context.request().getQueryStringParamFirst(csrfTokenName)) == null) {
                logger.warn(context.request().getHttpMethod() + " without a CSRF \"" + csrfTokenName + "\" token : " + context.request().getFullUrl());
                this.csrfDoesntMatchAction(context, this.getDictionary().get(SpincastFormsProtectionPluginDictionaryEntries.MESSAGE_KEY_FORM_NO_CSRF_TOKEN_PROVIDED));
                return;
            }
            if (!csrfTokenSubmitted.equals(userCsrfToken.getId())) {
                logger.warn("Request with an invalid CSRF token : " + context.request().getFullUrl() + " => " + userCsrfToken);
                this.csrfDoesntMatchAction(context, this.getDictionary().get(SpincastFormsProtectionPluginDictionaryEntries.MESSAGE_KEY_FORM_INVALID_CSRF_TOKEN));
                return;
            }
            String origin = context.request().getHeaderFirst("Origin");
            String referer = context.request().getHeaderFirst("Referer");
            if (origin == null && referer == null) {
                logger.warn("Request without origin or referer header : " + context.request().getFullUrl());
                this.csrfDoesntMatchAction(context, this.getDictionary().get(SpincastFormsProtectionPluginDictionaryEntries.MESSAGE_KEY_FORM_INVALID_ORGIN));
                return;
            }
            if (origin != null) {
                URI uri = new URI(origin);
                if (!this.getSpincastConfig().getPublicServerHost().equalsIgnoreCase(uri.getHost())) {
                    logger.warn("Request with origin header '" + uri.getHost() + "' that doesn't contain the right host : " + this.getSpincastConfig().getPublicServerHost());
                    this.csrfDoesntMatchAction(context, this.getDictionary().get(SpincastFormsProtectionPluginDictionaryEntries.MESSAGE_KEY_FORM_INVALID_ORGIN));
                    return;
                }
            } else if (referer != null) {
                URI uri = new URI(referer);
                if (!this.getSpincastConfig().getPublicServerHost().equalsIgnoreCase(uri.getHost())) {
                    logger.warn("Request with referer header '" + uri.getHost() + "' that doesn't contain the right host : " + this.getSpincastConfig().getPublicServerHost());
                    this.csrfDoesntMatchAction(context, this.getDictionary().get(SpincastFormsProtectionPluginDictionaryEntries.MESSAGE_KEY_FORM_INVALID_ORGIN));
                    return;
                }
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public SpincastCsrfToken getCurrentCsrfToken() {
        return this.getCurrentCsrfToken(true);
    }

    public SpincastCsrfToken getCurrentCsrfToken(boolean createItIfNoneExists) {
        SpincastCsrfToken spincastCsrfToken = null;
        SpincastSession currentSession = this.getSpincastSessionManager().getCurrentSession();
        if (currentSession == null) {
            throw new RuntimeException("No session available to retrieve/save a CSRF token! Make sure the " + SpincastSessionFilter.class.getSimpleName() + " before filter is installed and run *before* the " + SpincastFormsCsrfProtectionFilter.class.getSimpleName() + " one!");
        }
        JsonObject csrfTokenJsonObj = currentSession.getAttributes().getJsonObject(SpincastFormsProtectionConfig.SESSION_VARIABLE_NAME_CSRF_TOKEN);
        if (csrfTokenJsonObj != null) {
            spincastCsrfToken = new SpincastCsrfToken(csrfTokenJsonObj.getString("id"), csrfTokenJsonObj.getInstant("creationDate"));
        }
        if (spincastCsrfToken == null && createItIfNoneExists) {
            spincastCsrfToken = this.createCsrfToken();
            currentSession.getAttributes().set(SpincastFormsProtectionConfig.SESSION_VARIABLE_NAME_CSRF_TOKEN, (Object)spincastCsrfToken);
        }
        return spincastCsrfToken;
    }

    protected SpincastCsrfToken createCsrfToken() {
        try {
            String key = UUID.randomUUID().toString();
            key = Base64.getUrlEncoder().encodeToString(key.getBytes("UTF-8"));
            SpincastCsrfToken token = new SpincastCsrfToken(key, Instant.now());
            return token;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected void csrfDoesntMatchAction(RequestContext<?> context, String message) throws Exception {
        throw new PublicExceptionDefault(message, 400);
    }
}

