/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.gson.serializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.inject.Inject;
import java.lang.reflect.Type;
import java.util.Map;
import org.spincast.core.json.JsonObjectFactory;

public class JsonObjectDeserializer
implements JsonDeserializer<org.spincast.core.json.JsonObject> {
    private final JsonObjectFactory jsonObjectFactory;

    @Inject
    public JsonObjectDeserializer(JsonObjectFactory jsonObjectFactory) {
        this.jsonObjectFactory = jsonObjectFactory;
    }

    protected JsonObjectFactory getJsonObjectFactory() {
        return this.jsonObjectFactory;
    }

    public org.spincast.core.json.JsonObject deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject gsonObj = jsonElement.getAsJsonObject();
        if (gsonObj == null) {
            return null;
        }
        org.spincast.core.json.JsonObject jsonObject = this.getJsonObjectFactory().create();
        for (Map.Entry entry : gsonObj.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement gsonSubObj = (JsonElement)entry.getValue();
            jsonObject.set(key, (Object)gsonSubObj);
        }
        return jsonObject;
    }
}

