/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.gson.serializers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.Type;
import java.util.Map;
import org.spincast.plugins.gson.SpincastGsonManager;

public class JsonObjectSerializer
implements JsonSerializer<org.spincast.core.json.JsonObject> {
    private final Provider<SpincastGsonManager> spincastGsonManagerProvider;

    @Inject
    public JsonObjectSerializer(Provider<SpincastGsonManager> spincastGsonManagerProvider) {
        this.spincastGsonManagerProvider = spincastGsonManagerProvider;
    }

    protected SpincastGsonManager getSpincastGsonManager() {
        return (SpincastGsonManager)this.spincastGsonManagerProvider.get();
    }

    public JsonElement serialize(org.spincast.core.json.JsonObject jsonObject, Type typeOfSrc, JsonSerializationContext context) {
        if (jsonObject == null) {
            return null;
        }
        JsonObject gsonObject = new JsonObject();
        for (Map.Entry entry : jsonObject) {
            String key = (String)entry.getKey();
            Object el = entry.getValue();
            JsonElement jsonElement = this.getSpincastGsonManager().convertJsonObjectElementToGsonJsonElement(el);
            gsonObject.add(key, jsonElement);
        }
        return gsonObject;
    }
}

