/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.JsonObjectFactory;
import org.spincast.core.json.JsonObjectOrArray;
import org.spincast.core.json.JsonPathUtils;
import org.spincast.core.request.Form;
import org.spincast.core.request.FormFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.io.IOUtils;

public class SpincastGsonManager
implements JsonManager {
    private final JsonDeserializer<JsonObject> jsonObjectDeserializer;
    private final JsonDeserializer<JsonArray> jsonArrayDeserializer;
    private final JsonSerializer<JsonObject> jsonObjectSerializer;
    private final JsonSerializer<JsonArray> jsonArraySerializer;
    private final JsonSerializer<Date> dateSerializer;
    private final JsonSerializer<Instant> instantSerializer;
    private final JsonSerializer<BigDecimal> bigDecimalSerializer;
    private final JsonSerializer<Enum<?>> enumSerializer;
    private final JsonSerializer<Class<?>> classSerializer;
    private final JsonSerializer<Throwable> throwableSerializer;
    private final JsonPathUtils jsonPathUtils;
    private final JsonObjectFactory jsonObjectFactory;
    private final SpincastConfig spincastConfig;
    private final SpincastUtils spincastUtils;
    private final FormFactory formFactory;
    private final Provider<Injector> guiceProvider;
    private Gson gson;
    private Gson gsonPrettyPrinting;

    @Inject
    public SpincastGsonManager(JsonDeserializer<JsonObject> jsonObjectDeserializer, JsonDeserializer<JsonArray> jsonArrayDeserializer, JsonSerializer<JsonObject> jsonObjectSerializer, JsonSerializer<JsonArray> jsonArraySerializer, JsonSerializer<Date> dateSerializer, JsonSerializer<Instant> instantSerializer, JsonSerializer<BigDecimal> bigDecimalSerializer, JsonSerializer<Enum<?>> enumSerializer, JsonSerializer<Class<?>> classSerializer, JsonSerializer<Throwable> throwableSerializer, JsonPathUtils jsonPathUtils, JsonObjectFactory jsonObjectFactory, SpincastConfig spincastConfig, SpincastUtils spincastUtils, FormFactory formFactory, Provider<Injector> guiceProvider) {
        this.jsonObjectDeserializer = jsonObjectDeserializer;
        this.jsonArrayDeserializer = jsonArrayDeserializer;
        this.jsonObjectSerializer = jsonObjectSerializer;
        this.jsonArraySerializer = jsonArraySerializer;
        this.dateSerializer = dateSerializer;
        this.instantSerializer = instantSerializer;
        this.bigDecimalSerializer = bigDecimalSerializer;
        this.classSerializer = classSerializer;
        this.throwableSerializer = throwableSerializer;
        this.jsonPathUtils = jsonPathUtils;
        this.jsonObjectFactory = jsonObjectFactory;
        this.enumSerializer = enumSerializer;
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
        this.formFactory = formFactory;
        this.guiceProvider = guiceProvider;
    }

    protected JsonDeserializer<JsonObject> getJsonObjectDeserializer() {
        return this.jsonObjectDeserializer;
    }

    protected JsonDeserializer<JsonArray> getJsonArrayDeserializer() {
        return this.jsonArrayDeserializer;
    }

    protected JsonSerializer<JsonObject> getJsonObjectSerializer() {
        return this.jsonObjectSerializer;
    }

    protected JsonSerializer<JsonArray> getJsonArraySerializer() {
        return this.jsonArraySerializer;
    }

    protected JsonSerializer<Date> getDateSerializer() {
        return this.dateSerializer;
    }

    protected JsonSerializer<Instant> getInstantSerializer() {
        return this.instantSerializer;
    }

    protected JsonSerializer<BigDecimal> getBigDecimalSerializer() {
        return this.bigDecimalSerializer;
    }

    protected JsonSerializer<Enum<?>> getEnumSerializer() {
        return this.enumSerializer;
    }

    protected JsonSerializer<Class<?>> getClassSerializer() {
        return this.classSerializer;
    }

    protected JsonSerializer<Throwable> getThrowableSerializer() {
        return this.throwableSerializer;
    }

    protected JsonPathUtils getJsonPathUtils() {
        return this.jsonPathUtils;
    }

    protected JsonObjectFactory getJsonObjectFactory() {
        return this.jsonObjectFactory;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected FormFactory getFormFactory() {
        return this.formFactory;
    }

    protected Injector getGuice() {
        return (Injector)this.guiceProvider.get();
    }

    public Gson getGson() {
        if (this.gson == null) {
            this.createGsons();
        }
        return this.gson;
    }

    public Gson getGsonPrettyPrinting() {
        if (this.gsonPrettyPrinting == null) {
            this.createGsons();
        }
        return this.gsonPrettyPrinting;
    }

    protected void createGsons() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        this.configureGsonBuilder(gsonBuilder);
        this.gson = gsonBuilder.create();
        this.gsonPrettyPrinting = gsonBuilder.setPrettyPrinting().create();
    }

    protected void configureGsonBuilder(GsonBuilder gsonBuilder) {
        this.registerCustomDeserializers(gsonBuilder);
        this.registerCustomSerializers(gsonBuilder);
    }

    protected void registerCustomDeserializers(GsonBuilder gsonBuilder) {
        this.registerJsonObjectDeserializer(gsonBuilder);
        this.registerJsonArrayDeserializer(gsonBuilder);
    }

    protected void registerJsonObjectDeserializer(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeHierarchyAdapter(JsonObject.class, this.getJsonObjectDeserializer());
    }

    protected void registerJsonArrayDeserializer(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeHierarchyAdapter(JsonArray.class, this.getJsonArrayDeserializer());
    }

    protected void registerCustomSerializers(GsonBuilder gsonBuilder) {
        this.registerJsonObjectSerializer(gsonBuilder);
        this.registerJsonArraySerializer(gsonBuilder);
        this.registerDateSerializer(gsonBuilder);
        this.registerInstantSerializer(gsonBuilder);
        this.registerBigDecimalSerializer(gsonBuilder);
        this.registerEnumSerializer(gsonBuilder);
        this.registerClassSerializer(gsonBuilder);
        this.registerThrowableSerializer(gsonBuilder);
    }

    protected void registerJsonObjectSerializer(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeHierarchyAdapter(JsonObject.class, this.getJsonObjectSerializer());
    }

    protected void registerJsonArraySerializer(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeHierarchyAdapter(JsonArray.class, this.getJsonArraySerializer());
    }

    protected void registerDateSerializer(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeHierarchyAdapter(Date.class, this.getDateSerializer());
    }

    protected void registerInstantSerializer(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter(Instant.class, this.getInstantSerializer());
    }

    protected void registerBigDecimalSerializer(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeHierarchyAdapter(BigDecimal.class, this.getBigDecimalSerializer());
    }

    protected void registerEnumSerializer(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeHierarchyAdapter(Enum.class, this.getEnumSerializer());
    }

    protected void registerClassSerializer(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeHierarchyAdapter(Class.class, this.getClassSerializer());
    }

    protected void registerThrowableSerializer(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeHierarchyAdapter(Throwable.class, this.getThrowableSerializer());
    }

    public JsonObject create() {
        return this.getJsonObjectFactory().create();
    }

    public JsonArray createArray() {
        return this.getJsonObjectFactory().createArray();
    }

    public JsonObject fromObject(Object object) {
        if (object == null) {
            return null;
        }
        String json = this.getGson().toJson(object);
        JsonObject jsonObject = this.fromString(json);
        return jsonObject;
    }

    public JsonObject fromMap(Map<String, ?> params) {
        return this.fromMap(params, false);
    }

    public JsonObject fromMap(Map<String, ?> params, boolean parseKeysAsJsonPaths) {
        if (params == null) {
            return null;
        }
        JsonObject root = this.create();
        if (parseKeysAsJsonPaths && params.size() > this.getMaxNumberOfKeysWhenConvertingMapToJsonObject()) {
            throw new RuntimeException("Too many keys to parse : " + params.size() + " as JsonPaths. The maximum is currently set to " + this.getMaxNumberOfKeysWhenConvertingMapToJsonObject());
        }
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (parseKeysAsJsonPaths) {
                this.putElementAtJsonPath((JsonObjectOrArray)root, key, value, true);
                continue;
            }
            root.setNoKeyParsing(key, value);
        }
        return root;
    }

    public JsonObject fromInputStream(InputStream inputStream) {
        try {
            if (inputStream == null) {
                return null;
            }
            String json = IOUtils.toString((InputStream)inputStream, (String)this.getFromInputStreamEncoding());
            JsonObject obj = this.fromString(json);
            this.injectDependencies(obj);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected String getFromInputStreamEncoding() {
        return "UTF-8";
    }

    public JsonObject fromFile(File jsonFile) {
        try {
            if (jsonFile == null || !jsonFile.exists()) {
                return null;
            }
            String json = FileUtils.readFileToString((File)jsonFile, (String)this.getFromFileEncoding());
            JsonObject jsonObject = this.fromString(json);
            return jsonObject;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected String getFromFileEncoding() {
        return "UTF-8";
    }

    public JsonObject fromFile(String jsonFilePath) {
        if (jsonFilePath == null) {
            return null;
        }
        File file = new File(jsonFilePath);
        return this.fromFile(file);
    }

    public JsonObject fromClasspathFile(String path) {
        if (path == null) {
            return null;
        }
        String json = this.getSpincastUtils().readClasspathFile(path, this.getFromClasspathFileEncoding());
        return this.fromString(json);
    }

    protected String getFromClasspathFileEncoding() {
        return "UTF-8";
    }

    public Map<String, Object> fromStringToMap(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        JsonObject jsonObject = this.fromString(jsonString);
        return jsonObject.convertToPlainMap();
    }

    public Map<String, Object> fromInputStreamToMap(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        JsonObject jsonObject = this.fromInputStream(inputStream);
        return jsonObject.convertToPlainMap();
    }

    public JsonObject fromString(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        JsonObject obj = (JsonObject)this.getGson().fromJson(jsonString, JsonObject.class);
        this.injectDependencies(obj);
        return obj;
    }

    public <T> T fromString(String jsonString, Class<T> clazz) {
        Object obj = this.getGson().fromJson(jsonString, clazz);
        this.injectDependencies(obj);
        return (T)obj;
    }

    public <T> T fromInputStream(InputStream inputStream, Class<T> clazz) {
        try {
            if (inputStream == null) {
                return null;
            }
            String jsonString = IOUtils.toString((InputStream)inputStream, (String)this.getFromInputStreamEncoding());
            Object obj = this.getGson().fromJson(jsonString, clazz);
            this.injectDependencies(obj);
            return (T)obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public JsonArray fromCollectionToJsonArray(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        JsonArray jsonArray = this.createArray();
        for (Object el : collection) {
            jsonArray.add(el);
        }
        return jsonArray;
    }

    public JsonArray fromStringArray(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        JsonArray jsonArray = (JsonArray)this.getGson().fromJson(jsonString, JsonArray.class);
        this.injectDependencies(jsonArray);
        return jsonArray;
    }

    public JsonArray fromListArray(List<?> elements) {
        if (elements == null) {
            return null;
        }
        JsonArray jsonArray = this.createArray();
        for (Object el : elements) {
            jsonArray.add(el);
        }
        return jsonArray;
    }

    public JsonArray fromInputStreamArray(InputStream inputStream) {
        try {
            if (inputStream == null) {
                return null;
            }
            String json = IOUtils.toString((InputStream)inputStream, (String)this.getFromInputStreamEncoding());
            JsonArray jsonArray = this.fromStringArray(json);
            return jsonArray;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public Form createForm(String formName) {
        return this.getFormFactory().createForm(formName, null);
    }

    public String toJsonString(Object obj) {
        return this.toJsonString(obj, false);
    }

    public String toJsonString(Object obj, boolean pretty) {
        try {
            Gson gson = pretty ? this.getGsonPrettyPrinting() : this.getGson();
            String asString = gson.toJson(obj);
            return asString;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public Date parseDateFromJson(String str) {
        return SpincastStatics.parseISO8601date((String)str);
    }

    public String convertToJsonDate(Date date) {
        return SpincastStatics.getIso8601DateParserDefault().format(date);
    }

    public Object convertToNativeType(Object originalObject) {
        if (originalObject == null) {
            return null;
        }
        if (originalObject instanceof String || originalObject instanceof Integer || originalObject instanceof Long || originalObject instanceof Float || originalObject instanceof Double || originalObject instanceof Boolean || originalObject instanceof BigDecimal || originalObject instanceof byte[] || originalObject instanceof Date || originalObject instanceof Instant || originalObject instanceof JsonObject || originalObject instanceof JsonArray) {
            return originalObject;
        }
        if (originalObject instanceof JsonElement) {
            return this.getObjectFromGsonJsonElement((JsonElement)originalObject);
        }
        if (originalObject instanceof Collection) {
            JsonArray array = this.createArray();
            for (Object element : (Collection)originalObject) {
                array.add(element);
            }
            return array;
        }
        if (originalObject instanceof Object[]) {
            JsonArray array = this.createArray();
            for (Object element : (Object[])originalObject) {
                array.add(element);
            }
            return array;
        }
        if (originalObject instanceof Map) {
            JsonObject obj = this.create();
            Map map = (Map)originalObject;
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() == null) {
                    throw new RuntimeException("Cannot convert a Map to a JsonObject when a key is NULL.");
                }
                obj.setNoKeyParsing(String.valueOf(entry.getKey()), entry.getValue());
            }
            return obj;
        }
        if (originalObject instanceof Enum) {
            return ((Enum)originalObject).name();
        }
        String jsonStr = this.toJsonString(originalObject);
        if (jsonStr.startsWith("\"") && jsonStr.endsWith("\"") && jsonStr.length() > 1) {
            jsonStr = jsonStr.substring(1, jsonStr.length() - 1);
            return jsonStr;
        }
        JsonObject jsonObject = this.fromString(jsonStr);
        return jsonObject;
    }

    public JsonElement convertJsonObjectElementToGsonJsonElement(Object originalObject) {
        if (originalObject == null) {
            return null;
        }
        if (originalObject instanceof String) {
            return new JsonPrimitive((String)originalObject);
        }
        if (originalObject instanceof Integer) {
            return new JsonPrimitive((Number)((Integer)originalObject));
        }
        if (originalObject instanceof Long) {
            return new JsonPrimitive((Number)((Long)originalObject));
        }
        if (originalObject instanceof Float) {
            return new JsonPrimitive((Number)((Float)originalObject));
        }
        if (originalObject instanceof Double) {
            return new JsonPrimitive((Number)((Double)originalObject));
        }
        if (originalObject instanceof Boolean) {
            return new JsonPrimitive((Boolean)originalObject);
        }
        if (originalObject instanceof BigDecimal) {
            return new JsonPrimitive(((BigDecimal)originalObject).toPlainString());
        }
        if (originalObject instanceof byte[]) {
            String str = Base64.getEncoder().encodeToString((byte[])originalObject);
            return new JsonPrimitive(str);
        }
        if (originalObject instanceof Date) {
            String dateStr = SpincastStatics.getIso8601DateParserDefault().format((Date)originalObject);
            return new JsonPrimitive(dateStr);
        }
        if (originalObject instanceof Instant) {
            return new JsonPrimitive(((Instant)originalObject).toString());
        }
        if (originalObject instanceof JsonObject) {
            return this.getJsonObjectSerializer().serialize((Object)((JsonObject)originalObject), JsonObject.class, null);
        }
        if (originalObject instanceof JsonArray) {
            return this.getJsonArraySerializer().serialize((Object)((JsonArray)originalObject), JsonArray.class, null);
        }
        return new JsonPrimitive(String.valueOf(originalObject));
    }

    protected Object getObjectFromGsonJsonElement(JsonElement jsonElement) {
        if (jsonElement == null) {
            return null;
        }
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObj = (JsonObject)this.getJsonObjectDeserializer().deserialize(jsonElement, JsonObject.class, null);
            return jsonObj;
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = (JsonArray)this.getJsonArrayDeserializer().deserialize(jsonElement, JsonObject.class, null);
            return jsonArray;
        }
        if (!(jsonElement instanceof JsonPrimitive)) {
            return String.valueOf(jsonElement);
        }
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        if (jsonPrimitive.isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        if (jsonPrimitive.isJsonNull()) {
            return null;
        }
        if (jsonPrimitive.isNumber()) {
            String asString = jsonPrimitive.getAsString();
            if (asString.contains(".")) {
                Double doubleVal = Double.parseDouble(asString);
                return doubleVal;
            }
            long longvalue = jsonPrimitive.getAsLong();
            return longvalue;
        }
        if (jsonPrimitive.isString()) {
            return jsonPrimitive.getAsString();
        }
        return String.valueOf(jsonElement);
    }

    public Object clone(Object originalObject) {
        return this.clone(originalObject, true);
    }

    public Object clone(Object originalObject, boolean mutable) {
        if (originalObject == null) {
            return null;
        }
        if (originalObject instanceof String || originalObject instanceof Integer || originalObject instanceof Long || originalObject instanceof Float || originalObject instanceof Double || originalObject instanceof Boolean || originalObject instanceof BigDecimal || originalObject instanceof byte[] || originalObject instanceof Date) {
            return originalObject;
        }
        if (originalObject instanceof JsonObject) {
            JsonObject jsonObj = (JsonObject)originalObject;
            if (!mutable && !jsonObj.isMutable()) {
                return jsonObj;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry entry : jsonObj) {
                Object elementClone = this.clone(entry.getValue(), mutable);
                map.put((String)entry.getKey(), elementClone);
            }
            return this.getJsonObjectFactory().create(map, mutable);
        }
        if (originalObject instanceof JsonArray) {
            JsonArray array = (JsonArray)originalObject;
            if (!mutable && !array.isMutable()) {
                return array;
            }
            ArrayList<Object> elements = new ArrayList<Object>();
            for (Object element : array) {
                Object elementClone = this.clone(element, mutable);
                elements.add(elementClone);
            }
            return this.getJsonObjectFactory().createArray(elements, mutable);
        }
        return this.convertToNativeType(originalObject);
    }

    public JsonObject cloneJsonObject(JsonObject jsonObject, boolean mutable) {
        return (JsonObject)this.clone(jsonObject, mutable);
    }

    public JsonArray cloneJsonArray(JsonArray jsonArray, boolean mutable) {
        return (JsonArray)this.clone(jsonArray, mutable);
    }

    public void removeElementAtJsonPath(JsonObject obj, String jsonPath) {
        this.getJsonPathUtils().removeElementAtJsonPath(obj, jsonPath);
    }

    public void removeElementAtJsonPath(JsonArray array, String jsonPath) {
        this.getJsonPathUtils().removeElementAtJsonPath(array, jsonPath);
    }

    public boolean isElementExists(JsonObject obj, String jsonPath) {
        return this.getJsonPathUtils().isElementExists(obj, jsonPath);
    }

    public boolean isElementExists(JsonArray array, String jsonPath) {
        return this.getJsonPathUtils().isElementExists(array, jsonPath);
    }

    public JsonObject enumToFriendlyJsonObject(Enum<?> enumValue) {
        if (enumValue == null) {
            return null;
        }
        JsonObject obj = this.create();
        obj.set("name", (Object)enumValue.name());
        obj.set("label", (Object)enumValue.toString());
        return obj;
    }

    public JsonArray enumsToFriendlyJsonArray(Enum<?>[] enumValues) {
        JsonArray arr = this.createArray();
        if (enumValues == null || enumValues.length == 0) {
            return arr;
        }
        for (Enum<?> enumValue : enumValues) {
            arr.add((Object)this.enumToFriendlyJsonObject(enumValue));
        }
        return arr;
    }

    public Object getElementAtJsonPath(JsonObject obj, String jsonPath) {
        return this.getJsonPathUtils().getElementAtJsonPath(obj, jsonPath);
    }

    public Object getElementAtJsonPath(JsonObject obj, String jsonPath, Object defaultValue) {
        return this.getJsonPathUtils().getElementAtJsonPath(obj, jsonPath, defaultValue);
    }

    public Object getElementAtJsonPath(JsonArray array, String jsonPath) {
        return this.getJsonPathUtils().getElementAtJsonPath(array, jsonPath);
    }

    public Object getElementAtJsonPath(JsonArray array, String jsonPath, Object defaultValue) {
        return this.getJsonPathUtils().getElementAtJsonPath(array, jsonPath, defaultValue);
    }

    public void putElementAtJsonPath(JsonObjectOrArray objOrArray, String jsonPath, Object value) {
        this.putElementAtJsonPath(objOrArray, jsonPath, value, false);
    }

    public void putElementAtJsonPath(JsonObjectOrArray objOrArray, String jsonPath, Object value, boolean clone) {
        if (clone) {
            value = this.clone(value);
        }
        this.getJsonPathUtils().putElementAtJsonPath(objOrArray, jsonPath, value);
    }

    protected int getMaxNumberOfKeysWhenConvertingMapToJsonObject() {
        return this.getSpincastConfig().getMaxNumberOfKeysWhenConvertingMapToJsonObject();
    }

    protected void injectDependencies(Object obj) {
        if (obj != null) {
            this.getGuice().injectMembers(obj);
        }
    }
}

