/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.gson;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Date;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.JsonPathUtils;
import org.spincast.core.json.JsonPathUtilsDefault;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.plugins.gson.SpincastGsonManager;
import org.spincast.plugins.gson.serializers.BigDecimalSerializer;
import org.spincast.plugins.gson.serializers.ClassSerializer;
import org.spincast.plugins.gson.serializers.DateSerializer;
import org.spincast.plugins.gson.serializers.EnumSerializer;
import org.spincast.plugins.gson.serializers.InstantSerializer;
import org.spincast.plugins.gson.serializers.JsonArrayDeserializer;
import org.spincast.plugins.gson.serializers.JsonArraytSerializer;
import org.spincast.plugins.gson.serializers.JsonObjectDeserializer;
import org.spincast.plugins.gson.serializers.JsonObjectSerializer;
import org.spincast.plugins.gson.serializers.ThrowableSerializer;

public class SpincastGsonPluginModule
extends SpincastGuiceModuleBase {
    public SpincastGsonPluginModule() {
    }

    public SpincastGsonPluginModule(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
        super(requestContextImplementationClass, websocketContextImplementationClass);
    }

    protected void configure() {
        this.bind(JsonManager.class).to(this.getJsonManagerImpl()).in(Scopes.SINGLETON);
        this.bind(JsonPathUtils.class).to(this.getJsonPathUtilsImpl()).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<JsonDeserializer<JsonObject>>(){}).to(this.getJsonObjectDeserializerImpl()).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<JsonDeserializer<JsonArray>>(){}).to(this.getJsonArrayDeserializerImpl()).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<JsonSerializer<JsonObject>>(){}).to(this.getJsonObjectSerializerImpl()).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<JsonSerializer<JsonArray>>(){}).to(this.getJsonArraySerializerImpl()).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<JsonSerializer<Date>>(){}).to(this.getDateSerializerImpl()).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<JsonSerializer<Instant>>(){}).to(this.getInstantSerializerImpl()).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<JsonSerializer<BigDecimal>>(){}).to(this.getBigDecimalSerializerImpl()).in(Scopes.SINGLETON);
        this.bind(new TypeLiteral<JsonSerializer<Enum<?>>>(){}).to(this.getEnumSerializerImpl()).in(Scopes.SINGLETON);
        this.bind(new TypeLiteral<JsonSerializer<Class<?>>>(){}).to(this.getClassSerializerImpl()).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<JsonSerializer<Throwable>>(){}).to(this.getThrowableSerializerImpl()).in(Scopes.SINGLETON);
    }

    protected Class<? extends JsonManager> getJsonManagerImpl() {
        return SpincastGsonManager.class;
    }

    protected Class<? extends JsonPathUtils> getJsonPathUtilsImpl() {
        return JsonPathUtilsDefault.class;
    }

    protected Class<? extends JsonDeserializer<JsonObject>> getJsonObjectDeserializerImpl() {
        return JsonObjectDeserializer.class;
    }

    protected Class<? extends JsonDeserializer<JsonArray>> getJsonArrayDeserializerImpl() {
        return JsonArrayDeserializer.class;
    }

    protected Class<? extends JsonSerializer<JsonObject>> getJsonObjectSerializerImpl() {
        return JsonObjectSerializer.class;
    }

    protected Class<? extends JsonSerializer<JsonArray>> getJsonArraySerializerImpl() {
        return JsonArraytSerializer.class;
    }

    protected Class<? extends JsonSerializer<Date>> getDateSerializerImpl() {
        return DateSerializer.class;
    }

    protected Class<? extends JsonSerializer<Instant>> getInstantSerializerImpl() {
        return InstantSerializer.class;
    }

    protected Class<? extends JsonSerializer<BigDecimal>> getBigDecimalSerializerImpl() {
        return BigDecimalSerializer.class;
    }

    protected Class<? extends JsonSerializer<Enum<?>>> getEnumSerializerImpl() {
        return EnumSerializer.class;
    }

    protected Class<? extends JsonSerializer<Class<?>>> getClassSerializerImpl() {
        return ClassSerializer.class;
    }

    protected Class<? extends JsonSerializer<Throwable>> getThrowableSerializerImpl() {
        return ThrowableSerializer.class;
    }
}

