/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.gson.serializers;

import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.inject.Inject;
import java.lang.reflect.Type;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.JsonObjectFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.gson.serializers.JsonObjectSerializer;

public class ThrowableSerializer
implements JsonSerializer<Throwable> {
    private final JsonObjectFactory jsonObjectFactory;
    private final JsonObjectSerializer jsonObjectSerializer;

    @Inject
    public ThrowableSerializer(JsonObjectFactory jsonObjectFactory, JsonObjectSerializer jsonObjectSerializer) {
        this.jsonObjectFactory = jsonObjectFactory;
        this.jsonObjectSerializer = jsonObjectSerializer;
    }

    protected JsonObjectFactory getJsonObjectFactory() {
        return this.jsonObjectFactory;
    }

    protected JsonObjectSerializer getJsonObjectSerializer() {
        return this.jsonObjectSerializer;
    }

    public JsonElement serialize(Throwable ex, Type typeOfSrc, JsonSerializationContext context) {
        if (ex == null) {
            return null;
        }
        JsonObject jsonObject = this.toJsonObject(ex);
        return this.getJsonObjectSerializer().serialize(jsonObject, (Type)((Object)JsonObject.class), context);
    }

    protected JsonObject toJsonObject(Throwable ex) {
        JsonObject jsonObject = this.getJsonObjectFactory().create();
        jsonObject.set("name", (Object)ex.getClass().getName());
        jsonObject.set("message", (Object)ex.getMessage());
        jsonObject.set("stacktrace", (Object)SpincastStatics.getStackTrace((Throwable)ex));
        return jsonObject;
    }
}

