/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.httpclient.builders;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.spincast.core.cookies.ICookie;
import org.spincast.core.cookies.ICookieFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.httpclient.IHttpResponse;
import org.spincast.plugins.httpclient.IHttpResponseFactory;
import org.spincast.plugins.httpclient.IRequestBuilderBase;
import org.spincast.shaded.org.apache.http.Header;
import org.spincast.shaded.org.apache.http.HttpEntity;
import org.spincast.shaded.org.apache.http.HttpResponse;
import org.spincast.shaded.org.apache.http.client.CookieStore;
import org.spincast.shaded.org.apache.http.client.HttpClient;
import org.spincast.shaded.org.apache.http.client.config.RequestConfig;
import org.spincast.shaded.org.apache.http.client.entity.DecompressingEntity;
import org.spincast.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.spincast.shaded.org.apache.http.client.methods.HttpUriRequest;
import org.spincast.shaded.org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.spincast.shaded.org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.spincast.shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.spincast.shaded.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.spincast.shaded.org.apache.http.cookie.Cookie;
import org.spincast.shaded.org.apache.http.impl.client.BasicCookieStore;
import org.spincast.shaded.org.apache.http.impl.client.HttpClientBuilder;
import org.spincast.shaded.org.apache.http.impl.cookie.BasicClientCookie;
import org.spincast.shaded.org.apache.http.ssl.SSLContexts;
import org.spincast.shaded.org.apache.http.ssl.TrustStrategy;
import org.spincast.shaded.org.apache.http.util.EntityUtils;

public abstract class SpincastRequestBuilderBase<T extends IRequestBuilderBase<?>>
implements IRequestBuilderBase<T> {
    private final ICookieFactory cookieFactory;
    private final IHttpResponseFactory spincastHttpResponseFactory;
    private String url;
    private HttpClient httpClient;
    private Map<String, List<String>> headers;
    private RequestConfig requestConfig;
    private CookieStore cookieStore;
    private HttpClientBuilder httpClientBuilder;
    private boolean disableSslCertificateErrors = false;

    public SpincastRequestBuilderBase(String url, ICookieFactory cookieFactory, IHttpResponseFactory spincastHttpResponseFactory) {
        this.url = url;
        this.cookieFactory = cookieFactory;
        this.spincastHttpResponseFactory = spincastHttpResponseFactory;
    }

    protected IHttpResponseFactory getSpincastHttpResponseFactory() {
        return this.spincastHttpResponseFactory;
    }

    protected boolean isDisableSslCertificateErrors() {
        return this.disableSslCertificateErrors;
    }

    protected HttpClient createHttpClient() {
        HttpClientBuilder httpClientBuilder = this.getHttpClientBuilder();
        return httpClientBuilder.build();
    }

    protected HttpClientBuilder getHttpClientBuilder() {
        if (this.httpClientBuilder == null) {
            this.httpClientBuilder = this.createHttpClientBuilder();
        }
        this.httpClientBuilder.setDefaultCookieStore(this.getCookieStore());
        if (this.isDisableSslCertificateErrors()) {
            try {
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, (HostnameVerifier)new NoopHostnameVerifier());
                this.httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        return this.httpClientBuilder;
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        return HttpClientBuilder.create();
    }

    @Override
    public T setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
        if (httpClientBuilder != null) {
            try {
                Field cookieStoreField = httpClientBuilder.getClass().getDeclaredField("cookieStore");
                cookieStoreField.setAccessible(true);
                CookieStore cookieStore = (CookieStore)cookieStoreField.get(httpClientBuilder);
                if (cookieStore != null) {
                    this.setCookieStore(cookieStore);
                }
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        SpincastRequestBuilderBase t = this;
        return (T)t;
    }

    @Override
    public T disableSslCertificateErrors() {
        this.disableSslCertificateErrors = true;
        SpincastRequestBuilderBase t = this;
        return (T)t;
    }

    protected void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    protected HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        return this.httpClient;
    }

    protected ICookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected String getUrl() {
        return this.url;
    }

    protected CookieStore getCookieStore() {
        if (this.cookieStore == null) {
            this.cookieStore = new BasicCookieStore();
        }
        return this.cookieStore;
    }

    @Override
    public T addCookie(String name, String value) {
        Objects.requireNonNull(name, "The name can't be NULL");
        ICookie cookie = this.getCookieFactory().createCookie(name, value);
        return this.addCookie(cookie);
    }

    @Override
    public T addCookie(ICookie cookie) {
        Objects.requireNonNull(cookie, "The cookie can't be NULL");
        return this.addCookies(Lists.newArrayList((Object[])new ICookie[]{cookie}));
    }

    @Override
    public T addCookies(Collection<ICookie> cookies) {
        if (cookies != null) {
            for (ICookie cookie : cookies) {
                if (cookie == null) continue;
                Cookie apacheCookie = this.convertToApacheCookie(cookie);
                this.getCookieStore().addCookie(apacheCookie);
            }
        }
        SpincastRequestBuilderBase t = this;
        return (T)t;
    }

    protected Cookie convertToApacheCookie(ICookie cookie) {
        if (cookie == null) {
            return null;
        }
        BasicClientCookie apacheCookie = new BasicClientCookie(cookie.getName(), cookie.getValue());
        apacheCookie.setDomain(cookie.getDomain());
        apacheCookie.setPath(cookie.getPath());
        apacheCookie.setVersion(cookie.getVersion());
        apacheCookie.setSecure(cookie.isSecure());
        apacheCookie.setExpiryDate(cookie.getExpires());
        return apacheCookie;
    }

    @Override
    public T setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        SpincastRequestBuilderBase t = this;
        return (T)t;
    }

    @Override
    public T addHeaderValue(String key, String value) {
        return this.addHeaderValues(key, Lists.newArrayList((Object[])new String[]{value}));
    }

    @Override
    public T addHeaderValues(String key, List<String> values) {
        Objects.requireNonNull(key, "The key can't be NULL");
        List<String> currentValues = this.getHeaders().get(key);
        if (currentValues == null) {
            currentValues = new ArrayList<String>();
            this.getHeaders().put(key, currentValues);
        }
        currentValues.addAll(values);
        SpincastRequestBuilderBase t = this;
        return (T)t;
    }

    @Override
    public T setHeaderValues(String key, List<String> values) {
        Objects.requireNonNull(key, "The key can't be NULL");
        this.getHeaders().put(key, values);
        SpincastRequestBuilderBase t = this;
        return (T)t;
    }

    protected Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>();
        }
        return this.headers;
    }

    @Override
    public T setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
        SpincastRequestBuilderBase t = this;
        return (T)t;
    }

    protected RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    protected String getCookieEncoding() {
        return "UTF-8";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHttpResponse send() {
        IHttpResponse iHttpResponse;
        HttpResponse response = this.sendGetRawResponse();
        try {
            Header[] allHeaders;
            HttpEntity entity;
            byte[] content = null;
            int status = response.getStatusLine().getStatusCode();
            String contentType = null;
            Header contentTypeHeader = response.getFirstHeader("Content-Type");
            if (contentTypeHeader != null) {
                contentType = contentTypeHeader.getValue();
            }
            if ((entity = response.getEntity()) != null) {
                content = EntityUtils.toByteArray((HttpEntity)entity);
            }
            boolean wasZipped = entity instanceof DecompressingEntity;
            HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
            for (Header header : allHeaders = response.getAllHeaders()) {
                ArrayList<String> vals = (ArrayList<String>)responseHeaders.get(header.getName());
                if (vals == null) {
                    vals = new ArrayList<String>();
                    responseHeaders.put(header.getName(), vals);
                }
                vals.add(header.getValue());
            }
            HashMap<String, ICookie> cookies = new HashMap<String, ICookie>();
            CookieStore cookieStore = this.getCookieStore();
            if (cookieStore != null) {
                List responseCookies = cookieStore.getCookies();
                for (Cookie responseCookie : responseCookies) {
                    String name = responseCookie.getName();
                    String value = responseCookie.getValue();
                    if (value != null) {
                        try {
                            name = URLDecoder.decode(name, this.getCookieEncoding());
                            value = URLDecoder.decode(value, this.getCookieEncoding());
                        }
                        catch (Exception ex) {
                            throw SpincastStatics.runtimize((Exception)ex);
                        }
                    }
                    ICookie cookie = this.getCookieFactory().createCookie(name, value, responseCookie.getPath(), responseCookie.getDomain(), responseCookie.getExpiryDate(), responseCookie.isSecure(), false, !responseCookie.isPersistent(), responseCookie.getVersion());
                    cookies.put(cookie.getName(), cookie);
                }
            }
            iHttpResponse = this.getSpincastHttpResponseFactory().create(status, contentType, content, responseHeaders, cookies, wasZipped);
        }
        catch (Throwable throwable) {
            try {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw throwable;
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        return iHttpResponse;
    }

    protected HttpResponse sendGetRawResponse() {
        try {
            RequestConfig requestConfig = this.getRequestConfig();
            if (requestConfig == null) {
                requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setCookieSpec("standard").build();
            }
            String url = this.getUrl();
            HttpRequestBase request = this.createMethodSpecificHttpRequest(url);
            if (requestConfig != null) {
                request.setConfig(requestConfig);
            }
            for (Map.Entry<String, List<String>> entry : this.getHeaders().entrySet()) {
                String key = entry.getKey();
                for (String value : entry.getValue()) {
                    request.addHeader(key, value);
                }
            }
            return this.getHttpClient().execute((HttpUriRequest)request);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected abstract HttpRequestBase createMethodSpecificHttpRequest(String var1);
}

