/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.httpclient;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.spincast.core.cookies.ICookie;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.httpclient.IHttpResponse;

public class SpincastHttpResponse
implements IHttpResponse {
    private final int status;
    private final byte[] content;
    private String contentAsString;
    private String lastContentAsStringEncodingUsed;
    private final String contentType;
    private final Map<String, List<String>> headers;
    private final Map<String, ICookie> cookies;
    private final boolean isGzipped;

    @AssistedInject
    public SpincastHttpResponse(@Assisted(value="status") int status, @Assisted(value="contentType") @Nullable String contentType, @Assisted(value="content") @Nullable byte[] content, @Assisted(value="headers") Map<String, List<String>> headers, @Assisted(value="cookies") Map<String, ICookie> cookies, @Assisted(value="wasZipped") boolean wasZipped) {
        this.status = status;
        this.contentType = contentType;
        this.headers = headers;
        this.cookies = cookies;
        this.isGzipped = wasZipped;
        if (content == null) {
            content = new byte[]{};
        }
        this.content = content;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentAsString() {
        return this.getContentAsString("UTF-8");
    }

    @Override
    public String getContentAsString(String encoding) {
        try {
            if (encoding == null) {
                encoding = "UTF-8";
            }
            if (this.contentAsString == null || !encoding.equals(this.lastContentAsStringEncodingUsed)) {
                this.lastContentAsStringEncodingUsed = encoding;
                this.contentAsString = new String(this.getContentAsByteArray(), encoding);
            }
            return this.contentAsString;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public byte[] getContentAsByteArray() {
        return this.content;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeaderFirst(String name) {
        List<String> vals = this.getHeaders().get(name);
        if (vals != null && vals.size() > 0) {
            return vals.get(0);
        }
        return null;
    }

    @Override
    public List<String> getHeader(String name) {
        List<String> vals = this.getHeaders().get(name);
        if (vals == null) {
            vals = new ArrayList<String>();
        }
        return vals;
    }

    @Override
    public Map<String, ICookie> getCookies() {
        return this.cookies;
    }

    @Override
    public ICookie getCookie(String name) {
        return this.getCookies().get(name);
    }

    @Override
    public boolean isGzipped() {
        return this.isGzipped;
    }
}

