/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.httpclient.utils;

import java.io.Serializable;
import java.net.HttpCookie;
import java.util.Date;
import java.util.Objects;
import org.spincast.plugins.httpclient.utils.SpincastHttpClientUtils;
import org.spincast.shaded.org.apache.commons.codec.binary.Base64;
import org.spincast.shaded.org.apache.commons.codec.digest.DigestUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.http.cookie.Cookie;

public class SpincastHttpClientUtilsDefault
implements SpincastHttpClientUtils {
    @Override
    public String generateExpectedWebsocketV13AcceptHeaderValue(String secWebSocketKey) {
        Object expected = secWebSocketKey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        byte[] expectedBytes = DigestUtils.sha1((String)expected);
        expected = Base64.encodeBase64String((byte[])expectedBytes);
        return expected;
    }

    @Override
    public String apacheCookieToHttpHeaderValue(Cookie cookie) {
        Objects.requireNonNull(cookie, "The cookie can't be NULL");
        HttpCookie httpCookie = this.convertApacheCookieToHttpCookie(cookie);
        return httpCookie.toString();
    }

    protected HttpCookie convertApacheCookieToHttpCookie(Cookie cookie) {
        HttpCookie httpCookie = new HttpCookie(cookie.getName(), cookie.getValue());
        httpCookie.setVersion(cookie.getVersion());
        httpCookie.setComment(cookie.getComment());
        httpCookie.setCommentURL(cookie.getCommentURL());
        httpCookie.setDiscard(!cookie.isPersistent());
        httpCookie.setDomain(cookie.getDomain());
        if (cookie.getExpiryDate() != null) {
            httpCookie.setMaxAge((cookie.getExpiryDate().getTime() - new Date().getTime()) / 1000L);
        }
        httpCookie.setPath(cookie.getPath());
        if (cookie.getPorts() != null) {
            httpCookie.setPortlist(StringUtils.join((Object[])new Serializable[]{cookie.getPorts(), ","}));
        }
        httpCookie.setSecure(cookie.isSecure());
        return httpCookie;
    }
}

