/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jacksonjson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.spincast.core.json.IJsonArray;
import org.spincast.core.json.IJsonManager;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.json.IJsonObjectAssistedFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.lang3.time.FastDateFormat;

public class SpincastJsonManager
implements IJsonManager {
    private final IJsonObjectAssistedFactory jsonObjectFactory;
    private final Provider<Injector> guiceProvider;
    private ObjectMapper objectMapper;
    private JsonSerializer<IJsonObject> jsonObjectSerializer;
    private JsonDeserializer<IJsonObject> jsonObjectDeserializer;
    private JsonSerializer<IJsonArray> jsonArraySerializer;
    private JsonDeserializer<IJsonArray> jsonArrayDeserializer;
    private JsonSerializer<Date> dateSerializer;
    private DefaultPrettyPrinter jacksonPrettyPrinter;
    private static FastDateFormat iso8601DateParserDefault = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mmZ", (TimeZone)TimeZone.getTimeZone("UTC"));
    private static FastDateFormat iso8601DateParser1 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssX", (TimeZone)TimeZone.getTimeZone("UTC"));
    private static FastDateFormat iso8601DateParser2 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ", (TimeZone)TimeZone.getTimeZone("UTC"));
    private static FastDateFormat iso8601DateParser3 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSXXX", (TimeZone)TimeZone.getTimeZone("UTC"));

    @Inject
    public SpincastJsonManager(Provider<Injector> guiceProvider, IJsonObjectAssistedFactory jsonObjectFactory) {
        this.guiceProvider = guiceProvider;
        this.jsonObjectFactory = jsonObjectFactory;
    }

    protected Injector getGuice() {
        return (Injector)this.guiceProvider.get();
    }

    protected IJsonObjectAssistedFactory getJsonObjectFactory() {
        return this.jsonObjectFactory;
    }

    protected DefaultPrettyPrinter getJacksonPrettyPrinter() {
        if (this.jacksonPrettyPrinter == null) {
            this.jacksonPrettyPrinter = new DefaultPrettyPrinter();
            DefaultIndenter indenter = new DefaultIndenter(this.getJacksonPrettyPrinterIndentation(), DefaultIndenter.SYS_LF);
            this.jacksonPrettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
            this.jacksonPrettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        }
        return this.jacksonPrettyPrinter;
    }

    protected String getJacksonPrettyPrinterIndentation() {
        return "    ";
    }

    protected FastDateFormat getIso8601DateParserDefault() {
        return iso8601DateParserDefault;
    }

    protected FastDateFormat getIso8601DateParser1() {
        return iso8601DateParser1;
    }

    protected FastDateFormat getIso8601DateParser2() {
        return iso8601DateParser2;
    }

    protected FastDateFormat getIso8601DateParser3() {
        return iso8601DateParser3;
    }

    protected ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            ObjectMapper objectMapper = this.createObjectManager();
            this.registerCustomModules(objectMapper);
            this.objectMapper = objectMapper;
        }
        return this.objectMapper;
    }

    protected ObjectMapper createObjectManager() {
        ObjectMapper objectMapper = new ObjectMapper();
        this.configureObjectMapper(objectMapper);
        return objectMapper;
    }

    protected void configureObjectMapper(ObjectMapper objectMapper) {
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    protected JsonSerializer<IJsonObject> getJsonObjectSerializer() {
        if (this.jsonObjectSerializer == null) {
            this.jsonObjectSerializer = new JsonSerializer<IJsonObject>(){

                public void serialize(IJsonObject jsonObject, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (jsonObject == null) {
                        return;
                    }
                    gen.writeObject((Object)jsonObject.getUnderlyingMap());
                }
            };
        }
        return this.jsonObjectSerializer;
    }

    protected JsonSerializer<IJsonArray> getJsonArraySerializer() {
        if (this.jsonArraySerializer == null) {
            this.jsonArraySerializer = new JsonSerializer<IJsonArray>(){

                public void serialize(IJsonArray jsonArray, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (jsonArray == null) {
                        return;
                    }
                    gen.writeObject((Object)jsonArray.getUnderlyingList());
                }
            };
        }
        return this.jsonArraySerializer;
    }

    protected JsonSerializer<Date> getDateSerializer() {
        if (this.dateSerializer == null) {
            this.dateSerializer = new JsonSerializer<Date>(){

                public void serialize(Date jsonObject, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (jsonObject == null) {
                        return;
                    }
                    String dateStr = SpincastJsonManager.this.getIso8601DateParserDefault().format(jsonObject);
                    gen.writeObject((Object)dateStr);
                }
            };
        }
        return this.dateSerializer;
    }

    protected JsonDeserializer<IJsonObject> getJsonObjectDeserializer() {
        if (this.jsonObjectDeserializer == null) {
            this.jsonObjectDeserializer = new JsonDeserializer<IJsonObject>(){

                public IJsonObject deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
                    IJsonObject jsonObject = SpincastJsonManager.this.getJsonObjectFactory().create();
                    JsonToken jsonToken = jsonParser.getCurrentToken();
                    if (jsonToken == JsonToken.START_OBJECT) {
                        jsonToken = jsonParser.nextToken();
                    }
                    while (jsonToken != null && jsonToken == JsonToken.FIELD_NAME) {
                        String name = jsonParser.getCurrentName();
                        jsonToken = jsonParser.nextToken();
                        if (jsonToken == JsonToken.START_OBJECT) {
                            jsonObject.put(name, (Object)this.deserialize(jsonParser, context));
                        } else if (jsonToken == JsonToken.START_ARRAY) {
                            jsonObject.put(name, SpincastJsonManager.this.getJsonArrayDeserializer().deserialize(jsonParser, context));
                        } else if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                            jsonObject.put(name, jsonParser.getEmbeddedObject());
                        } else if (jsonToken == JsonToken.VALUE_NULL) {
                            jsonObject.put(name, null);
                        } else if (jsonToken == JsonToken.VALUE_STRING) {
                            jsonObject.put(name, (Object)jsonParser.getText());
                        } else if (jsonToken == JsonToken.VALUE_TRUE) {
                            jsonObject.put(name, (Object)true);
                        } else if (jsonToken == JsonToken.VALUE_FALSE) {
                            jsonObject.put(name, (Object)false);
                        } else if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                            jsonObject.put(name, (Object)jsonParser.getNumberValue());
                        } else {
                            throw new RuntimeException("Unmanaged json token type : " + jsonToken);
                        }
                        jsonToken = jsonParser.nextToken();
                    }
                    return jsonObject;
                }
            };
        }
        return this.jsonObjectDeserializer;
    }

    protected JsonDeserializer<IJsonArray> getJsonArrayDeserializer() {
        if (this.jsonArrayDeserializer == null) {
            this.jsonArrayDeserializer = new JsonDeserializer<IJsonArray>(){

                public IJsonArray deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
                    IJsonArray jsonArray = SpincastJsonManager.this.getJsonObjectFactory().createArray();
                    JsonToken jsonToken = jsonParser.getCurrentToken();
                    if (jsonToken == JsonToken.START_ARRAY) {
                        jsonToken = jsonParser.nextToken();
                    }
                    while (jsonToken != null && jsonToken != JsonToken.END_ARRAY) {
                        if (jsonToken == JsonToken.START_OBJECT) {
                            jsonArray.add(SpincastJsonManager.this.getJsonObjectDeserializer().deserialize(jsonParser, context));
                        } else if (jsonToken == JsonToken.START_ARRAY) {
                            jsonArray.add((Object)this.deserialize(jsonParser, context));
                        } else if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                            jsonArray.add(jsonParser.getEmbeddedObject());
                        } else if (jsonToken == JsonToken.VALUE_NULL) {
                            jsonArray.add(null);
                        } else if (jsonToken == JsonToken.VALUE_STRING) {
                            jsonArray.add((Object)jsonParser.getText());
                        } else if (jsonToken == JsonToken.VALUE_TRUE) {
                            jsonArray.add((Object)true);
                        } else if (jsonToken == JsonToken.VALUE_FALSE) {
                            jsonArray.add((Object)false);
                        } else if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                            jsonArray.add((Object)jsonParser.getNumberValue());
                        } else {
                            throw new RuntimeException("Unmanaged json token type : " + jsonToken);
                        }
                        jsonToken = jsonParser.nextToken();
                    }
                    return jsonArray;
                }
            };
        }
        return this.jsonArrayDeserializer;
    }

    protected void registerCustomModules(ObjectMapper objectMapper) {
        this.registerIJsonObjectModule(objectMapper);
        this.registerDateModule(objectMapper);
    }

    protected void registerIJsonObjectModule(ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(IJsonObject.class, this.getJsonObjectSerializer());
        module.addDeserializer(IJsonObject.class, this.getJsonObjectDeserializer());
        module.addSerializer(IJsonArray.class, this.getJsonArraySerializer());
        module.addDeserializer(IJsonArray.class, this.getJsonArrayDeserializer());
        objectMapper.registerModule((Module)module);
    }

    protected void registerDateModule(ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Date.class, this.getDateSerializer());
        objectMapper.registerModule((Module)module);
    }

    public String toJsonString(Object obj) {
        return this.toJsonString(obj, false);
    }

    public String toJsonString(Object obj, boolean pretty) {
        try {
            if (pretty) {
                return this.getObjectMapper().writer((PrettyPrinter)this.getJacksonPrettyPrinter()).writeValueAsString(obj);
            }
            return this.getObjectMapper().writeValueAsString(obj);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected void injectDependencies(Object obj) {
        if (obj != null) {
            this.getGuice().injectMembers(obj);
        }
    }

    public <T> T fromJsonString(String jsonString, Class<T> clazz) {
        try {
            Object jsonObj = this.getObjectMapper().readValue(jsonString, clazz);
            this.injectDependencies(jsonObj);
            return (T)jsonObj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public <T> T fromJsonInputStream(InputStream inputStream, Class<T> clazz) {
        try {
            Object jsonObj = this.getObjectMapper().readValue(inputStream, clazz);
            this.injectDependencies(jsonObj);
            return (T)jsonObj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public Map<String, Object> fromJsonStringToMap(String jsonString) {
        try {
            Map map = (Map)this.getObjectMapper().readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
            return map;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public Map<String, Object> fromJsonInputStreamToMap(InputStream inputStream) {
        try {
            Map map = (Map)this.getObjectMapper().readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
            return map;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public IJsonObject create() {
        return this.getJsonObjectFactory().create();
    }

    public IJsonObject create(String jsonString) {
        try {
            IJsonObject obj = (IJsonObject)this.getObjectMapper().readValue(jsonString, IJsonObject.class);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public IJsonObject create(InputStream inputStream) {
        try {
            IJsonObject obj = (IJsonObject)this.getObjectMapper().readValue(inputStream, IJsonObject.class);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public IJsonArray createArray() {
        return this.getJsonObjectFactory().createArray();
    }

    public IJsonArray createArray(String jsonString) {
        try {
            IJsonArray obj = (IJsonArray)this.getObjectMapper().readValue(jsonString, IJsonArray.class);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public IJsonArray createArray(InputStream inputStream) {
        try {
            IJsonArray obj = (IJsonArray)this.getObjectMapper().readValue(inputStream, IJsonArray.class);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public Date parseDateFromJson(String str) {
        if (str == null) {
            return null;
        }
        Date date = null;
        try {
            date = this.getIso8601DateParserDefault().parse(str);
            return date;
        }
        catch (Exception exception) {
            try {
                date = this.getIso8601DateParser1().parse(str);
                return date;
            }
            catch (Exception exception2) {
                try {
                    date = this.getIso8601DateParser2().parse(str);
                    return date;
                }
                catch (Exception exception3) {
                    try {
                        date = this.getIso8601DateParser3().parse(str);
                        return date;
                    }
                    catch (Exception ex) {
                        throw SpincastStatics.runtimize((Exception)ex);
                    }
                }
            }
        }
    }
}

