/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jacksonxml;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;

public class SpincastXmlIndenter
implements DefaultXmlPrettyPrinter.Indenter {
    static final int SPACE_COUNT = 64;
    static final char[] SPACES = new char[64];

    public boolean isInline() {
        return false;
    }

    public void writeIndentation(XMLStreamWriter2 sw, int level) throws XMLStreamException {
        sw.writeRaw(this.getNewlineChars());
        int spaceNbr = level * this.getIndentationSpaceNumber();
        while (level > 64) {
            sw.writeRaw(SPACES, 0, 64);
            level -= SPACES.length;
        }
        sw.writeRaw(SPACES, 0, spaceNbr);
    }

    public void writeIndentation(JsonGenerator jg, int level) throws IOException, JsonGenerationException {
        jg.writeRaw(this.getNewlineChars());
        int spaceNbr = level * this.getIndentationSpaceNumber();
        while (level > 64) {
            jg.writeRaw(SPACES, 0, 64);
            level -= SPACES.length;
        }
        jg.writeRaw(SPACES, 0, spaceNbr);
    }

    protected int getIndentationSpaceNumber() {
        return 4;
    }

    protected String getNewlineChars() {
        return "\n";
    }

    static {
        Arrays.fill(SPACES, ' ');
    }
}

