/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jacksonxml;

import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.XmlPrettyPrinter;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.xml.XmlManager;
import org.spincast.plugins.jacksonxml.XmlMixinInfo;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastXmlManager
implements XmlManager {
    private final Provider<Injector> guiceProvider;
    private final JsonManager jsonManager;
    private final Set<XmlMixinInfo> xmlMixinInfos;
    private final XmlPrettyPrinter xmlPrettyPrinter;
    private XmlMapper xmlMapper;
    private XmlMapper xmlMapperPretty;
    private JsonSerializer<JsonObject> jsonObjectSerializer;
    private JsonDeserializer<JsonObject> jsonObjectDeserializer;
    private JsonDeserializer<JsonArray> jsonArrayDeserializer;
    private JsonSerializer<JsonArray> jsonArraySerializer;

    @Inject
    public SpincastXmlManager(Provider<Injector> guiceProvider, JsonManager jsonManager, @Nullable Set<XmlMixinInfo> xmlMixinInfos, XmlPrettyPrinter xmlPrettyPrinter) {
        this.guiceProvider = guiceProvider;
        this.jsonManager = jsonManager;
        this.xmlMixinInfos = xmlMixinInfos;
        this.xmlPrettyPrinter = xmlPrettyPrinter;
    }

    protected Injector getGuice() {
        return (Injector)this.guiceProvider.get();
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected Set<XmlMixinInfo> getXmlMixinInfos() {
        return this.xmlMixinInfos;
    }

    protected XmlPrettyPrinter getXmlPrettyPrinter() {
        return this.xmlPrettyPrinter;
    }

    protected XmlMapper getXmlMapper() {
        if (this.xmlMapper == null) {
            XmlMapper xmlMapper = this.createXmlMapper();
            this.registerCustomModules(xmlMapper);
            this.xmlMapper = xmlMapper;
        }
        return this.xmlMapper;
    }

    protected XmlMapper createXmlMapper() {
        XmlMapper xmlMapper = new XmlMapper();
        this.configureXmlMapper(xmlMapper);
        return xmlMapper;
    }

    protected void configureXmlMapper(XmlMapper xmlMapper) {
        this.configureEmptyBeans(xmlMapper);
        this.configureMixins(xmlMapper);
    }

    protected void configureEmptyBeans(XmlMapper xmlMapper) {
        xmlMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    protected void configureMixins(XmlMapper xmlMapper) {
        this.addSpincastMixins(xmlMapper);
        for (XmlMixinInfo xmlMixinInfo : this.getXmlMixinInfos()) {
            xmlMapper.addMixIn(xmlMixinInfo.getTargetClass(), xmlMixinInfo.getMixinClass());
        }
    }

    protected void addSpincastMixins(XmlMapper xmlMapper) {
        this.addJsonObjectMixin(xmlMapper);
        this.addJsonArrayMixin(xmlMapper);
    }

    protected void addJsonObjectMixin(XmlMapper xmlMapper) {
        xmlMapper.addMixIn(JsonObject.class, JsonObjectMixIn.class);
    }

    protected void addJsonArrayMixin(XmlMapper xmlMapper) {
        xmlMapper.addMixIn(JsonArray.class, JsonArrayMixIn.class);
    }

    protected XmlMapper getXmlMapperPretty() {
        if (this.xmlMapperPretty == null) {
            XmlMapper xmlMapper = this.getXmlMapper().copy();
            xmlMapper.setDefaultPrettyPrinter((PrettyPrinter)this.getXmlPrettyPrinter());
            xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
            this.registerCustomModules(xmlMapper);
            this.configureMixins(xmlMapper);
            this.xmlMapperPretty = xmlMapper;
        }
        return this.xmlMapperPretty;
    }

    protected String getArrayAttributeName() {
        return "isArray";
    }

    protected JsonSerializer<JsonObject> getJsonObjectSerializer() {
        if (this.jsonObjectSerializer == null) {
            this.jsonObjectSerializer = new JsonSerializer<JsonObject>(){

                public void serialize(JsonObject jsonObject, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (jsonObject == null) {
                        return;
                    }
                    ToXmlGenerator xmlGen = (ToXmlGenerator)gen;
                    xmlGen.writeStartObject();
                    for (Map.Entry element : jsonObject) {
                        xmlGen.writeFieldName((String)element.getKey());
                        xmlGen.writeObject(element.getValue());
                    }
                    xmlGen.writeEndObject();
                }
            };
        }
        return this.jsonObjectSerializer;
    }

    protected JsonSerializer<JsonArray> getJsonArraySerializer() {
        if (this.jsonArraySerializer == null) {
            this.jsonArraySerializer = new JsonSerializer<JsonArray>(){

                public void serialize(JsonArray jsonArray, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (jsonArray == null) {
                        return;
                    }
                    ToXmlGenerator xmlGen = (ToXmlGenerator)gen;
                    xmlGen.writeStartObject();
                    xmlGen.setNextIsAttribute(true);
                    xmlGen.writeFieldName(SpincastXmlManager.this.getArrayAttributeName());
                    xmlGen.writeString("true");
                    xmlGen.setNextIsAttribute(false);
                    for (Object element : jsonArray) {
                        xmlGen.writeFieldName("element");
                        if (element == null) {
                            xmlGen.writeNull();
                            continue;
                        }
                        if (element instanceof JsonObject) {
                            xmlGen.writeStartObject();
                            xmlGen.writeFieldName("obj");
                            xmlGen.writeObject(element);
                            xmlGen.writeEndObject();
                            continue;
                        }
                        if (element instanceof JsonArray) {
                            xmlGen.writeStartObject();
                            xmlGen.writeFieldName("array");
                            xmlGen.writeObject(element);
                            xmlGen.writeEndObject();
                            continue;
                        }
                        xmlGen.writeObject(element);
                    }
                    xmlGen.writeEndObject();
                }
            };
        }
        return this.jsonArraySerializer;
    }

    protected JsonDeserializer<JsonObject> getJsonObjectDeserializer() {
        if (this.jsonObjectDeserializer == null) {
            this.jsonObjectDeserializer = new JsonDeserializer<JsonObject>(){

                public JsonObject deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
                    FromXmlParser xmlParser = (FromXmlParser)jsonParser;
                    JsonToken token = xmlParser.nextToken();
                    JsonObject jsonObject = SpincastXmlManager.this.deserializeJsonObject(xmlParser, context, null);
                    return jsonObject;
                }
            };
        }
        return this.jsonObjectDeserializer;
    }

    protected JsonDeserializer<JsonArray> getJsonArrayDeserializer() {
        if (this.jsonArrayDeserializer == null) {
            this.jsonArrayDeserializer = new JsonDeserializer<JsonArray>(){

                public JsonArray deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
                    FromXmlParser xmlParser = (FromXmlParser)jsonParser;
                    boolean firstElementSkipped = false;
                    JsonToken token = xmlParser.nextToken();
                    if (token == JsonToken.FIELD_NAME) {
                        String fieldName = xmlParser.getValueAsString();
                        token = xmlParser.nextToken();
                        firstElementSkipped = true;
                        if (fieldName != null && fieldName.equals(SpincastXmlManager.this.getArrayAttributeName()) && token == JsonToken.VALUE_STRING && "true".equalsIgnoreCase(xmlParser.getValueAsString())) {
                            token = xmlParser.nextToken();
                            firstElementSkipped = false;
                        }
                    }
                    return SpincastXmlManager.this.deserializeJsonArray(xmlParser, context, firstElementSkipped);
                }
            };
        }
        return this.jsonArrayDeserializer;
    }

    protected Object deserializeObjectOrArray(FromXmlParser xmlParser, DeserializationContext context) {
        try {
            JsonToken token = xmlParser.getCurrentToken();
            if (token == JsonToken.VALUE_NULL) {
                token = xmlParser.nextToken();
                return this.getJsonManager().create();
            }
            if (token != JsonToken.START_OBJECT) {
                throw new RuntimeException("Expecting a START_OBJECT token here, got : " + token);
            }
            token = xmlParser.nextToken();
            if (token != JsonToken.FIELD_NAME) {
                throw new RuntimeException("Expecting a FIELD_NAME token here, got : " + token);
            }
            String fieldName = xmlParser.getValueAsString();
            token = xmlParser.nextToken();
            if (token == JsonToken.END_OBJECT || token == JsonToken.VALUE_NULL) {
                return this.getJsonManager().create();
            }
            if (fieldName != null && fieldName.equals(this.getArrayAttributeName()) && token == JsonToken.VALUE_STRING && "true".equalsIgnoreCase(xmlParser.getValueAsString())) {
                token = xmlParser.nextToken();
                return this.deserializeJsonArray(xmlParser, context);
            }
            Object firstValue = null;
            firstValue = token == JsonToken.START_OBJECT ? this.deserializeObjectOrArray(xmlParser, context) : xmlParser.readValueAs(Object.class);
            token = xmlParser.nextToken();
            return this.deserializeJsonObject(xmlParser, context, new AbstractMap.SimpleEntry<String, Object>(fieldName, firstValue));
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected JsonArray deserializeJsonArray(FromXmlParser xmlParser, DeserializationContext context) {
        return this.deserializeJsonArray(xmlParser, context, false);
    }

    protected JsonArray deserializeJsonArray(FromXmlParser xmlParser, DeserializationContext context, boolean firstElementSkipped) {
        try {
            JsonArray jsonArray = this.getJsonManager().createArray();
            JsonToken token = xmlParser.getCurrentToken();
            while (token == JsonToken.FIELD_NAME || firstElementSkipped) {
                if (!firstElementSkipped) {
                    String tokenName = xmlParser.getValueAsString();
                    token = xmlParser.nextToken();
                } else {
                    firstElementSkipped = false;
                }
                if (token == JsonToken.START_OBJECT) {
                    token = xmlParser.nextToken();
                    if (token != JsonToken.FIELD_NAME) {
                        throw new RuntimeException("Expecting a FIELD_NAME token here, got : " + token);
                    }
                    String fieldName = xmlParser.getValueAsString();
                    token = xmlParser.nextToken();
                    if (token == JsonToken.VALUE_NULL) {
                        jsonArray.add((Object)this.getJsonManager().create());
                    } else if (token == JsonToken.START_OBJECT) {
                        jsonArray.add(this.deserializeObjectOrArray(xmlParser, context));
                    } else {
                        JsonObject jsonObject = this.getJsonManager().create();
                        Object value = xmlParser.readValueAs(Object.class);
                        jsonObject.put(fieldName, value);
                        jsonArray.add((Object)jsonObject);
                    }
                    token = xmlParser.nextToken();
                    if (token != JsonToken.END_OBJECT) {
                        throw new RuntimeException("An array element can't contain more than one child! The current array already contains one : " + jsonArray.toJsonString());
                    }
                } else {
                    Object value = xmlParser.readValueAs(Object.class);
                    jsonArray.add(value);
                }
                token = xmlParser.nextToken();
            }
            return jsonArray;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected JsonObject deserializeJsonObject(FromXmlParser xmlParser, DeserializationContext context, Map.Entry<String, Object> firstProperty) {
        try {
            JsonObject jsonObject = this.getJsonManager().create();
            if (firstProperty != null) {
                jsonObject.put(firstProperty.getKey(), firstProperty.getValue());
            }
            JsonToken token = xmlParser.getCurrentToken();
            while (token == JsonToken.FIELD_NAME) {
                String fieldName = xmlParser.getValueAsString();
                if (StringUtils.isBlank((CharSequence)fieldName)) {
                    throw new RuntimeException("A Json object can't have a property with an empty name. For example, this is invalid : <root>someValue</root>, a name must be specified : <root><someKey>someValue</someKey></root>");
                }
                token = xmlParser.nextToken();
                if (token == JsonToken.VALUE_NULL) {
                    jsonObject.put(fieldName, (Object)this.getJsonManager().create());
                } else if (token == JsonToken.START_OBJECT) {
                    jsonObject.put(fieldName, this.deserializeObjectOrArray(xmlParser, context));
                } else {
                    Object value = xmlParser.readValueAs(Object.class);
                    jsonObject.put(fieldName, value);
                }
                token = xmlParser.nextToken();
            }
            return jsonObject;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected void registerCustomModules(XmlMapper objectMapper) {
        this.registerJsonObjectModule(objectMapper);
    }

    protected void registerJsonObjectModule(XmlMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, this.getJsonObjectSerializer());
        module.addDeserializer(JsonObject.class, this.getJsonObjectDeserializer());
        module.addSerializer(JsonArray.class, this.getJsonArraySerializer());
        module.addDeserializer(JsonArray.class, this.getJsonArrayDeserializer());
        objectMapper.registerModule((Module)module);
    }

    public String toXml(Object obj) {
        return this.toXml(obj, false);
    }

    public String toXml(Object obj, boolean pretty) {
        try {
            if (pretty) {
                return this.getXmlMapperPretty().writeValueAsString(obj);
            }
            return this.getXmlMapper().writeValueAsString(obj);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public JsonObject fromXml(String xml) {
        return (JsonObject)this.fromXmlToType(xml, (Type)((Object)JsonObject.class));
    }

    public JsonArray fromXmlToJsonArray(String xml) {
        return (JsonArray)this.fromXmlToType(xml, (Type)((Object)JsonArray.class));
    }

    public <T> T fromXml(String xml, Class<T> clazz) {
        return this.fromXmlToType(xml, clazz);
    }

    protected void injectDependencies(Object obj) {
        if (obj != null) {
            this.getGuice().injectMembers(obj);
        }
    }

    public <T> T fromXmlToType(String xml, Type type) {
        if (xml == null) {
            return null;
        }
        if (type == null) {
            return null;
        }
        try {
            JavaType javaType = TypeFactory.defaultInstance().constructType(type);
            Object obj = this.getXmlMapper().readValue(xml, javaType);
            this.injectDependencies(obj);
            return (T)obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public <T> T fromXmlInputStream(InputStream inputStream, Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz can't be NULL");
        if (inputStream == null) {
            return null;
        }
        try {
            JavaType javaType = TypeFactory.defaultInstance().constructType(clazz);
            Object obj = this.getXmlMapper().readValue(inputStream, javaType);
            this.injectDependencies(obj);
            return (T)obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @JsonRootName(value="JsonArray")
    protected static interface JsonArrayMixIn
    extends JsonArray {
    }

    @JsonRootName(value="JsonObject")
    protected static interface JsonObjectMixIn
    extends JsonObject {
    }
}

