/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc.statements;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.jdbc.SpincastResultSetDefault;
import org.spincast.plugins.jdbc.statements.QueryResultFactory;
import org.spincast.plugins.jdbc.statements.ResultSetHandler;
import org.spincast.plugins.jdbc.statements.SelectStatement;
import org.spincast.plugins.jdbc.statements.StatementBase;
import org.spincast.plugins.jdbc.utils.ItemsAndTotalCount;
import org.spincast.plugins.jdbc.utils.ItemsAndTotalCountDefault;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SelectStatementDefault
extends StatementBase
implements SelectStatement {
    protected static final Logger logger = LoggerFactory.getLogger(SelectStatementDefault.class);

    @AssistedInject
    public SelectStatementDefault(@Assisted Connection connection, QueryResultFactory queryResultFactory) {
        super(connection, queryResultFactory);
    }

    protected PreparedStatement getStatementWithParamsAdded(Connection connection) {
        try {
            PreparedStatement statement = connection.prepareStatement(this.getParsedQuery());
            this.addCurrentParamsToStatement(statement);
            return statement;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T selectOne(ResultSetHandler<T> resultSetHandler) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement realStatement = this.getStatementWithParamsAdded(connection);
            try {
                T res;
                ResultSet resultSet;
                block16: {
                    block15: {
                        block14: {
                            T t;
                            resultSet = realStatement.executeQuery();
                            try {
                                if (resultSetHandler != null) break block14;
                                t = null;
                            }
                            catch (Throwable throwable) {
                                this.close(resultSet);
                                throw throwable;
                            }
                            this.close(resultSet);
                            return t;
                        }
                        if (resultSet.isBeforeFirst()) break block15;
                        T t = null;
                        this.close(resultSet);
                        return t;
                    }
                    boolean next = resultSet.next();
                    if (next) break block16;
                    T t = null;
                    this.close(resultSet);
                    return t;
                }
                T t = res = resultSetHandler.handle(new SpincastResultSetDefault(resultSet));
                this.close(resultSet);
                return t;
            }
            finally {
                this.close(realStatement);
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public <T> List<T> selectList(ResultSetHandler<T> resultSetHandler) {
        ItemsAndTotalCount<T> listAndTotal = this.selectList(resultSetHandler, true);
        return listAndTotal.getItems();
    }

    @Override
    public <T> ItemsAndTotalCount<T> selectListAndTotal(ResultSetHandler<T> resultSetHandler) {
        return this.selectList(resultSetHandler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected <T> ItemsAndTotalCount<T> selectList(ResultSetHandler<T> resultSetHandler, boolean getTotal) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement realStatement = this.getStatementWithParamsAdded(connection);
            try {
                ItemsAndTotalCountDefault itemsAndTotalCountDefault;
                ResultSet resultSet = realStatement.executeQuery();
                try {
                    ItemsAndTotalCountDefault listAndTotal;
                    ArrayList<T> items = new ArrayList<T>();
                    if (resultSetHandler != null && resultSet.isBeforeFirst()) {
                        while (resultSet.next()) {
                            T item = resultSetHandler.handle(new SpincastResultSetDefault(resultSet));
                            items.add(item);
                        }
                    }
                    long total = -1L;
                    if (getTotal && (total = this.getTotalFromSelectQuery(connection)) == -1L) {
                        logger.info("No generated 'total' query will be launch for this query, we'll return the number of fetched items as the 'total' : " + this.getOriginalQuery());
                        total = items.size();
                    }
                    itemsAndTotalCountDefault = listAndTotal = new ItemsAndTotalCountDefault(items, total);
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    throw throwable;
                }
                this.close(resultSet);
                return itemsAndTotalCountDefault;
            }
            finally {
                this.close(realStatement);
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected long getTotalFromSelectQuery(Connection connection) {
        try {
            String originalQuery = this.getOriginalQuery();
            originalQuery = StringUtils.replaceChars((String)originalQuery, (String)"\r\n\t", (String)"   ");
            originalQuery = originalQuery.trim();
            String originalQueryLower = originalQuery.toLowerCase();
            if (!originalQueryLower.startsWith("select ")) {
                throw new RuntimeException("To use this method, your query HAS to start with 'select' : " + originalQuery);
            }
            int posFrom = originalQueryLower.indexOf(" from ");
            if (posFrom < 0) {
                throw new RuntimeException("To use this method, your query has to contain a 'from' part : " + originalQuery);
            }
            int posLast = originalQueryLower.lastIndexOf(" limit ");
            if (posLast < 0) {
                return -1L;
            }
            int posLastOrderBy = originalQueryLower.lastIndexOf(" order by ");
            if (posLastOrderBy > 0 && posLastOrderBy < posLast) {
                posLast = posLastOrderBy;
            }
            String originalQueryBody = originalQuery.substring(posFrom, posLast);
            String totalQuery = "SELECT COUNT(*) AS total " + originalQueryBody;
            logger.debug("Generated 'Total' query : " + totalQuery);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(totalQuery);
            resultSet.next();
            long total = resultSet.getLong("total");
            return total;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }
}

