/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc.statements;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.jdbc.JdbcUtils;
import org.spincast.plugins.jdbc.statements.QueryResultFactory;
import org.spincast.plugins.jdbc.statements.Statement;
import org.spincast.plugins.jdbc.utils.BasicFormatterImpl;

public abstract class StatementBase
implements Statement {
    private StringBuilder queryBuilder;
    private String parsedQuery;
    private final Connection connection;
    private final QueryResultFactory queryResultFactory;
    private static final BasicFormatterImpl sqlFormmatter = new BasicFormatterImpl();
    private final Map<String, Set<Integer>> indexMap = new HashMap<String, Set<Integer>>();
    private Map<String, Object> params = new HashMap<String, Object>();
    private Map<String, String> staticTokens = new HashMap<String, String>();

    public StatementBase(Connection connection, QueryResultFactory queryResultFactory) {
        this.queryBuilder = new StringBuilder();
        this.connection = connection;
        this.queryResultFactory = queryResultFactory;
    }

    protected StringBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    protected BasicFormatterImpl getSqlFormmatter() {
        return sqlFormmatter;
    }

    @Override
    public void sql(String sql) {
        this.getQueryBuilder().append(sql);
    }

    @Override
    public void clearSql() {
        this.clearSql(false);
    }

    @Override
    public void clearSql(boolean keepCurrentBoundParams) {
        this.getQueryBuilder().setLength(0);
        if (!keepCurrentBoundParams) {
            this.getStaticTokens().clear();
            this.getParams().clear();
        }
    }

    @Override
    public String getSql(boolean friendly) {
        String sql = this.parse();
        if (friendly) {
            sql = this.getSqlFormmatter().format(sql);
        }
        return sql;
    }

    protected String getOriginalQuery() {
        return this.getQueryBuilder().toString();
    }

    protected String getParsedQuery() {
        if (this.parsedQuery == null) {
            this.parsedQuery = this.parse();
        }
        return this.parsedQuery;
    }

    protected Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, String> getStaticTokens() {
        return this.staticTokens;
    }

    protected String parse() {
        String query = this.getOriginalQuery();
        if (query == null || query.length() == 0) {
            return "";
        }
        Map<String, String> staticTokens = this.getStaticTokens();
        if (staticTokens != null) {
            for (Map.Entry<String, String> entry : staticTokens.entrySet()) {
                query = query.replace(":" + entry.getKey(), entry.getValue());
            }
        }
        Map<String, Set<Integer>> paramMap = this.getIndexMap();
        int length = query.length();
        StringBuffer parsedQuery = new StringBuffer(length);
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int index = 1;
        for (int i = 0; i < length; ++i) {
            int c = query.charAt(i);
            if (inSingleQuote) {
                if (c == 39) {
                    inSingleQuote = false;
                }
            } else if (inDoubleQuote) {
                if (c == 34) {
                    inDoubleQuote = false;
                }
            } else if (c == 39) {
                inSingleQuote = true;
            } else if (c == 34) {
                inDoubleQuote = true;
            } else if (c == 58 && i + 1 < length && Character.isJavaIdentifierStart(query.charAt(i + 1))) {
                int j;
                for (j = i + 2; j < length && Character.isJavaIdentifierPart(query.charAt(j)); ++j) {
                }
                String name = query.substring(i + 1, j);
                c = 63;
                i += name.length();
                Set<Integer> indexList = paramMap.get(name);
                if (indexList == null) {
                    indexList = new HashSet<Integer>();
                    paramMap.put(name, indexList);
                }
                indexList.add(new Integer(index));
                ++index;
            }
            if (c == 0) continue;
            parsedQuery.append((char)c);
        }
        return parsedQuery.toString();
    }

    protected void clearParams() {
        this.params = new HashMap<String, Object>();
    }

    protected QueryResultFactory getQueryResultFactory() {
        return this.queryResultFactory;
    }

    protected Map<String, Set<Integer>> getIndexMap() {
        return this.indexMap;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected void addCurrentParamsToStatement(PreparedStatement statement) {
        this.addParamsToStatement(statement, this.getParams());
    }

    protected void addParamsToStatement(PreparedStatement statement, Map<String, Object> params) {
        if (statement == null) {
            throw new RuntimeException("statement can't be NULL");
        }
        if (params == null || params.size() == 0) {
            return;
        }
        try {
            for (Map.Entry<String, Object> paramEntry : params.entrySet()) {
                String paramName = paramEntry.getKey();
                Object value = paramEntry.getValue();
                Set<Integer> indexes = this.getIndexMap().get(paramName);
                if (indexes == null) continue;
                for (Integer index : indexes) {
                    if (value instanceof Instant) {
                        Timestamp ts = Timestamp.from((Instant)value);
                        statement.setTimestamp(index, ts, JdbcUtils.UTC_CALENDAR);
                        continue;
                    }
                    if (value instanceof LocalDate) {
                        Date sqlDate = Date.valueOf((LocalDate)value);
                        statement.setDate(index, sqlDate);
                        continue;
                    }
                    statement.setObject(index, value);
                }
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected void close(PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addParam(String paramName, Object value) {
        this.getParams().put(paramName, value);
    }

    @Override
    public void setInstant(String paramName, Instant value) {
        this.addParam(paramName, value);
    }

    @Override
    public void setDate(String paramName, LocalDate value) {
        this.addParam(paramName, value);
    }

    @Override
    public void setString(String paramName, String value) {
        this.addParam(paramName, value);
    }

    @Override
    public void setBoolean(String paramName, Boolean value) {
        this.addParam(paramName, value);
    }

    @Override
    public void setInteger(String paramName, Integer value) {
        this.addParam(paramName, value);
    }

    @Override
    public void setLong(String paramName, Long value) {
        this.addParam(paramName, value);
    }

    @Override
    public void setFloat(String paramName, Float value) {
        this.addParam(paramName, value);
    }

    @Override
    public void setDouble(String paramName, Double value) {
        this.addParam(paramName, value);
    }

    @Override
    public void setInLong(String paramName, Set<Long> items) {
        StringBuilder in = new StringBuilder();
        if (items != null && items.size() > 0) {
            for (Long item : items) {
                if (item == null) continue;
                in.append(item).append(",");
            }
            if (in.length() > 0) {
                in.deleteCharAt(in.length() - 1);
            }
        }
        this.getStaticTokens().put(paramName, in.toString());
    }

    @Override
    public void setInInteger(String paramName, Set<Integer> items) {
        StringBuilder in = new StringBuilder();
        if (items != null && items.size() > 0) {
            for (Integer item : items) {
                if (item == null) continue;
                in.append(item).append(",");
            }
            if (in.length() > 0) {
                in.deleteCharAt(in.length() - 1);
            }
        }
        this.getStaticTokens().put(paramName, in.toString());
    }

    @Override
    public void setInString(String paramName, Set<String> items) {
        StringBuilder in = new StringBuilder();
        if (items != null && items.size() > 0) {
            for (String item : items) {
                if (item == null) continue;
                in.append("'").append(item).append("',");
            }
            if (in.length() > 0) {
                in.deleteCharAt(in.length() - 1);
            }
        }
        this.getStaticTokens().put(paramName, in.toString());
    }

    public String toString() {
        return this.getSql(true);
    }
}

