/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc;

import com.google.inject.Provider;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.spincast.plugins.jdbc.JdbcScope;

public class DataSourceInterceptor
implements MethodInterceptor {
    private final Provider<JdbcScope> jdbcScopeProvider;
    private JdbcScope jdbcScope;

    public DataSourceInterceptor(Provider<JdbcScope> jdbcScopeProvider) {
        this.jdbcScopeProvider = jdbcScopeProvider;
    }

    protected JdbcScope getJdbcScope() {
        if (this.jdbcScope == null) {
            this.jdbcScope = (JdbcScope)this.jdbcScopeProvider.get();
        }
        return this.jdbcScope;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!"getConnection".equals(invocation.getMethod().getName())) {
            return invocation.proceed();
        }
        return this.getJdbcScope().getConnectionInterceptor(invocation);
    }
}

