/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc.statements;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.jdbc.statements.BatchInsertStatement;
import org.spincast.plugins.jdbc.statements.StatementBase;

public class BatchInsertStatementDefault
extends StatementBase
implements BatchInsertStatement {
    protected static final Logger logger = LoggerFactory.getLogger(BatchInsertStatementDefault.class);
    private final List<Map<String, Object>> batchParams = new ArrayList<Map<String, Object>>();

    @AssistedInject
    public BatchInsertStatementDefault(@Assisted Connection connection) {
        super(connection);
    }

    protected List<Map<String, Object>> getBatchParams() {
        return this.batchParams;
    }

    protected void addBatchParams(Map<String, Object> params) {
        this.getBatchParams().add(params);
    }

    @Override
    public void addBatch() {
        this.addBatchParams(this.getParams());
        this.clearParams();
    }

    protected int getBatchInsertSize() {
        return this.getBatchParams().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] batchInsert() {
        int[] nArray;
        Connection connection = this.getConnection();
        PreparedStatement realStatement = connection.prepareStatement(this.getParsedQuery());
        try {
            int[] queryResults;
            for (Map<String, Object> params : this.getBatchParams()) {
                this.addParamsToStatement(realStatement, params);
                realStatement.addBatch();
            }
            nArray = queryResults = realStatement.executeBatch();
        }
        catch (Throwable throwable) {
            try {
                this.close(realStatement);
                throw throwable;
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        this.close(realStatement);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> batchInsert(String primaryKeyName) {
        ArrayList<Long> arrayList;
        Connection connection = this.getConnection();
        PreparedStatement realStatement = connection.prepareStatement(this.getParsedQuery(), new String[]{primaryKeyName});
        try {
            for (Map<String, Object> params : this.getBatchParams()) {
                this.addParamsToStatement(realStatement, params);
                realStatement.addBatch();
            }
            int[] queryResults = realStatement.executeBatch();
            ArrayList<Long> generatedKeys = new ArrayList<Long>();
            ResultSet resultSet = realStatement.getGeneratedKeys();
            if (resultSet != null && resultSet.next()) {
                int pos = 0;
                do {
                    generatedKeys.add(resultSet.getLong(1));
                    ++pos;
                } while (resultSet.next());
                if (pos != queryResults.length) {
                    throw new RuntimeException("Unable to get all the generated ids!");
                }
            } else {
                throw new RuntimeException("Unable to get the generated ids!");
            }
            arrayList = generatedKeys;
        }
        catch (Throwable throwable) {
            try {
                this.close(realStatement);
                throw throwable;
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        this.close(realStatement);
        return arrayList;
    }
}

