/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jsclosurecompiler;

import com.google.inject.Inject;
import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.extension.escaper.SafeString;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.routing.Router;
import org.spincast.core.server.Server;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.httpclient.HttpClient;
import org.spincast.plugins.httpclient.HttpResponse;
import org.spincast.plugins.httpclient.builders.GetRequestBuilder;
import org.spincast.plugins.jsclosurecompiler.SpincastJsClosureCompilerManager;
import org.spincast.plugins.jsclosurecompiler.SpincastJsClosureCompilerPebbleExtension;
import org.spincast.plugins.jsclosurecompiler.config.SpincastJsClosureCompilerConfig;
import org.spincast.shaded.org.apache.commons.codec.digest.DigestUtils;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastJsClosureCompilerPebbleExtensionDefault
extends AbstractExtension
implements SpincastJsClosureCompilerPebbleExtension {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastJsClosureCompilerPebbleExtensionDefault.class);
    public static final String JS_BUNDLE_FUNCTION_ARG_DISABLE_CACHE_BUSTING = "--spincast-no-cache-busting";
    protected static final String HASH_LINE_START = "/*hash:";
    protected static final String HASH_LINE_END = "*/";
    private final SpincastJsClosureCompilerConfig spincastJsClosureCompilerConfig;
    private final SpincastConfig spincastConfig;
    private final SpincastUtils spincastUtils;
    private final Router<?, ?> router;
    private final Server server;
    private final HttpClient httpClient;
    private final SpincastJsClosureCompilerManager spincastJsClosureCompilerManager;
    private final ReentrantLock jsBundleLock = new ReentrantLock();

    @Inject
    public SpincastJsClosureCompilerPebbleExtensionDefault(SpincastJsClosureCompilerConfig spincastJsClosureCompilerConfig, SpincastConfig spincastConfig, SpincastUtils spincastUtils, Router<?, ?> router, Server server, HttpClient httpClient, SpincastJsClosureCompilerManager spincastJsClosureCompilerManager) {
        this.spincastJsClosureCompilerConfig = spincastJsClosureCompilerConfig;
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
        this.router = router;
        this.server = server;
        this.httpClient = httpClient;
        this.spincastJsClosureCompilerManager = spincastJsClosureCompilerManager;
    }

    protected SpincastJsClosureCompilerConfig getSpincastJsClosureCompilerConfig() {
        return this.spincastJsClosureCompilerConfig;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected Router<?, ?> getRouter() {
        return this.router;
    }

    protected Server getServer() {
        return this.server;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected SpincastJsClosureCompilerManager getSpincastJsClosureCompilerManager() {
        return this.spincastJsClosureCompilerManager;
    }

    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put(this.getSpincastJsClosureCompilerConfig().getJsBundlePebbleFunctionName(), new Function(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext evaluationContext, int lineNumber) {
                String urlPath;
                List numericalKeys = args.keySet().stream().filter(key -> StringUtils.isNumeric((CharSequence)key)).sorted().collect(Collectors.toList());
                ArrayList<String> jsFilesUrlRelativePaths = new ArrayList<String>();
                ArrayList<String> cmdArgs = new ArrayList<String>();
                boolean disableCacheBusting = false;
                boolean inArgs = false;
                for (String numericalKey : numericalKeys) {
                    String val = args.get(numericalKey).toString();
                    if (!inArgs) {
                        if (val.startsWith("-")) {
                            inArgs = true;
                        } else {
                            jsFilesUrlRelativePaths.add(val);
                            continue;
                        }
                    }
                    if (val.startsWith("-spincast") || val.startsWith("--spincast")) {
                        if (!SpincastJsClosureCompilerPebbleExtensionDefault.JS_BUNDLE_FUNCTION_ARG_DISABLE_CACHE_BUSTING.equals(val)) continue;
                        disableCacheBusting = true;
                        continue;
                    }
                    cmdArgs.add(val);
                }
                if (jsFilesUrlRelativePaths.size() == 0) {
                    return "";
                }
                if (SpincastJsClosureCompilerPebbleExtensionDefault.this.getSpincastJsClosureCompilerConfig().isJsBundlesDisabled()) {
                    logger.info("JS bundling disabled, outputing regular files!");
                    return SpincastJsClosureCompilerPebbleExtensionDefault.this.bundlingDisabledOutput(jsFilesUrlRelativePaths);
                }
                String bundleName = SpincastJsClosureCompilerPebbleExtensionDefault.this.generateJsBundleName(jsFilesUrlRelativePaths);
                File bundleFile = SpincastJsClosureCompilerPebbleExtensionDefault.this.getJsBundleFile(bundleName);
                boolean bundleAvailable = SpincastJsClosureCompilerPebbleExtensionDefault.this.bundleJs(bundleFile, jsFilesUrlRelativePaths, urlPath = SpincastJsClosureCompilerPebbleExtensionDefault.this.generateJsBundleUrlPath(bundleName, false), cmdArgs);
                if (!bundleAvailable) {
                    logger.info("JS bundle not available yet (being created by another thread), outputing regular files!");
                    return SpincastJsClosureCompilerPebbleExtensionDefault.this.bundlingDisabledOutput(jsFilesUrlRelativePaths);
                }
                String path = SpincastJsClosureCompilerPebbleExtensionDefault.this.generateJsBundleUrlPath(bundleName, !disableCacheBusting);
                return SpincastJsClosureCompilerPebbleExtensionDefault.this.bundlingOutput(path);
            }
        });
        return functions;
    }

    protected Object bundlingDisabledOutput(List<String> jsFilesUrlRelativePaths) {
        StringBuilder builder = new StringBuilder();
        for (String path : jsFilesUrlRelativePaths) {
            builder.append("<script src=\"").append(path).append("\"></script>\n");
        }
        return new SafeString(builder.toString());
    }

    protected Object bundlingOutput(String path) {
        return new SafeString("<script src=\"" + path + "\"></script>\n");
    }

    protected boolean bundleJs(File bundleFile, List<String> jsFilesUrlRelativePaths, String urlPath, List<String> cmdArgs) {
        if (bundleFile.isFile() && this.getServer().getStaticResourceServed(urlPath) != null) {
            return true;
        }
        if (this.jsBundleLock.tryLock()) {
            try {
                if (bundleFile.isFile() && this.getServer().getStaticResourceServed(urlPath) != null) {
                    boolean bl = true;
                    return bl;
                }
                StringBuilder content = new StringBuilder();
                Object publicUrlBase = this.getSpincastConfig().getPublicUrlBase();
                if (!((String)publicUrlBase).endsWith("/")) {
                    publicUrlBase = (String)publicUrlBase + "/";
                }
                logger.info("Getting JS files via HTTP to bundle them together...");
                for (String jsFileUrlRelativePath : jsFilesUrlRelativePaths) {
                    HttpResponse response;
                    jsFileUrlRelativePath = StringUtils.stripStart((String)jsFileUrlRelativePath, (String)"/");
                    String url = (String)publicUrlBase + jsFileUrlRelativePath;
                    GetRequestBuilder requestBuilder = this.getHttpClient().GET(url);
                    if (this.getSpincastJsClosureCompilerConfig().isJsBundlesIgnoreSslCertificateErrors()) {
                        requestBuilder = (GetRequestBuilder)requestBuilder.disableSslCertificateErrors();
                    }
                    if ((response = requestBuilder.send()).getStatus() != 200) {
                        throw new RuntimeException("Invalid response for file '" + url + "' : " + response.getStatus());
                    }
                    content.append(response.getContentAsString() + "\n");
                }
                String all = content.toString();
                String newContentHash = DigestUtils.md5Hex((String)all.toString());
                logger.info("JS files all gotten. Content hash: " + newContentHash);
                String existingContentHash = this.getExistingBundleFileHash(bundleFile);
                if (existingContentHash == null || !existingContentHash.equals(newContentHash)) {
                    logger.info("Optimizing the JS content...");
                    Object optimizedContent = this.getSpincastJsClosureCompilerManager().compile(all, cmdArgs);
                    logger.info("JS content optimized!");
                    optimizedContent = HASH_LINE_START + newContentHash + "*/\n" + (String)optimizedContent;
                    FileUtils.writeStringToFile((File)bundleFile, (String)optimizedContent, (String)"UTF-8");
                } else {
                    logger.info("JS content not changed, no need to optimize.");
                }
                if (this.getServer().getStaticResourceServed(urlPath) == null) {
                    this.getRouter().file(urlPath).cache(31536000).pathAbsolute(bundleFile.getAbsolutePath()).handle();
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
            finally {
                this.jsBundleLock.unlock();
            }
        }
        return false;
    }

    protected String getExistingBundleFileHash(File bundleFile) {
        String string;
        if (!bundleFile.isFile()) {
            return null;
        }
        BufferedReader buff = new BufferedReader(new FileReader(bundleFile));
        try {
            String hash;
            String line = buff.readLine();
            if (StringUtils.isBlank((CharSequence)line)) {
                throw new RuntimeException("Unable to read the first line of: " + bundleFile.getAbsolutePath());
            }
            if (!line.startsWith(HASH_LINE_START) || !line.endsWith(HASH_LINE_END)) {
                throw new RuntimeException("First line must be '/*hash:xxxxxx*/': " + bundleFile.getAbsolutePath());
            }
            string = hash = line.substring(HASH_LINE_START.length(), line.length() - HASH_LINE_END.length());
        }
        catch (Throwable throwable) {
            try {
                try {
                    buff.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        buff.close();
        return string;
    }

    protected String generateJsBundleName(List<String> jsFilesUrlRelativePaths) {
        StringBuilder builder = new StringBuilder();
        for (String path : jsFilesUrlRelativePaths) {
            builder.append(path).append("|");
        }
        String hash = DigestUtils.md5Hex((String)builder.toString());
        return hash;
    }

    protected File getJsBundleFile(String hash) {
        File dir = this.getSpincastJsClosureCompilerConfig().getJsBundlesDir();
        if (!dir.isDirectory()) {
            try {
                FileUtils.forceMkdir((File)dir);
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        return new File(dir, hash + ".js");
    }

    protected String generateJsBundleUrlPath(String hash, boolean withCacheBuster) {
        Object path = this.getSpincastJsClosureCompilerConfig().getJsBundlesUrlPath();
        if (StringUtils.isBlank((CharSequence)path)) {
            path = "/";
        } else if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (withCacheBuster) {
            path = (String)path + this.getSpincastUtils().getCacheBusterCode();
        }
        path = (String)path + hash + ".js";
        return path;
    }
}

