/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jsclosurecompiler;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.jsclosurecompiler.SpincastJsClosureCompilerCommandLineRunner;
import org.spincast.plugins.jsclosurecompiler.SpincastJsClosureCompilerManager;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastJsClosureCompilerManagerDefault
implements SpincastJsClosureCompilerManager {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastJsClosureCompilerManagerDefault.class);
    private final SpincastConfig spincastConfig;
    private final SpincastUtils spincastUtils;

    @Inject
    public SpincastJsClosureCompilerManagerDefault(SpincastConfig spincastConfig, SpincastUtils spincastUtils) {
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected File createJsFile(String jsContent) {
        try {
            File jsFile = new File(this.getSpincastConfig().getTempDir(), this.getClass().getSimpleName() + "/" + UUID.randomUUID().toString() + ".js");
            FileUtils.writeStringToFile((File)jsFile, (String)jsContent, (String)"UTF-8");
            return jsFile;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public String compile(String jsContent, String ... args) {
        if (StringUtils.isBlank((CharSequence)jsContent)) {
            return "";
        }
        List argsList = SpincastStatics.toList((Object[])args, (boolean)true);
        return this.compile(jsContent, (List<String>)argsList);
    }

    @Override
    public String compile(String jsContent, List<String> args) {
        if (StringUtils.isBlank((CharSequence)jsContent)) {
            return "";
        }
        File tempJsFile = null;
        try {
            tempJsFile = this.createJsFile(jsContent);
            String string = this.compile(tempJsFile, args);
            return string;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        finally {
            FileUtils.deleteQuietly((File)tempJsFile);
        }
    }

    @Override
    public String compile(File jsFile, String ... args) {
        Objects.requireNonNull(jsFile, "The jsFile can't be NULL");
        List argsList = SpincastStatics.toList((Object[])args, (boolean)true);
        return this.compile(jsFile, (List<String>)argsList);
    }

    @Override
    public String compile(File jsFile, List<String> args) {
        Objects.requireNonNull(jsFile, "The jsFile can't be NULL");
        return this.compile((List<File>)Lists.newArrayList((Object[])new File[]{jsFile}), args);
    }

    @Override
    public String compile(List<File> jsFiles, String ... args) {
        if (jsFiles == null || jsFiles.size() == 0) {
            throw new RuntimeException("At least one js file is required");
        }
        List argsList = SpincastStatics.toList((Object[])args, (boolean)true);
        return this.compile(jsFiles, (List<String>)argsList);
    }

    @Override
    public String compile(List<File> jsFiles, List<String> args) {
        if (jsFiles == null || jsFiles.size() == 0) {
            throw new RuntimeException("At least one js file is required");
        }
        ArrayList<String> argsList = args != null ? args : new ArrayList<String>();
        for (File jsFile : jsFiles) {
            if (jsFile == null) {
                throw new RuntimeException("Specified file is null");
            }
            argsList.add(jsFile.getAbsolutePath());
        }
        return this.compileCustom(argsList);
    }

    @Override
    public String compileCustom(String ... args) {
        if (args == null || args.length == 0) {
            throw new RuntimeException("You at least have to specify the js files to target.");
        }
        return this.compileCustom(SpincastStatics.toList((Object[])args, (boolean)true));
    }

    @Override
    public String compileCustom(List<String> args) {
        if (args == null || args.size() == 0) {
            throw new RuntimeException("You at least have to specify the js files to target.");
        }
        File tempJsFile = null;
        try {
            String resultContent;
            tempJsFile = this.createJsFile("");
            ArrayList<Object> argsList = new ArrayList<Object>();
            argsList.add("--js_output_file=" + tempJsFile.getAbsolutePath());
            for (String arg : args) {
                if (arg == null) {
                    throw new RuntimeException("One of the argument is null: " + args);
                }
                if (arg.toLowerCase().startsWith("--js_output_file=")) {
                    logger.warn("You cannot specify the '--js_output_file=' option! This method takes care of it by itself. Ignoring this argument...");
                    continue;
                }
                argsList.add(arg);
            }
            logger.info("Running the Closure Compiler... Arguments: " + ((Object)argsList).toString());
            SpincastJsClosureCompilerCommandLineRunner runner = new SpincastJsClosureCompilerCommandLineRunner((String[])SpincastStatics.toArray(argsList, String.class));
            if (runner.shouldRunCompiler()) {
                runner.run();
            }
            if (runner.hasErrors()) {
                throw new RuntimeException("Errors running the closure compiler!");
            }
            logger.info("The Closure Compiler ran without any errors.");
            String string = resultContent = FileUtils.readFileToString((File)tempJsFile, (String)"UTF-8");
            return string;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        finally {
            FileUtils.deleteQuietly((File)tempJsFile);
        }
    }
}

