/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.localeresolver;

import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.util.Locale;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.cookies.ICookie;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.locale.ILocaleResolver;
import org.spincast.shaded.org.apache.commons.lang3.LocaleUtils;

public class SpincastLocaleResolver
implements ILocaleResolver {
    private final ISpincastConfig spincastConfig;
    private final Provider<IRequestContext<?>> requestContextProvider;

    @Inject
    public SpincastLocaleResolver(ISpincastConfig spincastConfig, Provider<IRequestContext<?>> requestContextProvider) {
        this.spincastConfig = spincastConfig;
        this.requestContextProvider = requestContextProvider;
    }

    protected ISpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Provider<IRequestContext<?>> getRequestContextProvider() {
        return this.requestContextProvider;
    }

    public Locale getLocaleToUse() {
        try {
            Locale requestLocaleBestMatch;
            IRequestContext context = (IRequestContext)this.getRequestContextProvider().get();
            ICookie cookie = context.cookies().getCookie("locale");
            if (cookie != null && !cookie.isExpired()) {
                try {
                    Locale locale = LocaleUtils.toLocale((String)cookie.getValue());
                    return locale;
                }
                catch (Exception ex) {
                    context.cookies().deleteCookie("locale");
                }
            }
            if ((requestLocaleBestMatch = context.request().getLocaleBestMatch()) != null) {
                return requestLocaleBestMatch;
            }
        }
        catch (OutOfScopeException | ProvisionException throwable) {
            // empty catch block
        }
        return this.getSpincastConfig().getDefaultLocale();
    }
}

