/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.localeresolver;

import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.util.Locale;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.locale.LocaleResolver;
import org.spincast.shaded.org.apache.commons.lang3.LocaleUtils;

public class LocaleResolverDefault
implements LocaleResolver {
    private final SpincastConfig spincastConfig;
    private final Provider<RequestContext<?>> requestContextProvider;

    @Inject
    public LocaleResolverDefault(SpincastConfig spincastConfig, Provider<RequestContext<?>> requestContextProvider) {
        this.spincastConfig = spincastConfig;
        this.requestContextProvider = requestContextProvider;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Provider<RequestContext<?>> getRequestContextProvider() {
        return this.requestContextProvider;
    }

    public Locale getLocaleToUse() {
        try {
            Locale requestLocaleBestMatch;
            RequestContext context = (RequestContext)this.getRequestContextProvider().get();
            String cookieValue = context.request().getCookieValue(this.getSpincastConfig().getCookieNameLocale());
            if (cookieValue != null) {
                try {
                    Locale locale = LocaleUtils.toLocale((String)cookieValue);
                    return locale;
                }
                catch (Exception ex) {
                    context.response().deleteCookie(this.getSpincastConfig().getCookieNameLocale());
                }
            }
            if ((requestLocaleBestMatch = context.request().getLocaleBestMatch()) != null) {
                return requestLocaleBestMatch;
            }
        }
        catch (OutOfScopeException | ProvisionException throwable) {
            // empty catch block
        }
        return this.getSpincastConfig().getDefaultLocale();
    }
}

