/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.openapi.bottomup;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiScanner;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.StubMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.json.JsonManager;
import org.spincast.core.routing.DefaultRouteParamAliasesBinder;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.Route;
import org.spincast.core.routing.Router;
import org.spincast.core.routing.RoutingType;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.plugins.openapi.bottomup.Specs;
import org.spincast.plugins.openapi.bottomup.SpincastOpenApiBottomUpPlugin;
import org.spincast.plugins.openapi.bottomup.SpincastOpenApiManager;
import org.spincast.plugins.openapi.bottomup.config.SpincastOpenApiBottomUpPluginConfig;
import org.spincast.plugins.openapi.bottomup.utils.SwaggerAnnotationsCreator;
import org.spincast.shaded.org.apache.commons.codec.digest.DigestUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastOpenApiManagerDefault<R extends RequestContext<?>, W extends WebsocketContext<?>>
implements SpincastOpenApiManager {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastOpenApiManagerDefault.class);
    private final Router<R, W> router;
    private final JsonManager jsonManager;
    private final SpincastOpenApiBottomUpPluginConfig spincastOpenApiBottomUpPluginConfig;
    private final SwaggerAnnotationsCreator annotationsCreator;
    private final DefaultRouteParamAliasesBinder<R, W> defaultRouteParamAliasesBinder;
    private OpenAPI baseOpenApiInfo;
    private OpenAPI openApi;
    private String openApiAsJson;
    private String openApiAsJsonPretty;
    private String openApiAsYaml;
    private String openApiAsYamlPretty;
    private Set<String> routeIdsToHide;
    private Set<String> routeHttpMethodAndPathToHide;

    @Inject
    public SpincastOpenApiManagerDefault(Router<R, W> router, JsonManager jsonManager, SpincastOpenApiBottomUpPluginConfig spincastOpenApiBottomUpPluginConfig, SwaggerAnnotationsCreator annotationsCreator, DefaultRouteParamAliasesBinder<R, W> defaultRouteParamAliasesBinder) {
        this.router = router;
        this.jsonManager = jsonManager;
        this.spincastOpenApiBottomUpPluginConfig = spincastOpenApiBottomUpPluginConfig;
        this.annotationsCreator = annotationsCreator;
        this.defaultRouteParamAliasesBinder = defaultRouteParamAliasesBinder;
    }

    protected Router<R, W> getRouter() {
        return this.router;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected SpincastOpenApiBottomUpPluginConfig getSpincastOpenApiBottomUpPluginConfig() {
        return this.spincastOpenApiBottomUpPluginConfig;
    }

    protected SwaggerAnnotationsCreator getAnnotationsCreator() {
        return this.annotationsCreator;
    }

    protected DefaultRouteParamAliasesBinder<R, W> getDefaultRouteParamAliasesBinder() {
        return this.defaultRouteParamAliasesBinder;
    }

    public Set<String> getRouteIdsToHide() {
        if (this.routeIdsToHide == null) {
            this.routeIdsToHide = new HashSet<String>();
        }
        return this.routeIdsToHide;
    }

    public Set<String> getRouteHttpMethodAndPathToHide() {
        if (this.routeHttpMethodAndPathToHide == null) {
            this.routeHttpMethodAndPathToHide = new HashSet<String>();
        }
        return this.routeHttpMethodAndPathToHide;
    }

    @Override
    public void clearCache() {
        this.openApi = null;
        this.openApiAsJson = null;
        this.openApiAsJsonPretty = null;
        this.openApiAsYaml = null;
        this.openApiAsYamlPretty = null;
    }

    @Override
    public void resetAll() {
        this.baseOpenApiInfo = new OpenAPI();
        this.clearCache();
        this.getRouteIdsToHide().clear();
        this.getRouteHttpMethodAndPathToHide().clear();
    }

    @Override
    public void setOpenApiBase(OpenAPI baseOpenApiInfo) {
        this.baseOpenApiInfo = baseOpenApiInfo;
    }

    public OpenAPI getBaseOpenApiInfo() {
        return this.baseOpenApiInfo;
    }

    @Override
    @Parameters
    public OpenAPI getOpenApi() {
        if (this.openApi == null) {
            try {
                OpenAPI baseInfos = this.getBaseOpenApiInfo();
                if (baseInfos == null) {
                    baseInfos = new OpenAPI();
                }
                Set<Class<?>> classes = this.generateJaxRsLikeClasses();
                OpenApiScanner scanner = this.createScanner(classes);
                this.addYamlStringSpecifiedPaths(baseInfos);
                SwaggerConfiguration swaggerConfiguration = new SwaggerConfiguration().openAPI(baseInfos);
                JaxrsOpenApiContext context = new JaxrsOpenApiContext();
                context.setOpenApiConfiguration((OpenAPIConfiguration)swaggerConfiguration);
                context.setOpenApiScanner(scanner);
                context.init();
                this.openApi = context.read();
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        return this.openApi;
    }

    protected OpenApiScanner createScanner(final Set<Class<?>> classes) {
        OpenApiScanner scanner = new OpenApiScanner(){

            public void setConfiguration(OpenAPIConfiguration openApiConfiguration) {
            }

            public Map<String, Object> resources() {
                return new HashMap<String, Object>();
            }

            public Set<Class<?>> classes() {
                return classes;
            }
        };
        return scanner;
    }

    protected Set<Class<?>> generateJaxRsLikeClasses() {
        if (this.getSpincastOpenApiBottomUpPluginConfig().isDisableAutoSpecs()) {
            logger.info("Auto specs generation disabled from the configs.");
            return new HashSet();
        }
        try {
            List mainRoutes = this.getRouter().getMainRoutes();
            if (mainRoutes == null || mainRoutes.size() == 0) {
                return Sets.newHashSet();
            }
            DynamicType.Builder classBuilder = new ByteBuddy().subclass(Object.class).annotateType(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(Path.class).define("value", "").build()});
            HashSet<String> operationIdsUsed = new HashSet<String>();
            for (Route route : mainRoutes) {
                if (route.getRoutingTypes() != null && !route.getRoutingTypes().contains(RoutingType.FOUND)) {
                    logger.info("Route without routing type RoutingType.FOUND. Ignoring: " + route);
                    continue;
                }
                if (route.isStaticResourceRoute()) {
                    logger.info("Static resources route. Ignoring: " + route);
                    continue;
                }
                if (route.isWebsocketRoute()) {
                    logger.info("Websocket routes not supported. Ignoring: " + route);
                    continue;
                }
                if (route.isSpecsIgnore() || this.isToHideFromId(route)) {
                    logger.info("Route hidden from specs, won't be added:" + route);
                    continue;
                }
                if (route.getHttpMethods() == null || route.getHttpMethods().size() == 0) {
                    throw new RuntimeException("Not supposed. At least one HTTP method required!");
                }
                for (HttpMethod httpMethod : route.getHttpMethods()) {
                    if (!this.isSupportedHttpMethod(httpMethod)) {
                        logger.warn("Unmanaged HTTP method \"" + httpMethod + "\" will be ignored for route : " + route);
                        continue;
                    }
                    if (this.isToHideFromHttpMethodAndPath(route, httpMethod)) {
                        logger.info("Route hidden from specs, won't be added: [" + httpMethod.name() + "] " + route);
                        continue;
                    }
                    String operationId = this.createOperationId(route, httpMethod);
                    if (operationIdsUsed.contains(operationId)) {
                        logger.warn("Duplicate route, ignoring: " + route);
                        continue;
                    }
                    operationIdsUsed.add(operationId);
                    Object specs = route.getSpecs();
                    if (specs != null && specs instanceof String) continue;
                    ArrayList<Annotation> handlerMethodAnnotations = new ArrayList<Annotation>();
                    Specs specsAnnotation = this.getSpecsAnnotation(route.getSpecs());
                    if (specs != null && specsAnnotation == null) {
                        logger.warn("The " + SpincastOpenApiBottomUpPlugin.class.getSimpleName() + " plugin currently only understands a YAML string or an anonymous class annotated with @Specs as the first parameter to the '.specs(...)' method when building a route.Neither was found on this route so we ignore it: " + route);
                        continue;
                    }
                    this.addHttpMethodAnnotation(handlerMethodAnnotations, httpMethod);
                    this.addPathAnnotationToHandlerMethod(handlerMethodAnnotations, route.getPath());
                    this.addConsumesAnnotationToHandlerMethod(handlerMethodAnnotations, specsAnnotation, route);
                    this.addProducesAnnotationToHandlerMethod(handlerMethodAnnotations, specsAnnotation);
                    this.addOperationAnnotationToHandlerMethod(handlerMethodAnnotations, specsAnnotation);
                    this.addParametersAnnotationToHandlerMethod(handlerMethodAnnotations, route.getPath(), specsAnnotation);
                    classBuilder = classBuilder.defineMethod(operationId, Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)StubMethod.INSTANCE).annotateMethod(handlerMethodAnnotations);
                }
            }
            Class clazz = classBuilder.make().load(this.getClass().getClassLoader()).getLoaded();
            return Sets.newHashSet((Object[])new Class[]{clazz});
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected boolean isSupportedHttpMethod(HttpMethod httpMethod) {
        return httpMethod == HttpMethod.GET || httpMethod == HttpMethod.POST || httpMethod == HttpMethod.PUT || httpMethod == HttpMethod.PATCH || httpMethod == HttpMethod.DELETE || httpMethod == HttpMethod.HEAD || httpMethod == HttpMethod.OPTIONS;
    }

    protected Paths getPathsFromYamlString(String routePath, String specs) {
        String specsStr = this.getOpenApiPrefix() + "\npaths:\n  " + routePath + ":\n";
        String[] lines = specs.split("\\r?\\n");
        for (int i = 0; i < lines.length; ++i) {
            specsStr = specsStr + "    " + lines[i] + "\n";
        }
        SwaggerParseResult readContents = new OpenAPIV3Parser().readContents(specsStr);
        OpenAPI openAPI = readContents.getOpenAPI();
        if (openAPI == null) {
            throw new RuntimeException("Unable to parse the YAML specs on route with path \"" + routePath + "\":\n" + Arrays.toString(readContents.getMessages().toArray()));
        }
        Paths paths = openAPI.getPaths();
        return paths;
    }

    protected String getOpenApiPrefix() {
        return "openapi: 3.0.1";
    }

    protected boolean isToHideFromId(Route<R> route) {
        return route.getId() != null && this.getRouteIdsToHide().contains(route.getId());
    }

    protected boolean isToHideFromHttpMethodAndPath(Route<R> route, HttpMethod httpMethod) {
        String key = this.createHttpMethodAndPathKey(httpMethod, route.getPath());
        String keyAnyMethod = this.createHttpMethodAndPathKey(null, route.getPath());
        return this.getRouteHttpMethodAndPathToHide().contains(key) || this.getRouteHttpMethodAndPathToHide().contains(keyAnyMethod);
    }

    protected String createOperationId(Route<R> route, HttpMethod httpMethod) {
        String operationId = route.getId();
        if (StringUtils.isBlank((CharSequence)operationId)) {
            operationId = httpMethod + route.getPath();
        }
        operationId = "r" + DigestUtils.md5Hex((String)operationId);
        return operationId;
    }

    protected void addHttpMethodAnnotation(List<Annotation> handlerMethodAnnotations, HttpMethod httpMethod) {
        Annotation annotation = this.getHttpMethodAnnotation(httpMethod);
        handlerMethodAnnotations.add(annotation);
    }

    protected Annotation getHttpMethodAnnotation(HttpMethod httpMethod) {
        if (httpMethod == HttpMethod.GET) {
            return new GET(){

                public Class<? extends Annotation> annotationType() {
                    return GET.class;
                }
            };
        }
        if (httpMethod == HttpMethod.DELETE) {
            return new DELETE(){

                public Class<? extends Annotation> annotationType() {
                    return DELETE.class;
                }
            };
        }
        if (httpMethod == HttpMethod.HEAD) {
            return new HEAD(){

                public Class<? extends Annotation> annotationType() {
                    return HEAD.class;
                }
            };
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return new OPTIONS(){

                public Class<? extends Annotation> annotationType() {
                    return OPTIONS.class;
                }
            };
        }
        if (httpMethod == HttpMethod.PATCH) {
            return new PATCH(){

                public Class<? extends Annotation> annotationType() {
                    return PATCH.class;
                }
            };
        }
        if (httpMethod == HttpMethod.POST) {
            return new POST(){

                public Class<? extends Annotation> annotationType() {
                    return POST.class;
                }
            };
        }
        if (httpMethod == HttpMethod.PUT) {
            return new PUT(){

                public Class<? extends Annotation> annotationType() {
                    return PUT.class;
                }
            };
        }
        throw new RuntimeException("HTTP method not managed: " + httpMethod);
    }

    protected void addPathAnnotationToHandlerMethod(List<Annotation> handlerMethodAannotations, final String routePath) {
        handlerMethodAannotations.add((Annotation)new Path(){

            public Class<? extends Annotation> annotationType() {
                return Path.class;
            }

            public String value() {
                String path = SpincastOpenApiManagerDefault.this.convertSpincastRoutePathToOpenApiFormat(routePath);
                return path;
            }
        });
    }

    protected String convertSpincastRoutePathToOpenApiFormat(String spincastRoutePath) {
        String path = spincastRoutePath.replaceAll("/(\\$\\{([^}:]+)(:([^}]+))?\\})", "/{$2}");
        return path;
    }

    protected Specs getSpecsAnnotation(Object specsObj) {
        try {
            if (specsObj == null) {
                return null;
            }
            Class<?> c = specsObj.getClass();
            AnnotatedType[] annotatedInterfaces = c.getAnnotatedInterfaces();
            Specs specsAnnotation = null;
            if (annotatedInterfaces == null || annotatedInterfaces.length <= 0) {
                return null;
            }
            specsAnnotation = annotatedInterfaces[0].getAnnotation(Specs.class);
            return specsAnnotation;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected void addOperationAnnotationToHandlerMethod(List<Annotation> handlerMethodAnnotations, Specs specs) {
        if (specs == null) {
            return;
        }
        Operation operationAnnotation = specs.value();
        if (operationAnnotation != null) {
            handlerMethodAnnotations.add((Annotation)operationAnnotation);
        }
    }

    protected void addParametersAnnotationToHandlerMethod(List<Annotation> handlerMethodAnnotations, String routePath, Specs specs) {
        Operation operationAnnotation = specs != null ? specs.value() : null;
        Pattern pattern = Pattern.compile("/(\\$\\{([^}:]+)(:([^}]+))?\\})");
        Matcher matcher = pattern.matcher(routePath);
        ArrayList<Parameter> parameterAnnotationsList = new ArrayList<Parameter>();
        while (matcher.find()) {
            String paramName = matcher.group(2);
            String paramPattern = matcher.group(4);
            if (this.isOperationAnnotationContainsParameter(operationAnnotation, paramName)) continue;
            String paramDescription = "";
            if (paramPattern != null && paramPattern.startsWith("<") && paramPattern.endsWith(">")) {
                String alias = paramPattern.substring(1, paramPattern.length() - 1);
                paramDescription = this.createParamDescriptionFromAlias(alias);
                if (paramDescription == null) {
                    paramDescription = paramPattern;
                }
                paramPattern = this.createParamPatternFromAlias(alias);
            }
            Parameter parameterAnnotation = this.getAnnotationsCreator().createPathParameterAnnotation(paramName, paramDescription, paramPattern);
            parameterAnnotationsList.add(parameterAnnotation);
        }
        Parameters parameters = this.getAnnotationsCreator().createParametersAnnotation(parameterAnnotationsList);
        handlerMethodAnnotations.add((Annotation)parameters);
    }

    protected String createParamDescriptionFromAlias(String alias) {
        if (this.getDefaultRouteParamAliasesBinder().getAlphaAliasKey().equals(alias)) {
            return "Alpha characters";
        }
        if (this.getDefaultRouteParamAliasesBinder().geNumericAliasKey().equals(alias)) {
            return "Numeric characters";
        }
        if (this.getDefaultRouteParamAliasesBinder().getAlphaPlusAliasKey().equals(alias)) {
            return "Alpha characters, \"_\" and \"-\"";
        }
        if (this.getDefaultRouteParamAliasesBinder().geNumericPlusAliasKey().equals(alias)) {
            return "Numeric characters, \"_\" and \"-\"";
        }
        if (this.getDefaultRouteParamAliasesBinder().getAlphaNumericAliasKey().equals(alias)) {
            return "Alphanumeric characters";
        }
        if (this.getDefaultRouteParamAliasesBinder().getAlphaNumericPlusAliasKey().equals(alias)) {
            return "Alphanumeric characters, \"_\" and \"-\"";
        }
        return null;
    }

    protected String createParamPatternFromAlias(String alias) {
        Map routeParamPatternAliases = this.getRouter().getRouteParamPatternAliases();
        String pattern = (String)routeParamPatternAliases.get(alias);
        return pattern;
    }

    protected boolean isOperationAnnotationContainsParameter(Operation operationAnnotation, String paramName) {
        if (operationAnnotation == null || paramName == null || operationAnnotation.parameters() == null) {
            return false;
        }
        for (Parameter parameter : operationAnnotation.parameters()) {
            if (parameter == null || !paramName.equals(parameter.name())) continue;
            return true;
        }
        return false;
    }

    protected void addConsumesAnnotationToHandlerMethod(List<Annotation> handlerMethodAnnotations, Specs specs, Route<R> route) {
        Consumes consumesAnnotation = null;
        if (specs != null && specs.consumes() != null && specs.consumes().value() != null && specs.consumes().value().length > 0 && !"".equals(specs.consumes().value()[0])) {
            consumesAnnotation = specs.consumes();
        } else {
            String[] acceptedContentTypes = null;
            Set acceptedContentTypesFromRoute = route.getAcceptedContentTypes();
            acceptedContentTypes = acceptedContentTypesFromRoute != null && acceptedContentTypesFromRoute.size() > 0 ? acceptedContentTypesFromRoute.toArray(new String[acceptedContentTypesFromRoute.size()]) : this.getSpincastOpenApiBottomUpPluginConfig().getDefaultConsumesContentTypes();
            final String[] acceptedContentTypesFinal = acceptedContentTypes;
            if (acceptedContentTypes != null && acceptedContentTypes.length > 0) {
                consumesAnnotation = new Consumes(){

                    public Class<? extends Annotation> annotationType() {
                        return Consumes.class;
                    }

                    public String[] value() {
                        return acceptedContentTypesFinal;
                    }
                };
            }
        }
        if (consumesAnnotation != null) {
            handlerMethodAnnotations.add((Annotation)consumesAnnotation);
        }
    }

    protected void addProducesAnnotationToHandlerMethod(List<Annotation> handlerMethodAnnotations, Specs specs) {
        Produces producesAnnotation = null;
        if (specs != null && specs.produces() != null && specs.produces().value() != null && specs.produces().value().length > 0 && !"".equals(specs.produces().value()[0])) {
            producesAnnotation = specs.produces();
        } else {
            final String[] defaultProducesContentTypes = this.getSpincastOpenApiBottomUpPluginConfig().getDefaultProducesContentTypes();
            if (defaultProducesContentTypes != null && defaultProducesContentTypes.length > 0) {
                producesAnnotation = new Produces(){

                    public Class<? extends Annotation> annotationType() {
                        return Produces.class;
                    }

                    public String[] value() {
                        return defaultProducesContentTypes;
                    }
                };
            }
        }
        if (producesAnnotation != null) {
            handlerMethodAnnotations.add((Annotation)producesAnnotation);
        }
    }

    @Override
    public String getOpenApiAsJson() {
        return this.getOpenApiAsJson(true);
    }

    @Override
    public String getOpenApiAsJson(boolean prettyFormatted) {
        String val;
        String string = val = prettyFormatted ? this.openApiAsJsonPretty : this.openApiAsJson;
        if (val == null) {
            try {
                OpenAPI openAPI = this.getOpenApi();
                if (prettyFormatted) {
                    this.openApiAsJsonPretty = Json.pretty((Object)openAPI);
                } else {
                    this.openApiAsJson = Json.mapper().writeValueAsString((Object)openAPI);
                }
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        return prettyFormatted ? this.openApiAsJsonPretty : this.openApiAsJson;
    }

    @Override
    public String getOpenApiAsYaml() {
        return this.getOpenApiAsYaml(true);
    }

    @Override
    public String getOpenApiAsYaml(boolean prettyFormatted) {
        String val;
        String string = val = prettyFormatted ? this.openApiAsYamlPretty : this.openApiAsYaml;
        if (val == null) {
            try {
                OpenAPI openAPI = this.getOpenApi();
                if (prettyFormatted) {
                    this.openApiAsYamlPretty = Yaml.pretty((Object)openAPI);
                } else {
                    this.openApiAsYaml = Yaml.mapper().writeValueAsString((Object)openAPI);
                }
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        return prettyFormatted ? this.openApiAsYamlPretty : this.openApiAsYaml;
    }

    @Override
    public void ignoreRoutesByIds(String ... ids) {
        if (ids != null) {
            for (String id : ids) {
                this.getRouteIdsToHide().add(id);
            }
        }
    }

    protected String createHttpMethodAndPathKey(HttpMethod method, String path) {
        String key = "";
        if (method != null) {
            key = key + method.name();
        }
        key = key + " - " + path;
        return key;
    }

    @Override
    public void ignoreRouteUsingHttpMethodAndPath(HttpMethod method, String path) {
        String key = this.createHttpMethodAndPathKey(method, path);
        this.getRouteHttpMethodAndPathToHide().add(key);
    }

    protected void addYamlStringSpecifiedPaths(OpenAPI openApi) {
        List mainRoutes = this.getRouter().getMainRoutes();
        if (mainRoutes == null || mainRoutes.size() == 0) {
            return;
        }
        for (Route route : mainRoutes) {
            Paths pathsFromYamlString;
            if (route.isSpecsIgnore() || this.isToHideFromId(route)) {
                logger.info("Route hidden from specs, won't be added:" + route);
                continue;
            }
            Object specs = route.getSpecs();
            if (specs == null || !(specs instanceof String) || (pathsFromYamlString = this.getPathsFromYamlString(route.getPath(), (String)specs)) == null || pathsFromYamlString.size() <= 0) continue;
            Paths paths = openApi.getPaths();
            if (paths == null) {
                paths = new Paths();
                openApi.setPaths(paths);
            }
            for (Map.Entry entry : pathsFromYamlString.entrySet()) {
                String path = (String)entry.getKey();
                PathItem pathItem = (PathItem)entry.getValue();
                if (pathItem == null) continue;
                Map operationsMap = pathItem.readOperationsMap();
                if (operationsMap != null) {
                    for (Map.Entry entry2 : operationsMap.entrySet()) {
                        HttpMethod httpMethod = this.convertHttpMethodToSpincast((PathItem.HttpMethod)entry2.getKey());
                        if (!this.isToHideFromHttpMethodAndPath(route, httpMethod)) continue;
                        logger.info("Route hidden from specs, won't be added: [" + httpMethod.name() + "] " + route);
                        if (httpMethod == HttpMethod.GET) {
                            pathItem.setGet(null);
                            continue;
                        }
                        if (httpMethod == HttpMethod.POST) {
                            pathItem.setPost(null);
                            continue;
                        }
                        if (httpMethod == HttpMethod.PUT) {
                            pathItem.setPut(null);
                            continue;
                        }
                        if (httpMethod == HttpMethod.PATCH) {
                            pathItem.setPatch(null);
                            continue;
                        }
                        if (httpMethod == HttpMethod.DELETE) {
                            pathItem.setDelete(null);
                            continue;
                        }
                        if (httpMethod == HttpMethod.HEAD) {
                            pathItem.setHead(null);
                            continue;
                        }
                        if (httpMethod == HttpMethod.OPTIONS) {
                            pathItem.setOptions(null);
                            continue;
                        }
                        if (httpMethod != HttpMethod.TRACE) continue;
                        pathItem.setTrace(null);
                    }
                }
                paths.addPathItem(path, pathItem);
            }
        }
    }

    protected HttpMethod convertHttpMethodToSpincast(PathItem.HttpMethod httpMethod) {
        if (httpMethod == PathItem.HttpMethod.GET) {
            return HttpMethod.GET;
        }
        if (httpMethod == PathItem.HttpMethod.POST) {
            return HttpMethod.POST;
        }
        if (httpMethod == PathItem.HttpMethod.PUT) {
            return HttpMethod.PUT;
        }
        if (httpMethod == PathItem.HttpMethod.PATCH) {
            return HttpMethod.PATCH;
        }
        if (httpMethod == PathItem.HttpMethod.DELETE) {
            return HttpMethod.DELETE;
        }
        if (httpMethod == PathItem.HttpMethod.HEAD) {
            return HttpMethod.HEAD;
        }
        if (httpMethod == PathItem.HttpMethod.OPTIONS) {
            return HttpMethod.OPTIONS;
        }
        if (httpMethod == PathItem.HttpMethod.TRACE) {
            return HttpMethod.TRACE;
        }
        throw new RuntimeException("HTTP method from Swagger not managed: " + httpMethod);
    }
}

