/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.pebble;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.extension.NodeVisitorFactory;
import com.mitchellbosecke.pebble.extension.Test;
import com.mitchellbosecke.pebble.extension.core.DefaultFilter;
import com.mitchellbosecke.pebble.extension.escaper.SafeString;
import com.mitchellbosecke.pebble.operator.BinaryOperator;
import com.mitchellbosecke.pebble.operator.UnaryOperator;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.mitchellbosecke.pebble.template.ScopeChain;
import com.mitchellbosecke.pebble.tokenParser.TokenParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spincast.core.dictionary.Dictionary;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonObject;
import org.spincast.core.templating.TemplatingEngine;
import org.spincast.core.utils.ObjectConverter;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.pebble.SpincastPebbleExtension;
import org.spincast.plugins.pebble.SpincastPebbleTemplatingEngine;
import org.spincast.plugins.pebble.SpincastPebbleTemplatingEngineConfig;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastPebbleExtensionDefault
implements SpincastPebbleExtension {
    public static final String FILTER_NAME_CHECKED = "checked";
    public static final String FILTER_NAME_SELECTED = "selected";
    public static final String FILTER_NAME_VALIDATION_MESSAGES = "validationMessages";
    public static final String FILTER_NAME_VALIDATION_GROUP_MESSAGES = "validationGroupMessages";
    public static final String FILTER_NAME_VALIDATION_CLASS = "validationClass";
    public static final String FILTER_NAME_VALIDATION_FRESH = "validationFresh";
    public static final String FILTER_NAME_VALIDATION_SUBMITTED = "validationSubmitted";
    public static final String FILTER_NAME_VALIDATION_IS_VALID = "validationIsValid";
    public static final String FILTER_NAME_VALIDATION_HAS_SUCCESSES = "validationHasSuccesses";
    public static final String FILTER_NAME_VALIDATION_HAS_WARNINGS = "validationHasWarnings";
    public static final String FILTER_NAME_VALIDATION_HAS_ERRORS = "validationHasErrors";
    public static final String FILTER_NAME_VALIDATION_GET = "get";
    public static final String FUNCTION_NAME_VALIDATION_GET = "get";
    public static final String FUNCTION_NAME_VALIDATION_JS_ONE_LINE = "jsOneLine";
    public static final String FUNCTION_NAME_MESSAGE = "msg";
    private final Provider<TemplatingEngine> templatingEngineProvider;
    private final SpincastPebbleTemplatingEngineConfig spincastPebbleTemplatingEngineConfig;
    private TemplatingEngine templatingEngine;
    private final ObjectConverter objectConverter;
    private final SpincastUtils spincastUtils;
    private final Dictionary dictionary;

    @Inject
    public SpincastPebbleExtensionDefault(Provider<TemplatingEngine> templatingEngineProvider, SpincastPebbleTemplatingEngineConfig spincastPebbleTemplatingEngineConfig, ObjectConverter objectConverter, SpincastUtils spincastUtils, Dictionary dictionary) {
        this.templatingEngineProvider = templatingEngineProvider;
        this.spincastPebbleTemplatingEngineConfig = spincastPebbleTemplatingEngineConfig;
        this.objectConverter = objectConverter;
        this.spincastUtils = spincastUtils;
        this.dictionary = dictionary;
    }

    public TemplatingEngine getTemplatingEngine() {
        if (this.templatingEngine == null) {
            this.templatingEngine = (TemplatingEngine)this.templatingEngineProvider.get();
        }
        return this.templatingEngine;
    }

    protected ObjectConverter getObjectConverter() {
        return this.objectConverter;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected Dictionary getDictionary() {
        return this.dictionary;
    }

    protected SpincastPebbleTemplatingEngineConfig getSpincastPebbleTemplatingEngineConfig() {
        return this.spincastPebbleTemplatingEngineConfig;
    }

    public Map<String, Test> getTests() {
        return null;
    }

    public List<TokenParser> getTokenParsers() {
        return null;
    }

    public List<BinaryOperator> getBinaryOperators() {
        return null;
    }

    public List<UnaryOperator> getUnaryOperators() {
        return null;
    }

    public Map<String, Object> getGlobalVariables() {
        return null;
    }

    public List<NodeVisitorFactory> getNodeVisitors() {
        return null;
    }

    public Map<String, Filter> getFilters() {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        Filter filter = this.getCheckedFilter();
        if (filter != null) {
            filters.put(this.getCheckedFilterName(), filter);
        }
        if ((filter = this.getSelectedFilter()) != null) {
            filters.put(this.getSelectedFilterName(), filter);
        }
        if ((filter = this.getValidationMessagesFilter(this.getValidationMessagesTemplatePath())) != null) {
            filters.put(this.getValidationMessagesFilterName(), filter);
        }
        if ((filter = this.getValidationMessagesFilter(this.getValidationGroupMessagesTemplatePath())) != null) {
            filters.put(this.getValidationGroupMessagesFilterName(), filter);
        }
        if ((filter = this.getValidationClassFilter()) != null) {
            filters.put(this.getValidationClassFilterName(), filter);
        }
        if ((filter = this.getValidationFreshFilter()) != null) {
            filters.put(this.getValidationFreshFilterName(), filter);
        }
        if ((filter = this.getValidationSubmittedFilter()) != null) {
            filters.put(this.getValidationSubmittedFilterName(), filter);
        }
        if ((filter = this.getValidationIsValidFilter()) != null) {
            filters.put(this.getValidationIsValidFilterName(), filter);
        }
        if ((filter = this.getValidationHasSuccessesFilter()) != null) {
            filters.put(this.getValidationHasSuccessesFilterName(), filter);
        }
        if ((filter = this.getValidationHasWarningsFilter()) != null) {
            filters.put(this.getValidationHasWarningsFilterName(), filter);
        }
        if ((filter = this.getValidationHasErrorsFilter()) != null) {
            filters.put(this.getValidationHasErrorsFilterName(), filter);
        }
        if ((filter = this.getGetFilter()) != null) {
            filters.put(this.getGetFilterName(), filter);
        }
        return filters;
    }

    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put(this.getGetFunctionName(), this.getGetFunction());
        functions.put(this.getJsOneLinerOutputFunctionName(), this.getJsOneLinerOutputFunction());
        functions.put(this.getMessageFunctionName(), this.getMessageFunction());
        return functions;
    }

    protected EvaluationContext getEvaluationContext(Map<String, Object> args) {
        return (EvaluationContext)args.get("_context");
    }

    protected PebbleTemplate getPebbleTemplate(Map<String, Object> args) {
        return (PebbleTemplate)args.get("_self");
    }

    protected ScopeChain getScopeChain(Map<String, Object> args) {
        return this.getEvaluationContext(args).getScopeChain();
    }

    protected Object getModelElement(Map<String, Object> args, String property) {
        return this.getScopeChain(args).get(property);
    }

    protected String getPropertyAsString(Map<String, Object> args, String property) {
        return (String)this.getModelElement(args, property);
    }

    protected Map<String, Object> getPropertyAsMap(Map<String, Object> args, String property) {
        return (Map)this.getModelElement(args, property);
    }

    protected Set<Object> convertToSet(Object obj) {
        HashSet<Object> values = new HashSet<Object>();
        if (obj instanceof Collection) {
            values.addAll((Collection)obj);
        } else if (obj instanceof Object[]) {
            Object[] arr = (Object[])obj;
            for (int i = 0; i < arr.length; ++i) {
                values.add(arr[i]);
            }
        } else {
            values.add(obj);
        }
        return values;
    }

    protected String getValidationClassError() {
        return "has-error";
    }

    protected Object getValidationClassWarning() {
        return "has-warning";
    }

    protected Object getValidationClassSuccess() {
        return "has-success";
    }

    protected Object getValidationClassNoMessage() {
        return "has-no-message";
    }

    protected String getValidationMessagesTemplatePath() {
        return this.getSpincastPebbleTemplatingEngineConfig().getValidationMessagesTemplatePath();
    }

    protected String getValidationGroupMessagesTemplatePath() {
        return this.getSpincastPebbleTemplatingEngineConfig().getValidationGroupMessagesTemplatePath();
    }

    protected String getCheckedFilterName() {
        return FILTER_NAME_CHECKED;
    }

    protected Filter getCheckedFilter() {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return Lists.newArrayList((Object[])new String[]{"acceptableValues"});
            }

            public Object apply(Object value, Map<String, Object> args) {
                Set<Object> values = SpincastPebbleExtensionDefault.this.convertToSet(value);
                Set<Object> acceptableValues = SpincastPebbleExtensionDefault.this.convertToSet(args.get("acceptableValues"));
                if (SpincastPebbleExtensionDefault.this.getObjectConverter().isAtLeastOneEquivalentElementInCommon(values, acceptableValues)) {
                    return SpincastPebbleExtensionDefault.FILTER_NAME_CHECKED;
                }
                return "";
            }
        };
        return filter;
    }

    protected String getSelectedFilterName() {
        return FILTER_NAME_SELECTED;
    }

    protected Filter getSelectedFilter() {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return Lists.newArrayList((Object[])new String[]{"acceptableValues"});
            }

            public Object apply(Object value, Map<String, Object> args) {
                Set<Object> values = SpincastPebbleExtensionDefault.this.convertToSet(value);
                Set<Object> acceptableValues = SpincastPebbleExtensionDefault.this.convertToSet(args.get("acceptableValues"));
                if (SpincastPebbleExtensionDefault.this.getObjectConverter().isAtLeastOneEquivalentElementInCommon(values, acceptableValues)) {
                    return SpincastPebbleExtensionDefault.FILTER_NAME_SELECTED;
                }
                return "";
            }
        };
        return filter;
    }

    protected String getValidationMessagesFilterName() {
        return FILTER_NAME_VALIDATION_MESSAGES;
    }

    protected String getValidationGroupMessagesFilterName() {
        return FILTER_NAME_VALIDATION_GROUP_MESSAGES;
    }

    protected Filter getValidationMessagesFilter(final String templatePath) {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return "";
                }
                Map validationResultMap = (Map)value;
                String html = SpincastPebbleExtensionDefault.this.getTemplatingEngine().fromTemplate(templatePath, SpincastStatics.params((String)"validation", (Object)validationResultMap));
                return new SafeString(html);
            }
        };
        return filter;
    }

    protected String getValidationClassFilterName() {
        return FILTER_NAME_VALIDATION_CLASS;
    }

    protected Filter getValidationClassFilter() {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return SpincastPebbleExtensionDefault.this.getValidationClassNoMessage();
                }
                Map validationResultMap = (Map)value;
                Boolean hasErrors = (Boolean)validationResultMap.get("hasErrors");
                if (hasErrors == null || hasErrors.booleanValue()) {
                    return SpincastPebbleExtensionDefault.this.getValidationClassError();
                }
                Boolean hasWarnings = (Boolean)validationResultMap.get("hasWarnings");
                if (hasWarnings != null && hasWarnings.booleanValue()) {
                    return SpincastPebbleExtensionDefault.this.getValidationClassWarning();
                }
                Boolean hasSuccesses = (Boolean)validationResultMap.get("hasSuccesses");
                if (hasSuccesses != null && hasSuccesses.booleanValue()) {
                    return SpincastPebbleExtensionDefault.this.getValidationClassSuccess();
                }
                return SpincastPebbleExtensionDefault.this.getValidationClassNoMessage();
            }
        };
        return filter;
    }

    protected String getValidationFreshFilterName() {
        return FILTER_NAME_VALIDATION_FRESH;
    }

    protected Filter getValidationFreshFilter() {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object apply(Object value, Map<String, Object> args) {
                if (value == null) {
                    return true;
                }
                return false;
            }
        };
        return filter;
    }

    protected String getValidationSubmittedFilterName() {
        return FILTER_NAME_VALIDATION_SUBMITTED;
    }

    protected Filter getValidationSubmittedFilter() {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object apply(Object value, Map<String, Object> args) {
                if (value == null) {
                    return false;
                }
                return true;
            }
        };
        return filter;
    }

    protected String getValidationIsValidFilterName() {
        return FILTER_NAME_VALIDATION_IS_VALID;
    }

    protected Filter getValidationIsValidFilter() {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return true;
                }
                Map validationResultMap = (Map)value;
                Object isValid = validationResultMap.get("isValid");
                return isValid != null && isValid instanceof Boolean && (Boolean)isValid != false;
            }
        };
        return filter;
    }

    protected String getValidationHasSuccessesFilterName() {
        return FILTER_NAME_VALIDATION_HAS_SUCCESSES;
    }

    protected Filter getValidationHasSuccessesFilter() {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return false;
                }
                Map validationResultMap = (Map)value;
                Object hasSuccesses = validationResultMap.get("hasSuccesses");
                return hasSuccesses != null && hasSuccesses instanceof Boolean && (Boolean)hasSuccesses != false;
            }
        };
        return filter;
    }

    protected String getValidationHasWarningsFilterName() {
        return FILTER_NAME_VALIDATION_HAS_WARNINGS;
    }

    protected Filter getValidationHasWarningsFilter() {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return false;
                }
                Map validationResultMap = (Map)value;
                Object hasWarnings = validationResultMap.get("hasWarnings");
                return hasWarnings != null && hasWarnings instanceof Boolean && (Boolean)hasWarnings != false;
            }
        };
        return filter;
    }

    protected String getValidationHasErrorsFilterName() {
        return FILTER_NAME_VALIDATION_HAS_ERRORS;
    }

    protected Filter getValidationHasErrorsFilter() {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return false;
                }
                Map validationResultMap = (Map)value;
                Object hasErrors = validationResultMap.get("hasErrors");
                return hasErrors != null && hasErrors instanceof Boolean && (Boolean)hasErrors != false;
            }
        };
        return filter;
    }

    protected String getGetFilterName() {
        return "get";
    }

    protected Filter getGetFilter() {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof String)) {
                    return null;
                }
                String key = (String)value;
                Map spincastMap = (Map)SpincastPebbleExtensionDefault.this.getModelElement(args, "spincast");
                if (spincastMap == null) {
                    return null;
                }
                JsonObject paramsAsJsonObject = (JsonObject)spincastMap.get(SpincastPebbleTemplatingEngine.PEBBLE_PARAMS_AS_JSONOBJECT);
                if (paramsAsJsonObject == null) {
                    return null;
                }
                Object result = paramsAsJsonObject.getObject(key, (Object)"");
                if (result instanceof JsonObject) {
                    return ((JsonObject)result).convertToPlainMap();
                }
                if (result instanceof JsonArray) {
                    return ((JsonArray)result).convertToPlainList();
                }
                return result;
            }
        };
        return filter;
    }

    protected String getGetFunctionName() {
        return "get";
    }

    protected Function getGetFunction() {
        return new Function(){

            public List<String> getArgumentNames() {
                ArrayList<String> names = new ArrayList<String>();
                names.add("jsonPath");
                return names;
            }

            public Object execute(Map<String, Object> args) {
                String key = (String)args.get("jsonPath");
                if (StringUtils.isBlank((CharSequence)key)) {
                    return null;
                }
                Map spincastMap = (Map)SpincastPebbleExtensionDefault.this.getModelElement(args, "spincast");
                if (spincastMap == null) {
                    return null;
                }
                JsonObject paramsAsJsonObject = (JsonObject)spincastMap.get(SpincastPebbleTemplatingEngine.PEBBLE_PARAMS_AS_JSONOBJECT);
                if (paramsAsJsonObject == null) {
                    return null;
                }
                Object result = paramsAsJsonObject.getObject(key, (Object)"");
                if (result instanceof JsonObject) {
                    return ((JsonObject)result).convertToPlainMap();
                }
                if (result instanceof JsonArray) {
                    return ((JsonArray)result).convertToPlainList();
                }
                return result;
            }
        };
    }

    protected String getJsOneLinerOutputFunctionName() {
        return FUNCTION_NAME_VALIDATION_JS_ONE_LINE;
    }

    protected Function getJsOneLinerOutputFunction() {
        return new Function(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object execute(Map<String, Object> args) {
                Object codeObj = args.get("0");
                if (codeObj == null) {
                    return "";
                }
                String code = codeObj.toString();
                if (StringUtils.isBlank((CharSequence)code)) {
                    return "";
                }
                Boolean singleQuotesDelimiter = (Boolean)args.get("1");
                if (singleQuotesDelimiter == null) {
                    singleQuotesDelimiter = false;
                }
                String codeFormatted = SpincastPebbleExtensionDefault.this.getSpincastUtils().inQuotesStringFormat(code, singleQuotesDelimiter.booleanValue());
                return new SafeString(codeFormatted);
            }
        };
    }

    protected String getMessageFunctionName() {
        return FUNCTION_NAME_MESSAGE;
    }

    protected Function getMessageFunction() {
        return new Function(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object execute(Map<String, Object> args) {
                if (args == null || args.size() == 0) {
                    return "";
                }
                Object firstArg = args.get("1");
                boolean forceEvaluation = false;
                if (firstArg != null && firstArg instanceof Boolean) {
                    forceEvaluation = (Boolean)firstArg;
                    args.remove("1");
                }
                HashMap<String, String> params = new HashMap<String, String>();
                String msgKey = null;
                String paramKey = null;
                for (Map.Entry<String, Object> entry : args.entrySet()) {
                    String key = entry.getKey();
                    String val = String.valueOf(entry.getValue());
                    if (!key.matches("^\\d+$")) continue;
                    if (msgKey == null) {
                        msgKey = val;
                        continue;
                    }
                    if (paramKey == null) {
                        paramKey = val;
                        continue;
                    }
                    params.put(paramKey, val);
                    paramKey = null;
                }
                if (paramKey != null) {
                    throw new RuntimeException("A value is missing for one of the key of the custom 'msg' Pebble function... The key without value is : \"" + paramKey + "\"");
                }
                if (params.size() == 0 && !forceEvaluation) {
                    params = null;
                }
                return SpincastPebbleExtensionDefault.this.getDictionary().get(msgKey, params);
            }
        };
    }
}

