/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.processutils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.processutils.JarExecutionHandler;
import org.spincast.plugins.processutils.exceptions.PortNotOpenException;

public class JarExecutionHandlerDefault
implements JarExecutionHandler {
    protected static final Logger logger = LoggerFactory.getLogger(JarExecutionHandlerDefault.class);
    private Process jarProcess;
    private boolean killingRequested = false;

    @Override
    public Process getJarProcess() {
        return this.jarProcess;
    }

    @Override
    public void setJarProcess(Process jarProcess) {
        this.jarProcess = jarProcess;
    }

    protected boolean isKillingRequested() {
        return this.killingRequested;
    }

    public void setKillingRequested() {
        this.killingRequested = true;
    }

    public void waitForPortOpen(String host, int port, int nbrTry, int sleepMilliseconds) {
        try {
            boolean portReached = false;
            int loopNbr = 1;
            while (loopNbr++ <= nbrTry) {
                if (!this.getJarProcess().isAlive()) {
                    this.onException(new RuntimeException("Jar process not alive!"));
                }
                try {
                    logger.info("Try to connect to connect to " + host + ":" + port + "...");
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(host, port));
                    portReached = true;
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                    break;
                }
                catch (IOException e) {
                    Thread.sleep(sleepMilliseconds);
                }
            }
            if (!portReached) {
                this.onException(new PortNotOpenException("Unable to connect to " + host + ":" + port + ", even after " + sleepMilliseconds + " milliseconds."));
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public void killJarProcess() {
        this.setKillingRequested();
        if (!this.getJarProcess().isAlive()) {
            return;
        }
        try {
            logger.info("Killing jar process...");
            this.getJarProcess().destroy();
            int secondNbr = 0;
            while (secondNbr++ < 10 && this.getJarProcess().isAlive()) {
                Thread.sleep(1000L);
            }
            if (this.getJarProcess().isAlive()) {
                this.getJarProcess().destroyForcibly();
            }
            logger.info("Jar process killed.");
        }
        catch (Exception ex) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.getJarProcess().isAlive()) {
                return;
            }
            throw new RuntimeException("Unable to kill the jar process properly", ex);
        }
    }

    @Override
    public void onExit(int exitVal) {
        if (this.isKillingRequested()) {
            logger.info("Jar thread killed (exited with code " + exitVal + ").");
        } else if (exitVal != 0) {
            logger.error("Jar thread exited with code " + exitVal + ".");
        } else {
            logger.info("Jar thread exited succesfully");
        }
    }

    @Override
    public void onException(Exception ex) {
        try {
            this.killJarProcess();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        throw new RuntimeException("Exception in the jar execution thread", ex);
    }
}

