/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.processutils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.processutils.HttpServerProcessHandlerExecutionHandler;
import org.spincast.plugins.processutils.ProcessKiller;
import org.spincast.plugins.processutils.exceptions.PortNotOpenException;

public class ProcessExecutionHandlerDefault
implements HttpServerProcessHandlerExecutionHandler {
    protected static final Logger logger = LoggerFactory.getLogger(ProcessExecutionHandlerDefault.class);
    private Process process;
    private boolean killingRequested = false;
    private ProcessKiller processKiller = null;

    protected Process getProcess() {
        return this.process;
    }

    protected ProcessKiller getProcessKiller() {
        return this.processKiller;
    }

    @Override
    public boolean isProcessAlive() {
        return this.getProcess() != null && this.getProcess().isAlive();
    }

    @Override
    public void setProcessAndProcessKiller(Process process, ProcessKiller processKiller) {
        this.process = process;
        this.processKiller = processKiller;
    }

    protected boolean isKillingRequested() {
        return this.killingRequested;
    }

    public void setKillingRequested() {
        this.killingRequested = true;
    }

    @Override
    public void waitForPortOpen(String host, int port, int nbrTry, int sleepMilliseconds) throws PortNotOpenException {
        boolean portConnectable = false;
        try {
            int loopNbr = 1;
            while (loopNbr++ <= nbrTry) {
                if (this.isKillingRequested()) {
                    return;
                }
                if (this.getProcess() == null) {
                    Thread.sleep(sleepMilliseconds);
                    continue;
                }
                if (!this.getProcess().isAlive()) {
                    logger.warn("Process not alive anymore!");
                    return;
                }
                try {
                    logger.info("Try to connect to connect to " + host + ":" + port + "...");
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(host, port));
                    portConnectable = true;
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                    break;
                }
                catch (IOException e) {
                    Thread.sleep(sleepMilliseconds);
                }
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        if (!portConnectable) {
            throw new PortNotOpenException("Unable to connect to " + host + ":" + port + ".");
        }
    }

    @Override
    public void killProcess() {
        this.setKillingRequested();
        if (this.getProcessKiller() != null) {
            this.getProcessKiller().killProcess();
        }
    }

    @Override
    public void onExit(int exitCode) {
        String msg = "Executed program exited with code " + exitCode + ".";
        if (exitCode == 0) {
            logger.info(msg);
        } else {
            logger.error(msg);
        }
    }

    @Override
    public void onLaunchException(Exception ex) {
        logger.error("Exception launching the program:\n" + SpincastStatics.getStackTrace((Throwable)ex));
    }

    @Override
    public void onEnd() {
        if (this.isKillingRequested()) {
            logger.info("Executed program killed!");
        }
    }

    @Override
    public void onTimeoutException() {
        logger.error("Timeout exceeded running the program");
    }

    @Override
    public void onSystemOut(String line) {
        System.out.println(line);
    }

    @Override
    public void onSystemErr(String line) {
        System.err.println(line);
    }
}

