/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.processutils;

import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.templating.TemplatingEngine;
import org.spincast.core.utils.ResourceInfo;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.processutils.ExecutionOutputStrategy;
import org.spincast.plugins.processutils.MavenProjectGoal;
import org.spincast.plugins.processutils.ProcessExecutionHandler;
import org.spincast.plugins.processutils.ProcessExecutionHandlerDefault;
import org.spincast.plugins.processutils.ProcessExecutionHandlerSync;
import org.spincast.plugins.processutils.ProcessKiller;
import org.spincast.plugins.processutils.SpincastProcessUtils;
import org.spincast.plugins.processutils.SyncExecutionResult;
import org.spincast.plugins.processutils.exceptions.LaunchException;
import org.spincast.plugins.processutils.exceptions.TimeoutException;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastProcessUtilsDefault
implements SpincastProcessUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastProcessUtilsDefault.class);
    private final SpincastConfig spincastConfig;
    private final SpincastUtils spincastUtils;
    private final TemplatingEngine templatingEngine;

    @Inject
    public SpincastProcessUtilsDefault(SpincastConfig spincastConfig, SpincastUtils spincastUtils, TemplatingEngine templatingEngine) {
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
        this.templatingEngine = templatingEngine;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected TemplatingEngine getTemplatingEngine() {
        return this.templatingEngine;
    }

    @Override
    public File executeGoalOnExternalMavenProject(ResourceInfo projectRootInfo, MavenProjectGoal mavenGoal) {
        return this.executeGoalOnExternalMavenProject(projectRootInfo, mavenGoal, null);
    }

    @Override
    public File executeGoalOnExternalMavenProject(ResourceInfo projectRootInfo, MavenProjectGoal mavenGoal, Map<String, Object> pomParams) {
        try {
            File projectTargetDir = null;
            if (!projectRootInfo.isClasspathResource()) {
                projectTargetDir = new File(projectRootInfo.getPath());
            } else {
                projectTargetDir = new File(this.getSpincastConfig().getTempDir(), UUID.randomUUID().toString());
                this.getSpincastUtils().copyClasspathDirToFileSystem(projectRootInfo.getPath(), projectTargetDir);
            }
            File pomFile = new File(projectTargetDir, "pom.xml");
            if (!pomFile.isFile()) {
                throw new RuntimeException("The project's pom.xml was not found: " + pomFile.getAbsolutePath());
            }
            if (pomParams != null && pomParams.size() > 0) {
                String pomContent = FileUtils.readFileToString((File)pomFile, (String)"UTF-8");
                pomContent = this.getTemplatingEngine().evaluate(pomContent, pomParams);
                FileUtils.write((File)pomFile, (CharSequence)pomContent, (String)"UTF-8");
            }
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(pomFile);
            request.setGoals(Collections.singletonList(mavenGoal.getValue()));
            DefaultInvoker invoker = new DefaultInvoker();
            invoker.execute((InvocationRequest)request);
            return projectTargetDir;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public void executeAsync(ProcessExecutionHandler handler, String ... cmdArgs) {
        this.executeAsync(handler, -1L, null, cmdArgs != null ? Arrays.asList(cmdArgs) : null);
    }

    @Override
    public void executeAsync(ProcessExecutionHandler handler, long timeoutAmount, TimeUnit timeoutUnit, String ... cmdArgs) {
        this.executeAsync(handler, timeoutAmount, timeoutUnit, cmdArgs != null ? Arrays.asList(cmdArgs) : null);
    }

    @Override
    public void executeAsync(ProcessExecutionHandler handler, List<String> cmdArgs) {
        this.executeAsync(handler, -1L, null, cmdArgs);
    }

    @Override
    public void executeAsync(final ProcessExecutionHandler handler, final long timeoutAmount, final TimeUnit timeoutUnit, final List<String> cmdArgs) {
        if (cmdArgs == null || cmdArgs.size() == 0) {
            throw new RuntimeException("There must be at least one command argument!");
        }
        if (handler == null) {
            throw new RuntimeException("The handler can't be null");
        }
        final boolean[] processCreated = new boolean[]{false};
        final boolean[] processEnded = new boolean[]{false};
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final CountDownLatch onEndLatch = new CountDownLatch(1);
                try {
                    ProcessBuilder pb = new ProcessBuilder(cmdArgs);
                    pb = SpincastProcessUtilsDefault.this.configureStreams(pb);
                    String cmd = StringUtils.join((Iterable)cmdArgs, (String)" ");
                    if (timeoutAmount >= 0L) {
                        String timeoutUnitFriendly = timeoutUnit.name().toLowerCase();
                        if (timeoutAmount == 1L) {
                            timeoutUnitFriendly = StringUtils.removeEnd((String)timeoutUnitFriendly, (String)"s");
                        }
                        logger.info("Executing command (timeout: " + timeoutAmount + " " + timeoutUnitFriendly + ") : " + cmd);
                    } else {
                        logger.info("Executing command (no timeout) : " + cmd);
                    }
                    final Process process = pb.start();
                    try {
                        AtomicBoolean processKillerCalled;
                        block27: {
                            processCreated[0] = true;
                            SpincastProcessUtilsDefault.this.startSystemOutReader(process, handler);
                            SpincastProcessUtilsDefault.this.startSystemErrReader(process, handler);
                            processKillerCalled = new AtomicBoolean(false);
                            ProcessKiller processKiller = new ProcessKiller(){

                                @Override
                                public void killProcess() {
                                    if (processKillerCalled.get()) {
                                        return;
                                    }
                                    processKillerCalled.set(true);
                                    SpincastProcessUtilsDefault.this.killProcess(process);
                                    try {
                                        onEndLatch.await();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            handler.setProcessAndProcessKiller(process, processKiller);
                            if (timeoutAmount >= 0L) {
                                try {
                                    boolean exitedProperly = process.waitFor(timeoutAmount, timeoutUnit);
                                    if (!exitedProperly && !processKillerCalled.get()) {
                                        handler.onTimeoutException();
                                        return;
                                    }
                                    break block27;
                                }
                                catch (Exception ex) {
                                    throw SpincastStatics.runtimize((Exception)ex);
                                }
                            }
                            process.waitFor();
                        }
                        if (!processKillerCalled.get()) {
                            int exitVal = process.exitValue();
                            handler.onExit(exitVal);
                        }
                    }
                    finally {
                        SpincastProcessUtilsDefault.this.killProcess(process);
                    }
                }
                catch (Exception ex) {
                    handler.onLaunchException(ex);
                }
                finally {
                    try {
                        handler.onEnd();
                    }
                    finally {
                        processEnded[0] = true;
                        onEndLatch.countDown();
                    }
                }
            }
        });
        thread.start();
        while (!processCreated[0] && !processEnded[0]) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void killProcess(Process process) {
        if (process == null || !process.isAlive()) {
            return;
        }
        try {
            logger.info("Killing the process...");
            process.destroy();
            int secondNbr = 0;
            while (secondNbr++ < 10 && process.isAlive()) {
                Thread.sleep(1000L);
            }
            if (process.isAlive()) {
                process.destroyForcibly();
            }
            logger.info("Process killed.");
        }
        catch (Exception ex) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!process.isAlive()) {
                return;
            }
            throw new RuntimeException("Unable to kill the process properly", ex);
        }
    }

    protected ProcessBuilder configureStreams(ProcessBuilder pb) {
        pb = pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        pb = pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        pb = pb.redirectError(ProcessBuilder.Redirect.PIPE);
        return pb;
    }

    protected void startSystemOutReader(Process process, final ProcessExecutionHandler handler) {
        final InputStream inputStream = process.getInputStream();
        if (inputStream != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(inputStream)));
                    try {
                        while (sc.hasNextLine()) {
                            handler.onSystemOut(sc.nextLine());
                        }
                    }
                    finally {
                        SpincastStatics.closeQuietly((Closeable)sc);
                    }
                }
            }).start();
        }
    }

    protected void startSystemErrReader(Process process, final ProcessExecutionHandler handler) {
        final InputStream inputStream = process.getErrorStream();
        if (inputStream != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(inputStream)));
                    try {
                        while (sc.hasNextLine()) {
                            handler.onSystemErr(sc.nextLine());
                        }
                    }
                    finally {
                        SpincastStatics.closeQuietly((Closeable)sc);
                    }
                }
            }).start();
        }
    }

    protected void waitForStreamsToBeEmpty(Thread systemOutReaderThread, Thread systemErrReaderThread) {
        try {
            if (systemOutReaderThread != null) {
                systemOutReaderThread.join();
            }
            if (systemErrReaderThread != null) {
                systemErrReaderThread.join();
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public SyncExecutionResult executeSync(long timeoutAmount, TimeUnit timeoutUnit, String ... cmdArgs) throws LaunchException, TimeoutException {
        return this.executeSync(timeoutAmount, timeoutUnit, cmdArgs != null ? Arrays.asList(cmdArgs) : null);
    }

    @Override
    public SyncExecutionResult executeSync(long timeoutAmount, TimeUnit timeoutUnit, List<String> cmdArgs) throws LaunchException, TimeoutException {
        return this.executeSync(timeoutAmount, timeoutUnit, ExecutionOutputStrategy.SYSTEM, cmdArgs);
    }

    @Override
    public SyncExecutionResult executeSync(long timeoutAmount, TimeUnit timeoutUnit, ExecutionOutputStrategy executionOutputStrategy, String ... cmdArgs) throws LaunchException, TimeoutException {
        return this.executeSync(timeoutAmount, timeoutUnit, executionOutputStrategy, cmdArgs != null ? Arrays.asList(cmdArgs) : null);
    }

    @Override
    public SyncExecutionResult executeSync(long timeoutAmount, TimeUnit timeoutUnit, ExecutionOutputStrategy executionOutputStrategy, List<String> cmdArgs) throws LaunchException, TimeoutException {
        if (timeoutAmount <= 0L) {
            throw new RuntimeException("The timeoutAmount must be greater than 0.");
        }
        Objects.requireNonNull(timeoutUnit, "The timeoutUnit can't be NULL");
        ProcessExecutionHandlerDefault handler = null;
        try {
            CountDownLatch latch = new CountDownLatch(1);
            handler = new ProcessExecutionHandlerSync(latch, executionOutputStrategy);
            this.executeAsync((ProcessExecutionHandler)handler, timeoutAmount, timeoutUnit, cmdArgs);
            latch.await();
            SyncExecutionResult syncExecutionResult = ((ProcessExecutionHandlerSync)handler).getSyncExecutionResult();
            if (((ProcessExecutionHandlerSync)handler).getLaunchException() != null) {
                throw new LaunchException(((ProcessExecutionHandlerSync)handler).getLaunchException());
            }
            if (((ProcessExecutionHandlerSync)handler).isTimeoutException()) {
                throw new TimeoutException(syncExecutionResult);
            }
            SyncExecutionResult syncExecutionResult2 = syncExecutionResult;
            return syncExecutionResult2;
        }
        catch (LaunchException | TimeoutException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        finally {
            if (handler != null) {
                handler.killProcess();
            }
        }
    }
}

