/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.request;

import com.google.inject.Inject;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.dictionary.Dictionary;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.exchange.RequestRequestContextAddon;
import org.spincast.core.flash.FlashMessage;
import org.spincast.core.flash.FlashMessagesHolder;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.request.Form;
import org.spincast.core.request.FormFactory;
import org.spincast.core.routing.ETag;
import org.spincast.core.routing.ETagFactory;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.server.Server;
import org.spincast.core.server.UploadedFile;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.core.xml.XmlManager;
import org.spincast.plugins.request.SpincastRequestPluginDictionaryEntries;
import org.spincast.shaded.org.apache.commons.io.IOUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.http.client.utils.DateUtils;

public class SpincastRequestRequestContextAddon<R extends RequestContext<?>>
implements RequestRequestContextAddon<R> {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastRequestRequestContextAddon.class);
    private String fullUrlOriginalWithCacheBustersNonDecoded = null;
    private String fullUrlOriginalNoCacheBustersNonDecoded = null;
    private String fullUrlProxiedWithCacheBustersNonDecoded = null;
    private String fullUrlProxiedNoCacheBustersNonDecoded = null;
    private String fullUrlWithCacheBustersNonDecoded = null;
    private String fullUrlWithCacheBustersDecoded = null;
    private String fullUrlNoCacheBustersDecoded = null;
    private String requestPathNoCacheBusters = null;
    private String requestPathWithCacheBusters = null;
    private String queryStringNonDecoded = "";
    private String queryStringDecoded = "";
    private List<ETag> ifMatchETags = null;
    private Object ifMatchETagsLock = new Object();
    private List<ETag> ifNoneMatchETags = null;
    private Object ifNoneMatchETagsLock = new Object();
    private Date ifModifiedSinceDate = null;
    private Object ifModifiedSinceDateLock = new Object();
    private Date ifUnmodifiedSinceDate = null;
    private Object ifUnmodifiedSinceDateLock = new Object();
    private Map<String, List<String>> queryStringParams;
    private Map<String, List<String>> formDatasAsImmutableMap;
    private JsonObject formDatasAsImmutableJsonObject;
    private Map<String, List<UploadedFile>> uploadedFiles;
    private Map<String, List<String>> headers;
    private Map<String, Form> scopedForms;
    private final R requestContext;
    private final Server server;
    private final JsonManager jsonManager;
    private final XmlManager xmlManager;
    private final SpincastUtils spincastUtils;
    private final SpincastConfig spincastConfig;
    private final ETagFactory etagFactory;
    private final FlashMessagesHolder flashMessagesHolder;
    private final Dictionary dictionary;
    private final FormFactory formFactory;
    private boolean flashMessageRetrieved = false;
    private FlashMessage flashMessage;
    private Pattern formDataArrayPattern;
    private Map<String, String> cookies;

    @Inject
    public SpincastRequestRequestContextAddon(R requestContext, Server server, JsonManager jsonManager, XmlManager xmlManager, SpincastUtils spincastUtils, SpincastConfig spincastConfig, ETagFactory etagFactory, FlashMessagesHolder flashMessagesHolder, FormFactory formFactory, Dictionary dictionary) {
        this.requestContext = requestContext;
        this.server = server;
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
        this.spincastUtils = spincastUtils;
        this.spincastConfig = spincastConfig;
        this.etagFactory = etagFactory;
        this.flashMessagesHolder = flashMessagesHolder;
        this.formFactory = formFactory;
        this.dictionary = dictionary;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected Server getServer() {
        return this.server;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected XmlManager getXmlManager() {
        return this.xmlManager;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected ETagFactory getEtagFactory() {
        return this.etagFactory;
    }

    protected FlashMessagesHolder getFlashMessagesHolder() {
        return this.flashMessagesHolder;
    }

    protected FormFactory getFormFactory() {
        return this.formFactory;
    }

    protected Dictionary getDictionary() {
        return this.dictionary;
    }

    protected Object getExchange() {
        return this.getRequestContext().exchange();
    }

    public HttpMethod getHttpMethod() {
        return this.getServer().getHttpMethod(this.getExchange());
    }

    public ContentTypeDefaults getContentTypeBestMatch() {
        return this.getServer().getContentTypeBestMatch(this.getExchange());
    }

    public boolean isJsonShouldBeReturn() {
        return ContentTypeDefaults.JSON == this.getContentTypeBestMatch();
    }

    public boolean isHTMLShouldBeReturn() {
        return ContentTypeDefaults.HTML == this.getContentTypeBestMatch();
    }

    public boolean isXMLShouldBeReturn() {
        return ContentTypeDefaults.XML == this.getContentTypeBestMatch();
    }

    public boolean isPlainTextShouldBeReturn() {
        return ContentTypeDefaults.TEXT == this.getContentTypeBestMatch();
    }

    protected Pattern getFormDataArrayPattern() {
        if (this.formDataArrayPattern == null) {
            this.formDataArrayPattern = Pattern.compile(".*(\\[(0|[1-9]+[0-9]?)\\])$");
        }
        return this.formDataArrayPattern;
    }

    public String getCookieValue(String name) {
        return this.getCookiesValues().get(name);
    }

    public Map<String, String> getCookiesValues() {
        if (this.cookies == null) {
            this.cookies = this.getServer().getCookies(this.getRequestContext().exchange());
        }
        return this.cookies;
    }

    public boolean isCookiesEnabledValidated() {
        return this.getCookiesValues().size() > 0;
    }

    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            Map headersServer = this.getServer().getRequestHeaders(this.getExchange());
            Map<String, List<String>> headersFinal = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            if (headersServer == null) {
                headersServer = Collections.emptyMap();
            } else {
                for (Map.Entry entry : headersServer.entrySet()) {
                    if (entry.getValue() == null) {
                        headersFinal.put((String)entry.getKey(), Collections.emptyList());
                        continue;
                    }
                    headersFinal.put((String)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
                }
                headersFinal = Collections.unmodifiableMap(headersFinal);
            }
            this.headers = headersFinal;
        }
        return this.headers;
    }

    public List<String> getHeader(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return new LinkedList<String>();
        }
        List<String> values = this.getHeaders().get(name);
        if (values == null) {
            values = new LinkedList<String>();
        }
        return values;
    }

    public String getHeaderFirst(String name) {
        List<String> values = this.getHeader(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    protected String getFullUrlOriginalNoCacheBustersNonDecoded() {
        if (this.fullUrlOriginalNoCacheBustersNonDecoded == null) {
            this.fullUrlOriginalNoCacheBustersNonDecoded = this.getServer().getFullUrlOriginal(this.getExchange(), false);
        }
        return this.fullUrlOriginalNoCacheBustersNonDecoded;
    }

    protected String getFullUrlOriginalWithCacheBustersNonDecoded() {
        if (this.fullUrlOriginalWithCacheBustersNonDecoded == null) {
            this.fullUrlOriginalWithCacheBustersNonDecoded = this.getServer().getFullUrlOriginal(this.getExchange(), true);
        }
        return this.fullUrlOriginalWithCacheBustersNonDecoded;
    }

    protected String getFullUrlProxiedNoCacheBustersNonDecoded() {
        if (this.fullUrlProxiedNoCacheBustersNonDecoded == null) {
            this.fullUrlProxiedNoCacheBustersNonDecoded = this.getServer().getFullUrlProxied(this.getExchange(), false);
        }
        return this.fullUrlProxiedNoCacheBustersNonDecoded;
    }

    protected String getFullUrlProxiedWithCacheBustersNonDecoded() {
        if (this.fullUrlProxiedWithCacheBustersNonDecoded == null) {
            this.fullUrlProxiedWithCacheBustersNonDecoded = this.getServer().getFullUrlProxied(this.getExchange(), true);
        }
        return this.fullUrlProxiedWithCacheBustersNonDecoded;
    }

    public String getFullUrlOriginal() {
        return this.getFullUrlOriginal(false);
    }

    public String getFullUrlOriginal(boolean keepCacheBusters) {
        if (keepCacheBusters) {
            return this.getFullUrlOriginalWithCacheBustersNonDecoded();
        }
        return this.getFullUrlOriginalNoCacheBustersNonDecoded();
    }

    public String getFullUrlProxied() {
        return this.getFullUrlProxied(false);
    }

    public String getFullUrlProxied(boolean keepCacheBusters) {
        if (keepCacheBusters) {
            return this.getFullUrlProxiedWithCacheBustersNonDecoded();
        }
        return this.getFullUrlProxiedNoCacheBustersNonDecoded();
    }

    public String getFullUrl() {
        return this.getFullUrl(false);
    }

    public String getFullUrl(boolean keepCacheBusters) {
        this.validateFullUrlInfoCache();
        if (keepCacheBusters) {
            return this.fullUrlWithCacheBustersDecoded;
        }
        return this.fullUrlNoCacheBustersDecoded;
    }

    protected void validateFullUrlInfoCache() {
        try {
            String forwardUrl = this.getRequestContext().variables().getAsString(SpincastConstants.RequestScopedVariables.FORWARD_ROUTE_URL);
            String urlToUse = forwardUrl != null ? forwardUrl : this.getFullUrlOriginalWithCacheBustersNonDecoded();
            if (this.fullUrlWithCacheBustersNonDecoded != null && this.fullUrlWithCacheBustersNonDecoded.equals(urlToUse)) {
                return;
            }
            this.fullUrlWithCacheBustersNonDecoded = urlToUse;
            this.fullUrlWithCacheBustersDecoded = URLDecoder.decode(urlToUse, "UTF-8");
            this.fullUrlNoCacheBustersDecoded = this.getSpincastUtils().removeCacheBusterCodes(this.fullUrlWithCacheBustersDecoded);
            this.parseUrl();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected void parseUrl() {
        this.parseRequestPath();
        this.parseQueryString();
        this.parseQueryStringParams();
    }

    protected void parseRequestPath() {
        try {
            URL url = new URL(this.fullUrlWithCacheBustersDecoded);
            this.requestPathWithCacheBusters = url.getPath();
            url = new URL(this.fullUrlNoCacheBustersDecoded);
            this.requestPathNoCacheBusters = url.getPath();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected void parseQueryString() {
        try {
            String qs;
            this.queryStringNonDecoded = qs = this.getSpincastUtils().getQuerystringFromUrl(this.fullUrlWithCacheBustersNonDecoded);
            this.queryStringDecoded = URLDecoder.decode(qs, "UTF-8");
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public void parseQueryStringParams() {
        Map paramsFinal = this.getSpincastUtils().getParametersFromQuerystring(this.queryStringNonDecoded, false);
        HashMap mapWithInmutableLists = new HashMap();
        for (Map.Entry entry : paramsFinal.entrySet()) {
            mapWithInmutableLists.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        this.queryStringParams = paramsFinal;
    }

    public String getRequestPath() {
        return this.getRequestPath(false);
    }

    public String getRequestPath(boolean keepCacheBusters) {
        this.validateFullUrlInfoCache();
        if (keepCacheBusters) {
            return this.requestPathWithCacheBusters;
        }
        return this.requestPathNoCacheBusters;
    }

    public String getQueryString(boolean withQuestionMark) {
        this.validateFullUrlInfoCache();
        if (StringUtils.isBlank((CharSequence)this.queryStringDecoded)) {
            return "";
        }
        return (withQuestionMark ? "?" : "") + this.queryStringDecoded;
    }

    public Map<String, List<String>> getQueryStringParams() {
        this.validateFullUrlInfoCache();
        return this.queryStringParams;
    }

    public List<String> getQueryStringParam(String name) {
        List<String> values = this.getQueryStringParams().get(name);
        if (values == null) {
            values = Collections.emptyList();
        }
        return values;
    }

    public String getQueryStringParamFirst(String name) {
        List<String> values = this.getQueryStringParam(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public Map<String, String> getPathParams() {
        Map<String, String> pathParams = this.getRequestContext().routing().getCurrentRouteHandlerMatch().getPathParams();
        pathParams = pathParams == null ? Collections.emptyMap() : Collections.unmodifiableMap(pathParams);
        return pathParams;
    }

    public String getPathParam(String name) {
        return this.getPathParams().get(name);
    }

    public InputStream getBodyAsInputStream() {
        return this.getServer().getRawInputStream(this.getExchange());
    }

    public String getBodyAsString() {
        return this.getStringBody("UTF-8");
    }

    public String getStringBody(String encoding) {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return "";
            }
            return IOUtils.toString((InputStream)inputStream, (String)encoding);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public byte[] getBodyAsByteArray() {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return new byte[0];
            }
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public JsonObject getJsonBody() {
        JsonObject obj = this.getJsonBody(JsonObject.class);
        return obj.clone(false);
    }

    public Map<String, Object> getJsonBodyAsMap() {
        Map obj = this.getJsonBody(Map.class);
        return obj;
    }

    public <T> T getJsonBody(Class<T> clazz) {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return null;
            }
            return (T)this.getJsonManager().fromInputStream(inputStream, clazz);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public JsonObject getXmlBodyAsJsonObject() {
        JsonObject obj = this.getXmlBody(JsonObject.class);
        return obj.clone(false);
    }

    public Map<String, Object> getXmlBodyAsMap() {
        Map obj = this.getXmlBody(Map.class);
        return obj;
    }

    public <T> T getXmlBody(Class<T> clazz) {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return null;
            }
            return (T)this.getXmlManager().fromXmlInputStream(inputStream, clazz);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public Map<String, List<String>> getFormBodyRaw() {
        if (this.formDatasAsImmutableMap == null) {
            Map formDatasServer = this.getServer().getFormData(this.getExchange());
            Map<String, List<String>> formDatasFinal = new HashMap<String, List<String>>();
            if (formDatasServer == null) {
                formDatasServer = Collections.emptyMap();
            } else {
                for (Map.Entry entry : formDatasServer.entrySet()) {
                    if (entry.getValue() == null) {
                        formDatasFinal.put((String)entry.getKey(), Collections.emptyList());
                        continue;
                    }
                    formDatasFinal.put((String)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
                }
                formDatasFinal = Collections.unmodifiableMap(formDatasFinal);
            }
            this.formDatasAsImmutableMap = formDatasFinal;
        }
        return this.formDatasAsImmutableMap;
    }

    public JsonObject getFormBodyAsJsonObject() {
        if (this.formDatasAsImmutableJsonObject == null) {
            String key;
            Map<String, List<String>> formDatasRaw = this.getFormBodyRaw();
            LinkedHashMap<String, TreeMap<Integer, String>> formDataArrays = new LinkedHashMap<String, TreeMap<Integer, String>>();
            JsonObject obj = this.getJsonManager().create();
            for (Map.Entry<String, List<String>> entry : formDatasRaw.entrySet()) {
                key = entry.getKey();
                if (key == null) continue;
                List<String> values = entry.getValue();
                Matcher matcher = this.getFormDataArrayPattern().matcher(key);
                if (matcher.matches()) {
                    if (values.size() > 1) {
                        logger.error("More than one Form Data received with the array index name \"" + key + "\", we'll only keep the last element.");
                        values = values.subList(values.size() - 1, values.size());
                    }
                    String value = values.get(0);
                    String arrayPart = matcher.group(1);
                    String indexStr = matcher.group(2);
                    Integer index = Integer.parseInt(indexStr);
                    TreeMap<Integer, String> valuesMap = (TreeMap<Integer, String>)formDataArrays.get(key = key.substring(0, key.length() - arrayPart.length()));
                    if (valuesMap == null) {
                        valuesMap = new TreeMap<Integer, String>();
                        formDataArrays.put(key, valuesMap);
                    }
                    valuesMap.put(index, value);
                    continue;
                }
                if (values.size() > 1 || key.endsWith("[]")) {
                    if (key.endsWith("[]")) {
                        key = key.substring(0, key.length() - "[]".length());
                    }
                    JsonArray array = this.getJsonManager().createArray();
                    array.addAll(values);
                    obj.set(key, (Object)array);
                    continue;
                }
                if (values.size() > 0) {
                    obj.set(key, (Object)values.get(0));
                    continue;
                }
                obj.set(key, null);
            }
            for (Map.Entry<String, List<String>> entry : formDataArrays.entrySet()) {
                key = entry.getKey();
                Map valuesMap = (Map)((Object)entry.getValue());
                Object arrayObj = obj.getObject(key);
                JsonArray array = arrayObj != null && arrayObj instanceof JsonArray ? (JsonArray)arrayObj : this.getJsonManager().createArray();
                LinkedList indexes = new LinkedList(valuesMap.keySet());
                Integer lastIndex = (Integer)indexes.getLast();
                for (int i = 0; i <= lastIndex; ++i) {
                    if (valuesMap.containsKey(i)) {
                        array.add(valuesMap.get(i));
                        continue;
                    }
                    if (array.isElementExists(i)) continue;
                    array.add(null);
                }
                obj.set(key, (Object)array);
            }
            this.formDatasAsImmutableJsonObject = obj.clone(false);
        }
        return this.formDatasAsImmutableJsonObject;
    }

    public Form getFormOrCreate(String rootKey) {
        return this.getForm(rootKey, true);
    }

    public Form getForm(String rootKey) {
        return this.getForm(rootKey, false);
    }

    protected Form getForm(String rootKey, boolean createIfNotFound) {
        if (StringUtils.isBlank((CharSequence)rootKey)) {
            String msg = this.getDictionary().get(SpincastRequestPluginDictionaryEntries.MESSAGE_KEY_FORM_GET_EMPTYNAME);
            throw new RuntimeException(msg);
        }
        if (this.scopedForms == null) {
            this.scopedForms = new HashMap<String, Form>();
        }
        if (!this.scopedForms.containsKey(rootKey)) {
            if (createIfNotFound) {
                JsonObject formData = this.getFormBodyAsJsonObject().getJsonObjectOrEmpty(rootKey);
                Form form = this.getFormFactory().createForm(rootKey, formData);
                this.scopedForms.put(rootKey, form);
            } else {
                return null;
            }
        }
        Form form = this.scopedForms.get(rootKey);
        return form;
    }

    public Map<String, List<UploadedFile>> getUploadedFiles() {
        if (this.uploadedFiles == null) {
            Map uploadedFilesServer = this.getServer().getUploadedFiles(this.getExchange());
            Map<String, List<UploadedFile>> uploadedFilesFinal = new HashMap<String, List<UploadedFile>>();
            if (uploadedFilesServer == null) {
                uploadedFilesServer = Collections.emptyMap();
            } else {
                for (Map.Entry entry : uploadedFilesServer.entrySet()) {
                    if (entry.getValue() == null) {
                        uploadedFilesFinal.put((String)entry.getKey(), Collections.emptyList());
                        continue;
                    }
                    uploadedFilesFinal.put((String)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
                }
                uploadedFilesFinal = Collections.unmodifiableMap(uploadedFilesFinal);
            }
            this.uploadedFiles = uploadedFilesFinal;
        }
        return this.uploadedFiles;
    }

    public List<UploadedFile> getUploadedFiles(String name) {
        List<Object> files = this.getUploadedFiles().get(name);
        if (files == null) {
            files = Collections.emptyList();
        }
        return files;
    }

    public UploadedFile getUploadedFileFirst(String name) {
        List<UploadedFile> files = this.getUploadedFiles(name);
        if (files.size() > 0) {
            return files.get(0);
        }
        return null;
    }

    public Locale getLocaleBestMatch() {
        String header = this.getHeaderFirst("Accept-Language");
        Locale locale = this.getSpincastUtils().getLocaleBestMatchFromAcceptLanguageHeader(header);
        if (locale == null) {
            locale = this.getSpincastConfig().getDefaultLocale();
        }
        return locale;
    }

    public String getContentType() {
        String contentType = this.getHeaderFirst("Content-Type");
        return contentType;
    }

    public boolean isHttps() {
        return this.getFullUrl().trim().toLowerCase().startsWith("https://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ETag> getEtagsFromIfMatchHeader() {
        if (this.ifMatchETags == null) {
            Object object = this.ifMatchETagsLock;
            synchronized (object) {
                if (this.ifMatchETags == null) {
                    this.ifMatchETags = this.parseETagHeader("If-Match");
                }
            }
        }
        return this.ifMatchETags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ETag> getEtagsFromIfNoneMatchHeader() {
        if (this.ifNoneMatchETags == null) {
            Object object = this.ifNoneMatchETagsLock;
            synchronized (object) {
                if (this.ifNoneMatchETags == null) {
                    this.ifNoneMatchETags = this.parseETagHeader("If-None-Match");
                }
            }
        }
        return this.ifNoneMatchETags;
    }

    protected List<ETag> parseETagHeader(String headerName) {
        ArrayList<ETag> etags = new ArrayList<ETag>();
        List<String> eTagHeaders = this.getHeader(headerName);
        if (eTagHeaders != null) {
            for (String eTagHeader : eTagHeaders) {
                String[] tokens;
                for (String eTagStr : tokens = eTagHeader.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1)) {
                    try {
                        ETag eTag = this.getEtagFactory().deserializeHeaderValue(eTagStr);
                        etags.add(eTag);
                    }
                    catch (Exception ex) {
                        logger.info("Invalid " + headerName + " ETag header value received: " + eTagStr);
                    }
                }
            }
        }
        return etags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDateFromIfModifiedSinceHeader() {
        if (this.ifModifiedSinceDate == null) {
            Object object = this.ifModifiedSinceDateLock;
            synchronized (object) {
                if (this.ifModifiedSinceDate == null) {
                    this.ifModifiedSinceDate = this.parseDateHeader("If-Modified-Since");
                }
            }
        }
        return this.ifModifiedSinceDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDateFromIfUnmodifiedSinceHeader() {
        if (this.ifUnmodifiedSinceDate == null) {
            Object object = this.ifUnmodifiedSinceDateLock;
            synchronized (object) {
                if (this.ifUnmodifiedSinceDate == null) {
                    this.ifUnmodifiedSinceDate = this.parseDateHeader("If-Unmodified-Since");
                }
            }
        }
        return this.ifUnmodifiedSinceDate;
    }

    protected Date parseDateHeader(String headerName) {
        String value = this.getHeaderFirst(headerName);
        if (value == null) {
            return null;
        }
        try {
            Date date = DateUtils.parseDate((String)value);
            return date;
        }
        catch (Exception ex) {
            logger.info("Invalid '" + headerName + "' date received: " + value);
            return null;
        }
    }

    public boolean isFlashMessageExists() {
        return this.getFlashMessage(false) != null;
    }

    public FlashMessage getFlashMessage() {
        if (!this.flashMessageRetrieved) {
            this.flashMessageRetrieved = true;
            this.flashMessage = this.getFlashMessage(true);
        }
        return this.flashMessage;
    }

    protected FlashMessage getFlashMessage(boolean removeIt) {
        String flashMessageId = null;
        flashMessageId = this.getCookieValue(this.getSpincastConfig().getCookieNameFlashMessage());
        if (flashMessageId != null) {
            if (removeIt) {
                this.getRequestContext().response().deleteCookie(this.getSpincastConfig().getCookieNameFlashMessage());
            }
        } else {
            flashMessageId = this.getQueryStringParamFirst(this.getSpincastConfig().getQueryParamFlashMessageId());
        }
        FlashMessage flashMessage = null;
        if (flashMessageId != null) {
            flashMessage = this.getFlashMessagesHolder().getFlashMessage(flashMessageId, removeIt);
        }
        return flashMessage;
    }

    public String getIp() {
        return this.getServer().getIp(this.getExchange());
    }
}

