/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.response;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.exchange.IResponseRequestContextAddon;
import org.spincast.core.json.IJsonManager;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.routing.IETagFactory;
import org.spincast.core.server.IServer;
import org.spincast.core.utils.Bool;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.GzipOption;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.xml.IXmlManager;
import org.spincast.plugins.response.IFieldMessage;
import org.spincast.shaded.org.apache.commons.io.IOUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastResponseRequestContextAddon<R extends IRequestContext<?>>
implements IResponseRequestContextAddon<R> {
    protected final Logger logger = LoggerFactory.getLogger(SpincastResponseRequestContextAddon.class);
    protected static final boolean IS_RESPONSE_CHARACTERS_BASED_BY_DEFAULT = false;
    private final R requestContext;
    private final IServer server;
    private final IJsonManager jsonManager;
    private final IXmlManager xmlManager;
    private final ISpincastConfig spincastConfig;
    private final ISpincastUtils spincastUtils;
    private final IETagFactory etagFactory;
    private String responseContentType = null;
    private int responseStatusCode = 200;
    private final ByteArrayOutputStream byteArrayOutputStreamIn = new ByteArrayOutputStream(256);
    private final ByteArrayOutputStream byteArrayOutputStreamOut = new ByteArrayOutputStream(256);
    private GZIPOutputStream gzipOutputStream = null;
    private Bool isShouldGzip = null;
    private String charactersCharsetName = "UTF-8";
    private boolean isResponseCharactersBased = false;
    private boolean requestSizeValidated = false;
    private Map<String, List<String>> headers;
    private GzipOption gzipOption = GzipOption.DEFAULT;
    private List<String> globalErrors;
    private List<String> globalConfirms;
    private List<String> globalWarnings;
    private Map<String, List<IFieldMessage>> fieldsErrors;
    private Map<String, List<IFieldMessage>> fieldsConfirms;
    private Map<String, List<IFieldMessage>> fieldsWarnings;

    @Inject
    public SpincastResponseRequestContextAddon(R requestContext, IServer server, IJsonManager jsonManager, IXmlManager xmlManager, ISpincastConfig spincastConfig, ISpincastUtils spincastUtils, IETagFactory etagFactory) {
        this.requestContext = requestContext;
        this.server = server;
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
        this.etagFactory = etagFactory;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected IServer getServer() {
        return this.server;
    }

    protected Object getExchange() {
        return this.getRequestContext().exchange();
    }

    protected IJsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected IXmlManager getXmlManager() {
        return this.xmlManager;
    }

    protected ISpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected ISpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected IETagFactory getEtagFactory() {
        return this.etagFactory;
    }

    protected ByteArrayOutputStream getBuffer() {
        return this.byteArrayOutputStreamIn;
    }

    protected ByteArrayOutputStream getOut() {
        return this.byteArrayOutputStreamOut;
    }

    protected List<String> getGlobalErrors() {
        if (this.globalErrors == null) {
            this.globalErrors = new ArrayList<String>();
        }
        return this.globalErrors;
    }

    protected List<String> getGlobalConfirms() {
        if (this.globalConfirms == null) {
            this.globalConfirms = new ArrayList<String>();
        }
        return this.globalConfirms;
    }

    protected List<String> getGlobalWarnings() {
        if (this.globalWarnings == null) {
            this.globalWarnings = new ArrayList<String>();
        }
        return this.globalWarnings;
    }

    protected Map<String, List<IFieldMessage>> getFieldsErrors() {
        if (this.fieldsErrors == null) {
            this.fieldsErrors = new HashMap<String, List<IFieldMessage>>();
        }
        return this.fieldsErrors;
    }

    protected Map<String, List<IFieldMessage>> getFieldsConfirms() {
        if (this.fieldsConfirms == null) {
            this.fieldsConfirms = new HashMap<String, List<IFieldMessage>>();
        }
        return this.fieldsConfirms;
    }

    protected Map<String, List<IFieldMessage>> getFieldsWarnings() {
        if (this.fieldsWarnings == null) {
            this.fieldsWarnings = new HashMap<String, List<IFieldMessage>>();
        }
        return this.fieldsWarnings;
    }

    public GZIPOutputStream getGzipBuffer() {
        try {
            if (this.gzipOutputStream == null) {
                this.gzipOutputStream = new GZIPOutputStream((OutputStream)this.getOut(), true);
            }
            return this.gzipOutputStream;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected boolean isRequestSizeValidated() {
        return this.requestSizeValidated;
    }

    protected void setRequestSizeValidated(boolean requestSizeValidated) {
        this.requestSizeValidated = requestSizeValidated;
    }

    public IResponseRequestContextAddon<R> setGzipOption(GzipOption gzipOption) {
        if (gzipOption == null) {
            gzipOption = GzipOption.DEFAULT;
        }
        if (this.isHeadersSent() && gzipOption != this.getGzipOption()) {
            this.logger.warn("The headers are sent, you can't change the gzip options.");
            return this;
        }
        this.gzipOption = gzipOption;
        return this;
    }

    public GzipOption getGzipOption() {
        return this.gzipOption;
    }

    public int getStatusCode() {
        return this.responseStatusCode;
    }

    public IResponseRequestContextAddon<R> setStatusCode(int responseStatusCode) {
        if (this.isHeadersSent()) {
            if (responseStatusCode != this.getStatusCode()) {
                this.logger.warn("Response headers already sent, the http status code can't be changed...");
            }
        } else {
            this.responseStatusCode = responseStatusCode;
        }
        return this;
    }

    public String getContentType() {
        return this.responseContentType;
    }

    public IResponseRequestContextAddon<R> setContentType(String responseContentType) {
        if (this.isHeadersSent()) {
            if (responseContentType != null && !responseContentType.equals(this.getContentType())) {
                this.logger.warn("Response headers already sent, the content-type can't be changed...");
            }
        } else {
            GzipOption gzipOption;
            if ((responseContentType != null && !responseContentType.equals(this.getContentType()) || responseContentType == null && this.getContentType() != null) && (gzipOption = this.getGzipOption()) == GzipOption.DEFAULT) {
                this.isShouldGzip = null;
            }
            this.responseContentType = responseContentType;
        }
        return this;
    }

    protected boolean isResponseCharactersBased() {
        return this.isResponseCharactersBased;
    }

    public boolean isClosed() {
        return this.getServer().isResponseClosed(this.getExchange());
    }

    public void redirect(String newUrl, boolean permanently) {
        if (permanently) {
            this.redirect(newUrl, 301);
        } else {
            this.redirect(newUrl, 302);
        }
    }

    public void redirect(String newUrl, int specific3xxCode) {
        try {
            if (this.isHeadersSent()) {
                throw new RuntimeException("Can't set redirect, the headers are already sent.");
            }
            this.setStatusCode(specific3xxCode);
            if (StringUtils.isBlank((CharSequence)newUrl)) {
                newUrl = "/";
            } else if ((newUrl = newUrl.trim()).startsWith("//")) {
                newUrl = this.getServer().getRequestScheme(this.getExchange()) + ":" + newUrl;
            }
            URI uri = new URI(newUrl);
            if (!uri.isAbsolute()) {
                URI currentUri = new URI(this.getRequestContext().request().getFullUrl());
                String path = newUrl;
                if (!path.startsWith("/")) {
                    String currentPath = currentUri.getPath();
                    int lastSlashPos = (currentPath = StringUtils.strip((String)currentPath, (String)"/")).lastIndexOf("/");
                    path = lastSlashPos < 0 ? "/" + path : "/" + currentPath.substring(0, lastSlashPos) + "/" + path;
                }
                uri = new URI(currentUri.getScheme(), currentUri.getUserInfo(), currentUri.getHost(), currentUri.getPort(), path, null, null);
                newUrl = uri.toString();
            }
            this.setHeader("Location", newUrl);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public void sendBytes(byte[] bytes) {
        this.sendBytes(bytes, null, false);
    }

    public void sendBytes(byte[] bytes, String contentType) {
        this.sendBytes(bytes, contentType, false);
    }

    public void sendBytes(byte[] bytes, String contentType, boolean flush) {
        this.send(bytes, contentType, flush);
    }

    protected void send(byte[] bytes, String contentType, boolean flush) {
        if (this.isClosed()) {
            this.logger.debug("The response is closed, nothing more can be sent!");
            return;
        }
        if (this.isHeadersSent()) {
            if (contentType != null && !contentType.equals(this.getContentType())) {
                this.logger.warn("Response headers are already sent, the content-type won't be changed...");
            }
        } else if (contentType != null) {
            if (this.getContentType() != null && !contentType.equals(this.getContentType())) {
                this.logger.warn("The content-type is changed from " + this.getContentType() + " to " + contentType);
            }
            this.setContentType(contentType);
        }
        if (bytes != null) {
            try {
                this.getBuffer().write(bytes);
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        if (flush) {
            this.flush();
        }
    }

    public void sendCharacters(String content) {
        this.sendCharacters(content, null, false);
    }

    public void sendCharacters(String content, String contentType) {
        this.sendCharacters(content, contentType, false);
    }

    public void sendCharacters(String content, String contentType, boolean flush) {
        try {
            this.isResponseCharactersBased = true;
            byte[] bytes = null;
            if (content != null) {
                bytes = content.getBytes(this.getCharactersCharsetName());
            }
            this.send(bytes, contentType, flush);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public String getCharactersCharsetName() {
        return this.charactersCharsetName;
    }

    public IResponseRequestContextAddon<R> setCharactersCharsetName(String charactersCharsetName) {
        Objects.requireNonNull(charactersCharsetName, "charactersCharsetName can't be NULL");
        if (this.isHeadersSent() && !charactersCharsetName.equalsIgnoreCase(this.getCharactersCharsetName())) {
            this.logger.warn("Some data have already been send, it may not be a good idea to change the Charset now.");
        }
        this.charactersCharsetName = charactersCharsetName;
        return this;
    }

    public void sendPlainText(String string) {
        this.sendPlainText(string, false);
    }

    public void sendPlainText(String string, boolean flush) {
        this.sendCharacters(string, ContentTypeDefaults.TEXT.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendHtml(String html) {
        this.sendHtml(html, false);
    }

    public void sendHtml(String string, boolean flush) {
        this.sendCharacters(string, ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendParseHtml(String html, Map<String, Object> params) {
        this.sendParseHtml(html, params, false);
    }

    public void sendParseHtml(String html, Map<String, Object> params, boolean flush) {
        IJsonObject model = this.getJsonManager().create(params);
        this.sendParseHtml(html, model, flush);
    }

    public void sendParseHtml(String html, IJsonObject model) {
        this.sendParseHtml(html, model, false);
    }

    public void sendParseHtml(String html, IJsonObject model, boolean flush) {
        String evaluated = this.getRequestContext().templating().evaluate(html, model);
        this.sendHtml(evaluated, flush);
    }

    public void sendTemplateHtml(String templatePath, IJsonObject model) {
        this.sendTemplateHtml(templatePath, true, model, false);
    }

    public void sendTemplateHtml(String templatePath, IJsonObject model, boolean flush) {
        this.sendTemplateHtml(templatePath, true, model, flush);
    }

    public void sendTemplateHtml(String templatePath, boolean isClasspathPath, IJsonObject model) {
        this.sendTemplateHtml(templatePath, isClasspathPath, model, false);
    }

    public void sendTemplateHtml(String templatePath, boolean isClasspathPath, IJsonObject model, boolean flush) {
        String evaluated = this.getRequestContext().templating().fromTemplate(templatePath, isClasspathPath, model);
        this.sendHtml(evaluated, flush);
    }

    public void sendParse(String content, String contentType, Map<String, Object> params) {
        this.sendParse(content, contentType, params, false);
    }

    public void sendParse(String content, String contentType, Map<String, Object> params, boolean flush) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        IJsonObject model = this.getJsonManager().create(params);
        this.sendParse(content, contentType, model, flush);
    }

    public void sendParse(String content, String contentType, IJsonObject model) {
        this.sendParse(content, contentType, model, false);
    }

    public void sendParse(String content, String contentType, IJsonObject model, boolean flush) {
        if (StringUtils.isBlank((CharSequence)contentType)) {
            this.sendParseHtml(content, model, flush);
            return;
        }
        String evaluated = this.getRequestContext().templating().evaluate(content, model);
        this.sendCharacters(evaluated, contentType, flush);
    }

    public void sendTemplateHtml(String templatePath, Map<String, Object> params) {
        this.sendTemplateHtml(templatePath, true, params, false);
    }

    public void sendTemplateHtml(String templatePath, boolean isClasspathPath, Map<String, Object> params) {
        this.sendTemplateHtml(templatePath, isClasspathPath, params, false);
    }

    public void sendTemplateHtml(String templatePath, Map<String, Object> params, boolean flush) {
        this.sendTemplateHtml(templatePath, true, params, flush);
    }

    public void sendTemplateHtml(String templatePath, boolean isClasspathPath, Map<String, Object> params, boolean flush) {
        String evaluated = this.getRequestContext().templating().fromTemplate(templatePath, isClasspathPath, params);
        this.sendHtml(evaluated, flush);
    }

    public void sendTemplate(String templatePath, String contentType, Map<String, Object> params) {
        this.sendTemplate(templatePath, true, contentType, params, false);
    }

    public void sendTemplate(String templatePath, boolean isClasspathPath, String contentType, Map<String, Object> params) {
        this.sendTemplate(templatePath, isClasspathPath, contentType, params, false);
    }

    public void sendTemplate(String templatePath, String contentType, Map<String, Object> params, boolean flush) {
        this.sendTemplate(templatePath, true, contentType, params, flush);
    }

    public void sendTemplate(String templatePath, boolean isClasspathPath, String contentType, Map<String, Object> params, boolean flush) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        IJsonObject model = this.getJsonManager().create(params);
        this.sendTemplate(templatePath, isClasspathPath, contentType, model, flush);
    }

    public void sendTemplate(String templatePath, String contentType, IJsonObject model) {
        this.sendTemplate(templatePath, true, contentType, model, false);
    }

    public void sendTemplate(String templatePath, String contentType, IJsonObject model, boolean flush) {
        this.sendTemplate(templatePath, true, contentType, model, flush);
    }

    public void sendTemplate(String templatePath, boolean isClasspathPath, String contentType, IJsonObject model) {
        this.sendTemplate(templatePath, isClasspathPath, contentType, model, false);
    }

    public void sendTemplate(String templatePath, boolean isClasspathPath, String contentType, IJsonObject model, boolean flush) {
        if (StringUtils.isBlank((CharSequence)contentType) && (contentType = this.getSpincastUtils().getMimeTypeFromPath(templatePath)) == null) {
            this.logger.warn("The Content-Type was not specified and can't be determined from the template path '" + templatePath + "': 'text/plain' will be used");
            contentType = ContentTypeDefaults.TEXT.getMainVariationWithUtf8Charset();
        }
        String evaluated = this.getRequestContext().templating().fromTemplate(templatePath, isClasspathPath, model);
        this.sendCharacters(evaluated, contentType, flush);
    }

    public void sendJson(String jsonString) {
        this.sendJson(jsonString, false);
    }

    public void sendJson(String jsonString, boolean flush) {
        this.sendCharacters(jsonString, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendJsonObj(Object obj) {
        this.sendJsonObj(obj, false);
    }

    public void sendJsonObj(Object obj, boolean flush) {
        String json = this.getJsonManager().toJsonString(obj);
        this.sendCharacters(json, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendXml(String xml) {
        this.sendXml(xml, false);
    }

    public void sendXml(String xml, boolean flush) {
        this.sendCharacters(xml, ContentTypeDefaults.XML.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendXmlObj(Object obj) {
        this.sendXmlObj(obj, false);
    }

    public void sendXmlObj(Object obj, boolean flush) {
        String xml = this.getXmlManager().toXml(obj);
        this.sendCharacters(xml, ContentTypeDefaults.XML.getMainVariationWithUtf8Charset(), flush);
    }

    public IResponseRequestContextAddon<R> resetBuffer() {
        try {
            this.getBuffer().reset();
            if (!this.isHeadersSent()) {
                this.isResponseCharactersBased = false;
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        return this;
    }

    public IResponseRequestContextAddon<R> resetEverything() {
        this.resetBuffer();
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, the cookies, headers and status code won't be reset...");
        } else {
            this.getRequestContext().cookies().resetCookies();
            this.getHeaders().clear();
            this.setContentType(null);
            this.setStatusCode(200);
        }
        return this;
    }

    public byte[] getUnsentBytes() {
        return this.getBuffer().toByteArray();
    }

    public String getUnsentCharacters() {
        return this.getUnsentCharacters("UTF-8");
    }

    public String getUnsentCharacters(String encoding) {
        try {
            byte[] unsentBytes = this.getUnsentBytes();
            return new String(unsentBytes, encoding);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public IResponseRequestContextAddon<R> removeHeader(String name) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        this.getHeaders().remove(name);
        return this;
    }

    public IResponseRequestContextAddon<R> setHeader(String name, String value) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (value == null) {
            this.removeHeader(name);
            return this;
        }
        this.setHeader(name, Arrays.asList(value));
        return this;
    }

    public IResponseRequestContextAddon<R> setHeader(String name, List<String> values) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (values == null) {
            this.removeHeader(name);
            return this;
        }
        this.getHeaders().put(name, values);
        return this;
    }

    public IResponseRequestContextAddon<R> addHeaderValue(String name, String value) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (value == null) {
            return this;
        }
        this.addHeaderValues(name, Arrays.asList(value));
        return this;
    }

    public IResponseRequestContextAddon<R> addHeaderValues(String name, List<String> values) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (values == null) {
            return this;
        }
        List<String> currentValues = this.getHeaders().get(name);
        if (currentValues == null) {
            currentValues = new ArrayList<String>();
            this.getHeaders().put(name, currentValues);
        }
        currentValues.addAll(values);
        return this;
    }

    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            Map headersFromServer = this.getServer().getResponseHeaders(this.getExchange());
            TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            if (headersFromServer != null) {
                treeMap.putAll(headersFromServer);
            }
            this.headers = treeMap;
        }
        return this.headers;
    }

    public List<String> getHeader(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return new LinkedList<String>();
        }
        List<String> values = this.getHeaders().get(name);
        if (values == null) {
            values = new LinkedList<String>();
        }
        return values;
    }

    public String getHeaderFirst(String name) {
        List<String> values = this.getHeader(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public boolean isHeadersSent() {
        return this.getServer().isResponseHeadersSent(this.getExchange());
    }

    protected void setIsShouldGzip(boolean isShouldGzip) {
        GzipOption gzipOption = this.getGzipOption();
        if (gzipOption != GzipOption.DEFAULT) {
            this.logger.warn("Can't turn on/off the gzip feature since the GzipOption is " + gzipOption);
            return;
        }
        try {
            if (this.isHeadersSent()) {
                if (this.isShouldGzip != null && this.isShouldGzip.getBoolean() != isShouldGzip) {
                    this.logger.warn("Can't turn on/off the gzip feature since headers are already sent.");
                }
                return;
            }
            if (this.isShouldGzip != null && this.isShouldGzip.getBoolean() && !isShouldGzip) {
                this.byteArrayOutputStreamIn.reset();
                this.getGzipBuffer().close();
                ByteArrayOutputStream buffer = this.getBuffer();
                if (buffer.size() > 0) {
                    GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(buffer.toByteArray()));
                    byte[] ungzipedBytes = IOUtils.toByteArray((InputStream)gzipInputStream);
                    this.byteArrayOutputStreamIn.write(ungzipedBytes);
                }
                this.gzipOutputStream = null;
            }
            this.isShouldGzip = Bool.from((boolean)isShouldGzip);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected boolean isShouldGzip() {
        GzipOption gzipOption = this.getGzipOption();
        if (gzipOption == GzipOption.FORCE) {
            return true;
        }
        if (gzipOption == GzipOption.DISABLE) {
            return false;
        }
        if (gzipOption != GzipOption.DEFAULT) {
            throw new RuntimeException("Unimplemented : " + gzipOption);
        }
        if (this.isShouldGzip == null) {
            String responseContentType;
            boolean hasGzipAcceptHeader = false;
            List acceptEncodings = this.getRequestContext().request().getHeader("Accept-Encoding");
            if (acceptEncodings != null) {
                for (String acceptEncoding : acceptEncodings) {
                    if (acceptEncoding == null || !acceptEncoding.contains("gzip")) continue;
                    hasGzipAcceptHeader = true;
                    break;
                }
            }
            if ((responseContentType = this.getContentType()) == null) {
                String path = this.getRequestContext().request().getRequestPath();
                responseContentType = this.getSpincastUtils().getMimeTypeFromPath(path);
            }
            if (responseContentType != null) {
                if (!this.getSpincastUtils().isContentTypeToSkipGziping(responseContentType)) {
                    if (!hasGzipAcceptHeader) {
                        this.logger.debug("No gzip 'Accept-Encoding' header, we won't gzip the response.");
                        this.setIsShouldGzip(false);
                    } else {
                        this.setIsShouldGzip(true);
                    }
                }
            } else {
                this.setIsShouldGzip(false);
            }
        }
        if (this.isShouldGzip == null) {
            return false;
        }
        return this.isShouldGzip.getBoolean();
    }

    public void end() {
        this.flush(true);
    }

    public void flush() {
        this.flush(false);
    }

    public void flush(boolean end) {
        try {
            byte[] bytesToFlush;
            if (this.isClosed()) {
                return;
            }
            if (!this.isRequestSizeValidated() && !this.isHeadersSent()) {
                this.setRequestSizeValidated(true);
                boolean requestSizeOk = this.getServer().forceRequestSizeValidation(this.getExchange());
                if (!requestSizeOk) {
                    this.resetEverything();
                    this.setStatusCode(413);
                }
            }
            ByteArrayOutputStream buffer = this.getBuffer();
            if (!this.isHeadersSent()) {
                this.getServer().setResponseStatusCode(this.getExchange(), this.getStatusCode());
                String responseContentType = this.getContentType();
                if (responseContentType == null) {
                    String mimeType = this.getSpincastUtils().getMimeTypeFromPath(this.getRequestContext().request().getRequestPath());
                    responseContentType = mimeType != null ? mimeType : (this.isResponseCharactersBased() || buffer.size() == 0 ? ContentTypeDefaults.TEXT.getMainVariationWithUtf8Charset() : ContentTypeDefaults.BINARY.getMainVariation());
                    this.setContentType(responseContentType);
                }
                this.setHeader("Content-Type", responseContentType);
                this.getServer().setResponseStatusCode(this.getExchange(), this.getStatusCode());
                if (end && !this.isShouldGzip()) {
                    this.setHeader("Content-Length", "" + buffer.size());
                }
                this.getServer().addCookies(this.getExchange(), this.getRequestContext().cookies().getCookies());
                if (this.isShouldGzip()) {
                    this.setHeader("Content-Encoding", "gzip");
                    this.setHeader("Transfer-Encoding", "chunked");
                }
                this.getServer().setResponseHeaders(this.getExchange(), this.getHeaders());
            }
            if (this.isShouldGzip()) {
                this.getGzipBuffer().write(buffer.toByteArray());
                this.getGzipBuffer().flush();
                if (end) {
                    this.getGzipBuffer().close();
                }
                bytesToFlush = this.getOut().toByteArray();
                this.getOut().reset();
            } else {
                bytesToFlush = buffer.toByteArray();
            }
            buffer.reset();
            this.getServer().flushBytes(this.getExchange(), bytesToFlush, end);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public IResponseRequestContextAddon<R> setCacheSeconds(int cacheSeconds) {
        return this.setCacheSeconds(cacheSeconds, false);
    }

    public IResponseRequestContextAddon<R> setCacheSeconds(int cacheSeconds, boolean isPrivateCache) {
        if (cacheSeconds <= 0) {
            this.logger.warn("A number of seconds below 1 doesn't send any cache headers: " + cacheSeconds);
            return this;
        }
        if (this.isHeadersSent()) {
            this.logger.error("The headers are sent, you can't add cache headers.");
            return this;
        }
        String cacheControl = "max-age=" + cacheSeconds;
        cacheControl = isPrivateCache ? "private, " + cacheControl : "public, " + cacheControl;
        this.setHeader("Cache-Control", cacheControl);
        return this;
    }
}

