/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.response;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.cookies.Cookie;
import org.spincast.core.cookies.CookieFactory;
import org.spincast.core.cookies.CookieSameSite;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.exchange.ResponseRequestContextAddon;
import org.spincast.core.flash.FlashMessage;
import org.spincast.core.flash.FlashMessageFactory;
import org.spincast.core.flash.FlashMessageLevel;
import org.spincast.core.flash.FlashMessagesHolder;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.request.Form;
import org.spincast.core.response.Alert;
import org.spincast.core.response.AlertDefault;
import org.spincast.core.response.AlertLevel;
import org.spincast.core.routing.ETagFactory;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.ResourceToPush;
import org.spincast.core.server.Server;
import org.spincast.core.utils.Bool;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.GzipOption;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.core.xml.XmlManager;
import org.spincast.shaded.org.apache.commons.io.IOUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.commons.lang3.time.DateUtils;
import org.spincast.shaded.org.apache.http.client.utils.URIBuilder;

public class SpincastResponseRequestContextAddon<R extends RequestContext<?>>
implements ResponseRequestContextAddon<R> {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastResponseRequestContextAddon.class);
    protected static final boolean IS_RESPONSE_CHARACTERS_BASED_BY_DEFAULT = false;
    private final R requestContext;
    private final Server server;
    private final JsonManager jsonManager;
    private final XmlManager xmlManager;
    private final SpincastConfig spincastConfig;
    private final SpincastUtils spincastUtils;
    private final ETagFactory etagFactory;
    private final FlashMessagesHolder flashMessagesHolder;
    private final FlashMessageFactory flashMessageFactory;
    private final CookieFactory cookieFactory;
    private String responseContentType = null;
    private int responseStatusCode = 200;
    private final ByteArrayOutputStream byteArrayOutputStreamIn = new ByteArrayOutputStream(256);
    private final ByteArrayOutputStream byteArrayOutputStreamOut = new ByteArrayOutputStream(256);
    private GZIPOutputStream gzipOutputStream = null;
    private Bool isShouldGzip = null;
    private String charactersCharsetName = "UTF-8";
    private boolean isResponseCharactersBased = false;
    private boolean requestSizeValidated = false;
    private Map<String, List<String>> headers;
    private GzipOption gzipOption = GzipOption.DEFAULT;
    private Map<String, Cookie> cookies;
    private Set<ResourceToPush> resourcesToPush;
    private JsonObject responseModel;

    @Inject
    public SpincastResponseRequestContextAddon(R requestContext, Server server, JsonManager jsonManager, XmlManager xmlManager, SpincastConfig spincastConfig, SpincastUtils spincastUtils, ETagFactory etagFactory, FlashMessagesHolder flashMessagesHolder, FlashMessageFactory flashMessageFactory, CookieFactory cookieFactory) {
        this.requestContext = requestContext;
        this.server = server;
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
        this.etagFactory = etagFactory;
        this.flashMessagesHolder = flashMessagesHolder;
        this.flashMessageFactory = flashMessageFactory;
        this.cookieFactory = cookieFactory;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected Server getServer() {
        return this.server;
    }

    protected Object getExchange() {
        return this.getRequestContext().exchange();
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected XmlManager getXmlManager() {
        return this.xmlManager;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected ETagFactory getEtagFactory() {
        return this.etagFactory;
    }

    protected FlashMessagesHolder getFlashMessagesHolder() {
        return this.flashMessagesHolder;
    }

    protected FlashMessageFactory getFlashMessageFactory() {
        return this.flashMessageFactory;
    }

    protected CookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected ByteArrayOutputStream getBuffer() {
        return this.byteArrayOutputStreamIn;
    }

    protected ByteArrayOutputStream getOut() {
        return this.byteArrayOutputStreamOut;
    }

    public JsonObject getModel() {
        if (this.responseModel == null) {
            this.responseModel = this.getJsonManager().create();
        }
        return this.responseModel;
    }

    public GZIPOutputStream getGzipBuffer() {
        try {
            if (this.gzipOutputStream == null) {
                this.gzipOutputStream = new GZIPOutputStream((OutputStream)this.getOut(), true);
            }
            return this.gzipOutputStream;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected boolean isRequestSizeValidated() {
        return this.requestSizeValidated;
    }

    protected void setRequestSizeValidated(boolean requestSizeValidated) {
        this.requestSizeValidated = requestSizeValidated;
    }

    public ResponseRequestContextAddon<R> setGzipOption(GzipOption gzipOption) {
        if (gzipOption == null) {
            gzipOption = GzipOption.DEFAULT;
        }
        if (this.isHeadersSent() && gzipOption != this.getGzipOption()) {
            logger.warn("The headers are sent, you can't change the gzip options.");
            return this;
        }
        this.gzipOption = gzipOption;
        return this;
    }

    public GzipOption getGzipOption() {
        return this.gzipOption;
    }

    public int getStatusCode() {
        return this.responseStatusCode;
    }

    public ResponseRequestContextAddon<R> setStatusCode(int responseStatusCode) {
        if (this.isHeadersSent()) {
            if (responseStatusCode != this.getStatusCode()) {
                logger.warn("Response headers already sent, the http status code can't be changed...");
            }
        } else {
            this.responseStatusCode = responseStatusCode;
        }
        return this;
    }

    public String getContentType() {
        return this.responseContentType;
    }

    public ResponseRequestContextAddon<R> setContentType(String responseContentType) {
        if (this.isHeadersSent()) {
            if (responseContentType != null && !responseContentType.equals(this.getContentType())) {
                logger.warn("Response headers already sent, the content-type can't be changed...");
            }
        } else {
            GzipOption gzipOption;
            if ((responseContentType != null && !responseContentType.equals(this.getContentType()) || responseContentType == null && this.getContentType() != null) && (gzipOption = this.getGzipOption()) == GzipOption.DEFAULT) {
                this.isShouldGzip = null;
            }
            this.responseContentType = responseContentType;
        }
        return this;
    }

    protected boolean isResponseCharactersBased() {
        return this.isResponseCharactersBased;
    }

    public boolean isClosed() {
        return this.getServer().isResponseClosed(this.getExchange());
    }

    public void redirect() {
        this.redirect("", false, null);
    }

    public void redirect(FlashMessage flashMessage) {
        this.redirect("", false, flashMessage);
    }

    public void redirect(FlashMessageLevel flashMessageType, String flashMessageText) {
        this.redirect(flashMessageType, flashMessageText, null);
    }

    public void redirect(FlashMessageLevel flashMessageType, String flashMessageText, JsonObject flashMessageVariables) {
        this.redirect(this.getFlashMessageFactory().create(flashMessageType, flashMessageText, flashMessageVariables));
    }

    public void redirect(String newUrl) {
        this.redirect(newUrl, false, null);
    }

    public void redirect(String newUrl, FlashMessage flashMessage) {
        this.redirect(newUrl, false, flashMessage);
    }

    public void redirect(String newUrl, FlashMessageLevel flashMessageType, String flashMessageText) {
        this.redirect(newUrl, flashMessageType, flashMessageText, null);
    }

    public void redirect(String newUrl, FlashMessageLevel flashMessageType, String flashMessageText, JsonObject flashMessageVariables) {
        this.redirect(newUrl, this.getFlashMessageFactory().create(flashMessageType, flashMessageText, flashMessageVariables));
    }

    public void redirect(String newUrl, JsonObject flashMessageVariables) {
        this.redirect(newUrl, this.getFlashMessageFactory().create(FlashMessageLevel.SUCCESS, null, flashMessageVariables));
    }

    public void redirect(String newUrl, boolean permanently) {
        this.redirect(newUrl, permanently, null);
    }

    public void redirect(String newUrl, boolean permanently, FlashMessage flashMessage) {
        if (permanently) {
            this.redirect(newUrl, 301, flashMessage);
        } else {
            this.redirect(newUrl, 302, flashMessage);
        }
    }

    public void redirect(String newUrl, boolean permanently, FlashMessageLevel flashMessageType, String flashMessageText) {
        this.redirect(newUrl, permanently, this.getFlashMessageFactory().create(flashMessageType, flashMessageText));
    }

    public void redirect(String newUrl, boolean permanently, FlashMessageLevel flashMessageType, String flashMessageText, JsonObject flashMessageVariables) {
        this.redirect(newUrl, permanently, this.getFlashMessageFactory().create(flashMessageType, flashMessageText, flashMessageVariables));
    }

    public void redirect(String newUrl, int specific3xxCode) {
        this.redirect(newUrl, specific3xxCode, null);
    }

    public void redirect(String newUrl, int specific3xxCode, FlashMessageLevel flashMessageType, String flashMessageText) {
        this.redirect(newUrl, specific3xxCode, this.getFlashMessageFactory().create(flashMessageType, flashMessageText));
    }

    public void redirect(String newUrl, int specific3xxCode, FlashMessageLevel flashMessageType, String flashMessageText, JsonObject flashMessageVariables) {
        this.redirect(newUrl, specific3xxCode, this.getFlashMessageFactory().create(flashMessageType, flashMessageText, flashMessageVariables));
    }

    public void redirect(String newUrl, int specific3xxCode, FlashMessage flashMessage) {
        try {
            if (this.isHeadersSent()) {
                throw new RuntimeException("Can't set redirect, the headers are already sent.");
            }
            this.setStatusCode(specific3xxCode);
            if (StringUtils.isBlank((CharSequence)newUrl)) {
                newUrl = this.getRequestContext().request().getFullUrlOriginal();
            } else if (((String)(newUrl = ((String)newUrl).trim())).startsWith("//")) {
                newUrl = this.getServer().getRequestScheme(this.getExchange()) + ":" + (String)newUrl;
            }
            URI uri = new URI((String)newUrl);
            if (!uri.isAbsolute()) {
                URI currentUri = new URI(this.getRequestContext().request().getFullUrl());
                String anchor = null;
                if (uri.getFragment() != null) {
                    anchor = uri.getFragment();
                }
                String queryString = null;
                if (uri.getQuery() != null) {
                    queryString = uri.getQuery();
                }
                Object path = uri.getPath();
                if (((String)newUrl).startsWith("#") || ((String)newUrl).startsWith("?")) {
                    path = currentUri.getPath();
                } else if (!((String)newUrl).startsWith("/")) {
                    String currentPath = currentUri.getPath();
                    int lastSlashPos = (currentPath = StringUtils.strip((String)currentPath, (String)"/")).lastIndexOf("/");
                    path = lastSlashPos < 0 ? "/" + (String)path : "/" + currentPath.substring(0, lastSlashPos) + "/" + (String)path;
                }
                uri = new URI(currentUri.getScheme(), currentUri.getUserInfo(), currentUri.getHost(), currentUri.getPort(), (String)path, queryString, anchor);
                newUrl = uri.toString();
            }
            if (flashMessage != null) {
                newUrl = this.saveFlashMessage((String)newUrl, flashMessage);
            }
            this.setHeader("Location", (String)newUrl);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected String saveFlashMessage(String url, FlashMessage flashMessage) {
        if (flashMessage == null) {
            return url;
        }
        String flashMessageId = this.getFlashMessagesHolder().saveFlashMessage(flashMessage);
        if (this.getRequestContext().request().isCookiesEnabledValidated()) {
            this.getRequestContext().response().setCookieSession(this.getSpincastConfig().getCookieNameFlashMessage(), flashMessageId);
            return url;
        }
        try {
            URIBuilder builder = new URIBuilder(url);
            builder.setParameter(this.getSpincastConfig().getQueryParamFlashMessageId(), flashMessageId);
            return builder.build().toString();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public void sendBytes(byte[] bytes) {
        this.sendBytes(bytes, null, false);
    }

    public void sendBytes(byte[] bytes, String contentType) {
        this.sendBytes(bytes, contentType, false);
    }

    public void sendBytes(byte[] bytes, String contentType, boolean flush) {
        this.send(bytes, contentType, flush);
    }

    protected void send(byte[] bytes, String contentType, boolean flush) {
        if (this.isClosed()) {
            logger.debug("The response is closed, nothing more can be sent!");
            return;
        }
        if (this.isHeadersSent()) {
            if (contentType != null && !contentType.equals(this.getContentType())) {
                logger.warn("Response headers are already sent, the content-type won't be changed...");
            }
        } else if (contentType != null) {
            if (this.getContentType() != null && !contentType.equals(this.getContentType())) {
                logger.warn("The content-type is changed from " + this.getContentType() + " to " + contentType);
            }
            this.setContentType(contentType);
        }
        if (bytes != null) {
            try {
                this.getBuffer().write(bytes);
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        if (flush) {
            this.flush();
        }
    }

    public void sendCharacters(String content, String contentType) {
        this.sendCharacters(content, contentType, false);
    }

    public void sendCharacters(String content, String contentType, boolean flush) {
        try {
            this.isResponseCharactersBased = true;
            byte[] bytes = null;
            if (content != null) {
                bytes = content.getBytes(this.getCharactersCharsetName());
            }
            this.send(bytes, contentType, flush);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public String getCharactersCharsetName() {
        return this.charactersCharsetName;
    }

    public ResponseRequestContextAddon<R> setCharactersCharsetName(String charactersCharsetName) {
        Objects.requireNonNull(charactersCharsetName, "charactersCharsetName can't be NULL");
        if (this.isHeadersSent() && !charactersCharsetName.equalsIgnoreCase(this.getCharactersCharsetName())) {
            logger.warn("Some data have already been send, it may not be a good idea to change the Charset now.");
        }
        this.charactersCharsetName = charactersCharsetName;
        return this;
    }

    public void sendPlainText(String string) {
        this.sendPlainText(string, false);
    }

    public void sendPlainText(String string, boolean flush) {
        this.sendCharacters(string, ContentTypeDefaults.TEXT.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendHtml(String html) {
        this.sendHtml(html, false);
    }

    public void sendHtml(String string, boolean flush) {
        this.sendCharacters(string, ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendParseHtml(String html) {
        this.sendParse(html, ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset(), false);
    }

    public void sendParseHtml(String html, boolean flush) {
        this.sendParse(html, ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendParse(String content, String contentType) {
        this.sendParse(content, contentType, false);
    }

    public void sendParse(String content, String contentType, boolean flush) {
        if (StringUtils.isBlank((CharSequence)contentType)) {
            logger.warn("The Content-Type was not specified : 'text/html' will be used");
            contentType = ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset();
        }
        if (content == null) {
            content = "";
        }
        String evaluated = this.getRequestContext().templating().evaluate(content, this.getModel());
        this.sendCharacters(evaluated, contentType, flush);
    }

    public void sendTemplateHtml(String templatePath) {
        this.sendTemplateHtml(templatePath, true, false);
    }

    public void sendTemplateHtml(String templatePath, boolean isClasspathPath) {
        this.sendTemplateHtml(templatePath, isClasspathPath, false);
    }

    public void sendTemplateHtml(String templatePath, boolean isClasspathPath, boolean flush) {
        this.sendTemplate(templatePath, isClasspathPath, ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendTemplate(String templatePath, String contentType) {
        this.sendTemplate(templatePath, true, contentType, false);
    }

    public void sendTemplate(String templatePath, String contentType, boolean flush) {
        this.sendTemplate(templatePath, true, contentType, flush);
    }

    public void sendTemplate(String templatePath, boolean isClasspathPath, String contentType) {
        this.sendTemplate(templatePath, isClasspathPath, contentType, false);
    }

    public void sendTemplate(String templatePath, boolean isClasspathPath, String contentType, boolean flush) {
        if (StringUtils.isBlank((CharSequence)contentType) && (contentType = this.getSpincastUtils().getMimeTypeFromPath(templatePath)) == null) {
            logger.warn("The Content-Type was not specified and can't be determined from the template path '" + templatePath + "': 'text/html' will be used");
            contentType = ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset();
        }
        String evaluated = this.getRequestContext().templating().fromTemplate(templatePath, isClasspathPath, this.getModel());
        this.sendCharacters(evaluated, contentType, flush);
    }

    public void sendJson() {
        this.sendJson(false);
    }

    public void sendJson(boolean flush) {
        this.addAlertsToModel();
        String json = this.getJsonManager().toJsonString((Object)this.getModel());
        this.sendCharacters(json, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendJson(String jsonString) {
        this.sendJson(jsonString, false);
    }

    public void sendJson(String jsonString, boolean flush) {
        this.sendCharacters(jsonString, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendJson(Object obj) {
        this.sendJson(obj, false);
    }

    public void sendJson(Object obj, boolean flush) {
        if (obj instanceof String) {
            this.sendJson((String)obj);
            return;
        }
        String json = this.getJsonManager().toJsonString(obj);
        this.sendCharacters(json, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendXml() {
        this.sendXml(false);
    }

    public void sendXml(boolean flush) {
        this.addAlertsToModel();
        String xml = this.getXmlManager().toXml((Object)this.getModel());
        this.sendCharacters(xml, ContentTypeDefaults.XML.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendXml(String xml) {
        this.sendXml(xml, false);
    }

    public void sendXml(String xml, boolean flush) {
        this.sendCharacters(xml, ContentTypeDefaults.XML.getMainVariationWithUtf8Charset(), flush);
    }

    public void sendXml(Object obj) {
        this.sendXml(obj, false);
    }

    public void sendXml(Object obj, boolean flush) {
        if (obj instanceof String) {
            this.sendXml((String)obj);
            return;
        }
        String xml = this.getXmlManager().toXml(obj);
        this.sendCharacters(xml, ContentTypeDefaults.XML.getMainVariationWithUtf8Charset(), flush);
    }

    protected void addAlertsToModel() {
        Map map;
        List alerts;
        if (this.isAddAlertsToModel() && (alerts = (List)(map = this.getRequestContext().templating().getSpincastReservedMap()).get("alerts")) != null && alerts.size() > 0) {
            JsonObject model = this.getModel();
            String spincastModelObjKey = this.getSpincastConfig().getSpincastModelRootVariableName();
            JsonObject spincastModelObj = model.getJsonObjectOrEmpty(spincastModelObjKey);
            model.set(spincastModelObjKey, (Object)spincastModelObj);
            JsonArray alertsArray = spincastModelObj.getJsonArrayOrEmpty("alerts");
            spincastModelObj.set("alerts", (Object)alertsArray);
            for (Alert alert : alerts) {
                alertsArray.add((Object)alert);
            }
        }
    }

    protected boolean isAddAlertsToModel() {
        return true;
    }

    public ResponseRequestContextAddon<R> resetBuffer() {
        try {
            this.getBuffer().reset();
            if (!this.isHeadersSent()) {
                this.isResponseCharactersBased = false;
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        return this;
    }

    public ResponseRequestContextAddon<R> resetEverything() {
        return this.resetEverything(true);
    }

    public ResponseRequestContextAddon<R> resetEverything(boolean resetCookies) {
        this.resetBuffer();
        if (this.isHeadersSent()) {
            logger.warn("Response headers are already sent, the cookies, headers and status code won't be reset...");
        } else {
            if (resetCookies) {
                this.getCookiesAdded().clear();
            }
            this.getHeaders().clear();
            this.setContentType(null);
            this.setStatusCode(200);
        }
        return this;
    }

    public byte[] getUnsentBytes() {
        return this.getBuffer().toByteArray();
    }

    public String getUnsentCharacters() {
        return this.getUnsentCharacters("UTF-8");
    }

    public String getUnsentCharacters(String encoding) {
        try {
            byte[] unsentBytes = this.getUnsentBytes();
            return new String(unsentBytes, encoding);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public ResponseRequestContextAddon<R> removeHeader(String name) {
        if (this.isHeadersSent()) {
            logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        this.getHeaders().remove(name);
        return this;
    }

    public ResponseRequestContextAddon<R> setHeader(String name, String value) {
        if (this.isHeadersSent()) {
            logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (value == null) {
            this.removeHeader(name);
            return this;
        }
        this.setHeader(name, Arrays.asList(value));
        return this;
    }

    public ResponseRequestContextAddon<R> setHeader(String name, List<String> values) {
        if (this.isHeadersSent()) {
            logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (values == null) {
            this.removeHeader(name);
            return this;
        }
        this.getHeaders().put(name, values);
        return this;
    }

    public ResponseRequestContextAddon<R> addHeaderValue(String name, String value) {
        if (this.isHeadersSent()) {
            logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (value == null) {
            return this;
        }
        this.addHeaderValues(name, Arrays.asList(value));
        return this;
    }

    public ResponseRequestContextAddon<R> addHeaderValues(String name, List<String> values) {
        if (this.isHeadersSent()) {
            logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (values == null) {
            return this;
        }
        List<String> currentValues = this.getHeaders().get(name);
        if (currentValues == null) {
            currentValues = new ArrayList<String>();
            this.getHeaders().put(name, currentValues);
        }
        currentValues.addAll(values);
        return this;
    }

    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            Map headersFromServer = this.getServer().getResponseHeaders(this.getExchange());
            TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            if (headersFromServer != null) {
                treeMap.putAll(headersFromServer);
            }
            this.headers = treeMap;
        }
        return this.headers;
    }

    public List<String> getHeader(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return new LinkedList<String>();
        }
        List<String> values = this.getHeaders().get(name);
        if (values == null) {
            values = new LinkedList<String>();
        }
        return values;
    }

    public String getHeaderFirst(String name) {
        List<String> values = this.getHeader(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public boolean isHeadersSent() {
        return this.getServer().isResponseHeadersSent(this.getExchange());
    }

    protected void setIsShouldGzip(boolean isShouldGzip) {
        GzipOption gzipOption = this.getGzipOption();
        if (gzipOption != GzipOption.DEFAULT) {
            logger.warn("Can't turn on/off the gzip feature since the GzipOption is " + gzipOption);
            return;
        }
        try {
            if (this.isHeadersSent()) {
                if (this.isShouldGzip != null && this.isShouldGzip.getBoolean() != isShouldGzip) {
                    logger.warn("Can't turn on/off the gzip feature since headers are already sent.");
                }
                return;
            }
            if (this.isShouldGzip != null && this.isShouldGzip.getBoolean() && !isShouldGzip) {
                this.byteArrayOutputStreamIn.reset();
                this.getGzipBuffer().close();
                ByteArrayOutputStream buffer = this.getBuffer();
                if (buffer.size() > 0) {
                    GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(buffer.toByteArray()));
                    byte[] ungzipedBytes = IOUtils.toByteArray((InputStream)gzipInputStream);
                    this.byteArrayOutputStreamIn.write(ungzipedBytes);
                }
                this.gzipOutputStream = null;
            }
            this.isShouldGzip = Bool.from((boolean)isShouldGzip);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected boolean isShouldGzip() {
        GzipOption gzipOption = this.getGzipOption();
        if (gzipOption == GzipOption.FORCE) {
            return true;
        }
        if (gzipOption == GzipOption.DISABLE) {
            return false;
        }
        if (gzipOption != GzipOption.DEFAULT) {
            throw new RuntimeException("Unimplemented : " + gzipOption);
        }
        if (this.isShouldGzip == null) {
            String responseContentType;
            boolean hasGzipAcceptHeader = false;
            List acceptEncodings = this.getRequestContext().request().getHeader("Accept-Encoding");
            if (acceptEncodings != null) {
                for (String acceptEncoding : acceptEncodings) {
                    if (acceptEncoding == null || !acceptEncoding.contains("gzip")) continue;
                    hasGzipAcceptHeader = true;
                    break;
                }
            }
            if ((responseContentType = this.getContentType()) == null) {
                String path = this.getRequestContext().request().getRequestPath();
                responseContentType = this.getSpincastUtils().getMimeTypeFromPath(path);
            }
            if (responseContentType != null) {
                if (!this.getSpincastUtils().isContentTypeToSkipGziping(responseContentType)) {
                    if (!hasGzipAcceptHeader) {
                        logger.debug("No gzip 'Accept-Encoding' header, we won't gzip the response.");
                        this.setIsShouldGzip(false);
                    } else {
                        this.setIsShouldGzip(true);
                    }
                }
            } else {
                this.setIsShouldGzip(false);
            }
        }
        if (this.isShouldGzip == null) {
            return false;
        }
        return this.isShouldGzip.getBoolean();
    }

    public void end() {
        this.flush(true);
    }

    public void flush() {
        this.flush(false);
    }

    public void flush(boolean close) {
        try {
            byte[] bytesToFlush;
            if (this.isClosed()) {
                return;
            }
            if (!this.isRequestSizeValidated() && !this.isHeadersSent()) {
                this.setRequestSizeValidated(true);
                boolean requestSizeOk = this.getServer().forceRequestSizeValidation(this.getExchange());
                if (!requestSizeOk) {
                    this.resetEverything();
                    this.setStatusCode(413);
                }
            }
            if (this.getResourcesToPush().size() > 0) {
                this.getServer().push(this.getExchange(), this.getResourcesToPush());
            }
            ByteArrayOutputStream buffer = this.getBuffer();
            if (!this.isHeadersSent()) {
                this.getServer().setResponseStatusCode(this.getExchange(), this.getStatusCode());
                String responseContentType = this.getContentType();
                if (responseContentType == null) {
                    String mimeType = this.getSpincastUtils().getMimeTypeFromPath(this.getRequestContext().request().getRequestPath());
                    responseContentType = mimeType != null ? mimeType : (this.isResponseCharactersBased() || buffer.size() == 0 ? ContentTypeDefaults.TEXT.getMainVariationWithUtf8Charset() : ContentTypeDefaults.BINARY.getMainVariation());
                    this.setContentType(responseContentType);
                }
                this.setHeader("Content-Type", responseContentType);
                this.getServer().setResponseStatusCode(this.getExchange(), this.getStatusCode());
                if (close && !this.isShouldGzip()) {
                    this.setHeader("Content-Length", "" + buffer.size());
                }
                if (this.getSpincastConfig().isEnableCookiesValidator()) {
                    this.setCookie(this.createCookiesValidatorCookie());
                }
                this.getServer().addCookies(this.getExchange(), this.getCookiesAdded());
                if (this.isShouldGzip()) {
                    this.setHeader("Content-Encoding", "gzip");
                    this.setHeader("Transfer-Encoding", "chunked");
                }
                this.getServer().setResponseHeaders(this.getExchange(), this.getHeaders());
            }
            if (this.isShouldGzip()) {
                this.getGzipBuffer().write(buffer.toByteArray());
                this.getGzipBuffer().flush();
                if (close) {
                    this.getGzipBuffer().close();
                }
                bytesToFlush = this.getOut().toByteArray();
                this.getOut().reset();
            } else {
                bytesToFlush = buffer.toByteArray();
            }
            buffer.reset();
            this.getServer().flushBytes(this.getExchange(), bytesToFlush, close);
        }
        catch (Exception ex) {
            logger.error("Error with request " + this.getRequestContext().request().getFullUrl());
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    private Cookie createCookiesValidatorCookie() {
        Cookie cookie = this.createCookie(this.getSpincastConfig().getCookiesValidatorCookieName());
        cookie.setValue("1");
        cookie.setExpiresUsingMaxAge(31536000);
        return cookie;
    }

    public ResponseRequestContextAddon<R> setCacheSeconds(int cacheSeconds) {
        return this.setCacheSeconds(cacheSeconds, false);
    }

    public ResponseRequestContextAddon<R> setCacheSeconds(int cacheSeconds, boolean isPrivateCache) {
        if (cacheSeconds <= 0) {
            logger.warn("A number of seconds below 1 doesn't send any cache headers: " + cacheSeconds);
            return this;
        }
        if (this.isHeadersSent()) {
            logger.error("The headers are sent, you can't add cache headers.");
            return this;
        }
        String cacheControl = "max-age=" + cacheSeconds;
        cacheControl = isPrivateCache ? "private, " + cacheControl : "public, " + cacheControl;
        this.setHeader("Cache-Control", cacheControl);
        return this;
    }

    public void setModel(JsonObject model) {
        this.responseModel = model;
    }

    public void addAlert(AlertLevel alertType, String alertText) {
        Map spincastMap = this.getRequestContext().templating().getSpincastReservedMap();
        ArrayList<Alert> alerts = (ArrayList<Alert>)spincastMap.get("alerts");
        if (alerts == null) {
            alerts = new ArrayList<Alert>();
            spincastMap.put("alerts", alerts);
        }
        alerts.add(this.createAlert(alertType, alertText));
    }

    protected Alert createAlert(AlertLevel alertType, String alertText) {
        return new AlertDefault(alertType, alertText);
    }

    public Map<String, Cookie> getCookiesAdded() {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, Cookie>();
        }
        return this.cookies;
    }

    public Cookie getCookieAdded(String name) {
        return this.getCookiesAdded().get(name);
    }

    public void setCookie(Cookie cookie) {
        boolean valid = this.validateCookie(cookie);
        if (!valid) {
            return;
        }
        this.getCookiesAdded().put(cookie.getName(), cookie);
    }

    public void setCookieSession(String name, String value) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value);
        this.setCookie(cookie);
    }

    public void setCookieSessionSafe(String name, String value) {
        this.addCookieSafe(name, value, null);
    }

    public void setCookie1year(String name, String value) {
        this.setCookie(name, value, 31536000);
    }

    public void setCookie1yearSafe(String name, String value) {
        this.addCookieSafe(name, value, 31536000);
    }

    public void setCookie10years(String name, String value) {
        this.setCookie(name, value, 315360000);
    }

    public void setCookie10yearsSafe(String name, String value) {
        this.addCookieSafe(name, value, 315360000);
    }

    public void setCookie(String name, String value, int nbrSecondsToLive) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value);
        cookie.setExpiresUsingMaxAge(nbrSecondsToLive);
        this.setCookie(cookie);
    }

    public void setCookie(String name, String value, int nbrSecondsToLive, boolean httpOnly) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value);
        cookie.setExpiresUsingMaxAge(nbrSecondsToLive);
        cookie.setHttpOnly(httpOnly);
        this.setCookie(cookie);
    }

    protected void addCookieSafe(String name, String value, Integer nbrSecondsToLive) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value);
        if (nbrSecondsToLive != null) {
            cookie.setExpiresUsingMaxAge(nbrSecondsToLive.intValue());
        }
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        cookie.setSameSite(CookieSameSite.LAX);
        this.setCookie(cookie);
    }

    public void setCookie(String name, String value, String path, String domain, Date expires, boolean secure, boolean httpOnly, CookieSameSite cookieSameSite, boolean discard, int version) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value, path, domain, expires, secure, httpOnly, cookieSameSite, discard, version);
        this.setCookie(cookie);
    }

    protected boolean validateCookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "Can't add a NULL cookie");
        String name = cookie.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new RuntimeException("A cookie can't have an empty name");
        }
        return true;
    }

    public void deleteCookie(String name) {
        if (name == null) {
            return;
        }
        Cookie cookie = this.createCookie(name);
        cookie.setExpires(DateUtils.addYears((Date)new Date(), (int)-1));
        this.setCookie(cookie);
    }

    public void deleteAllCookiesUserHas() {
        this.getCookiesAdded().clear();
        for (String cookieName : this.getRequestContext().request().getCookiesValues().keySet()) {
            this.deleteCookie(cookieName);
        }
    }

    public Cookie createCookie(String name) {
        return this.getCookieFactory().createCookie(name);
    }

    public void addForm(Form form) {
        this.addForm(form, this.getSpincastConfig().getValidationElementDefaultName());
    }

    public void addForm(Form form, String validationElementName) {
        this.getModel().set(form.getFormName(), (Object)form);
        Object validationElementObj = this.getModel().getObject(validationElementName);
        if (validationElementObj == null) {
            validationElementObj = this.getJsonManager().create();
            this.getModel().set(validationElementName, validationElementObj);
        } else if (!(validationElementObj instanceof JsonObject)) {
            throw new RuntimeException("The '" + validationElementName + "' element already exists on the response's model but is not a JsonObject! It can't be used as the validation element : " + validationElementObj);
        }
        JsonObject validationElement = (JsonObject)validationElementObj;
        form.setValidationObject(validationElement);
    }

    public Set<ResourceToPush> getResourcesToPush() {
        if (this.resourcesToPush == null) {
            this.resourcesToPush = new HashSet<ResourceToPush>();
        }
        return this.resourcesToPush;
    }

    public ResponseRequestContextAddon<R> push(HttpMethod httpMethod, String path, Map<String, List<String>> requestHeaders) {
        Objects.requireNonNull(httpMethod, "The httpMethod can't be NULL");
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new RuntimeException("The path to the resource to push can't be empty.");
        }
        path = ((String)path).startsWith("/") ? path : "/" + (String)path;
        path = this.tweakResourceToPushPath((String)path);
        this.getResourcesToPush().add(new ResourceToPush(httpMethod, (String)path, requestHeaders));
        return this;
    }

    protected String tweakResourceToPushPath(String path) {
        path = path.replace("${cacheBuster}", this.getSpincastUtils().getCacheBusterCode());
        return path;
    }
}

