/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.annotation.Nullable;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.routing.IHandler;
import org.spincast.core.routing.IStaticResource;
import org.spincast.core.routing.IStaticResourceCorsConfig;
import org.spincast.core.routing.StaticResourceType;

public class StaticResource<R extends IRequestContext<?>>
implements IStaticResource<R> {
    private final StaticResourceType staticResourceType;
    private final String urlPath;
    private final String resourcePath;
    private final IHandler<R> generator;
    private final IStaticResourceCorsConfig corsConfig;

    @AssistedInject
    public StaticResource(@Assisted StaticResourceType staticResourceType, @Assisted(value="url") String urlPath, @Assisted(value="path") String resourcePath, @Assisted @Nullable IHandler<R> generator, @Assisted @Nullable IStaticResourceCorsConfig corsConfig) {
        this.staticResourceType = staticResourceType;
        this.urlPath = urlPath;
        this.resourcePath = resourcePath;
        this.generator = generator;
        this.corsConfig = corsConfig;
    }

    public StaticResourceType getStaticResourceType() {
        return this.staticResourceType;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean isCanBeGenerated() {
        return this.getGenerator() != null;
    }

    public IHandler<R> getGenerator() {
        return this.generator;
    }

    public IStaticResourceCorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    public boolean isFileResource() {
        return this.getStaticResourceType() == StaticResourceType.FILE || this.getStaticResourceType() == StaticResourceType.FILE_FROM_CLASSPATH;
    }

    public boolean isDirResource() {
        return !this.isFileResource();
    }

    public boolean isClasspath() {
        return this.getStaticResourceType() == StaticResourceType.FILE_FROM_CLASSPATH || this.getStaticResourceType() == StaticResourceType.DIRECTORY_FROM_CLASSPATH;
    }

    public boolean isFileSytem() {
        return !this.isClasspath();
    }
}

