/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Set;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.routing.IHandler;
import org.spincast.core.routing.IRouter;
import org.spincast.core.routing.IStaticResource;
import org.spincast.core.routing.IStaticResourceBuilder;
import org.spincast.core.routing.IStaticResourceCorsConfig;
import org.spincast.core.routing.StaticResourceType;
import org.spincast.plugins.routing.IStaticResourceCorsConfigFactory;
import org.spincast.plugins.routing.IStaticResourceFactory;

public class StaticResourceBuilder<R extends IRequestContext<?>>
implements IStaticResourceBuilder<R> {
    private final IRouter<R> router;
    private final boolean isDir;
    private String url = null;
    private String path = null;
    private boolean isClasspath = false;
    private IStaticResourceCorsConfig corsConfig;
    private IHandler<R> generator;
    private final IStaticResourceFactory<R> staticResourceFactory;
    private final IStaticResourceCorsConfigFactory staticResourceCorsConfigFactory;

    @AssistedInject
    public StaticResourceBuilder(@Assisted boolean isDir, IStaticResourceFactory<R> staticResourceFactory, IStaticResourceCorsConfigFactory staticResourceCorsConfigFactory) {
        this(null, isDir, staticResourceFactory, staticResourceCorsConfigFactory);
    }

    @AssistedInject
    public StaticResourceBuilder(@Assisted IRouter<R> router, @Assisted boolean isDir, IStaticResourceFactory<R> staticResourceFactory, IStaticResourceCorsConfigFactory staticResourceCorsConfigFactory) {
        this.router = router;
        this.isDir = isDir;
        this.staticResourceFactory = staticResourceFactory;
        this.staticResourceCorsConfigFactory = staticResourceCorsConfigFactory;
    }

    protected boolean isDir() {
        return this.isDir;
    }

    protected IRouter<R> getRouter() {
        return this.router;
    }

    protected IStaticResourceFactory<R> getStaticResourceFactory() {
        return this.staticResourceFactory;
    }

    protected IStaticResourceCorsConfigFactory getStaticResourceCorsConfigFactory() {
        return this.staticResourceCorsConfigFactory;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isClasspath() {
        return this.isClasspath;
    }

    public IHandler<R> getGenerator() {
        return this.generator;
    }

    public IStaticResourceCorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    public IStaticResourceBuilder<R> url(String url) {
        this.url = url;
        return this;
    }

    public IStaticResourceBuilder<R> classpath(String path) {
        this.path = path;
        this.isClasspath = true;
        return this;
    }

    public IStaticResourceBuilder<R> fileSystem(String path) {
        this.path = path;
        this.isClasspath = false;
        return this;
    }

    public IStaticResourceBuilder<R> cors() {
        return this.cors(this.getCorsDefaultAllowedOrigins(), this.getCorsDefaultExtraHeadersAllowedToBeRead(), this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public IStaticResourceBuilder<R> cors(Set<String> allowedOrigins) {
        return this.cors(allowedOrigins, this.getCorsDefaultExtraHeadersAllowedToBeRead(), this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public IStaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead) {
        return this.cors(allowedOrigins, extraHeadersAllowedToBeRead, this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public IStaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent) {
        return this.cors(allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public IStaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies) {
        return this.cors(allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, this.getCorsDefaultMaxAgeInSeconds());
    }

    public IStaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, int maxAgeInSeconds) {
        this.corsConfig = this.getStaticResourceCorsConfigFactory().create(allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, maxAgeInSeconds);
        return this;
    }

    public void save() {
        this.save(null);
    }

    public void save(IHandler<R> generator) {
        if (this.getRouter() == null) {
            throw new RuntimeException("No router specified, can't save the static resource!");
        }
        if (this.isClasspath() && generator != null) {
            throw new RuntimeException("A resource generator can only be specified when a file system path is used, not a classpath path.");
        }
        this.generator = generator;
        if (this.getUrl() == null) {
            throw new RuntimeException("The URL to the resource must be specified!");
        }
        if (this.getPath() == null) {
            throw new RuntimeException("A classpath or a file system path must be specified!");
        }
        IStaticResource<R> staticResource = this.create();
        this.getRouter().addStaticResource(staticResource);
    }

    public IStaticResource<R> create() {
        StaticResourceType type = this.isDir() ? (this.isClasspath() ? StaticResourceType.DIRECTORY_FROM_CLASSPATH : StaticResourceType.DIRECTORY) : (this.isClasspath() ? StaticResourceType.FILE_FROM_CLASSPATH : StaticResourceType.FILE);
        IStaticResource<R> staticResource = this.getStaticResourceFactory().create(type, this.getUrl(), this.getPath(), this.getGenerator(), this.getCorsConfig());
        return staticResource;
    }

    protected int getCorsDefaultMaxAgeInSeconds() {
        return 86400;
    }

    protected Set<String> getCorsDefaultAllowedOrigins() {
        return Sets.newHashSet((Object[])new String[]{"*"});
    }

    protected Set<String> getCorsDefaultExtraHeadersAllowedToBeRead() {
        return null;
    }

    protected Set<String> getCorsDefaultExtraHeadersAllowedToBeSent() {
        return Sets.newHashSet((Object[])new String[]{"*"});
    }

    protected boolean getCorsDefaultIsCookiesAllowed() {
        return true;
    }
}

