/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spincast.core.routing.IETag;
import org.spincast.core.routing.IETagFactory;
import org.spincast.plugins.routing.ETag;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class ETagFactory
implements IETagFactory {
    protected static final Pattern ETAG_HEADER_VALUE_PATTERN = Pattern.compile("^(\\*)$|^([wW]/)?\"([^\"]*)\"$");

    @Inject
    public ETagFactory() {
    }

    public IETag create(String tag) {
        return this.create(tag, false);
    }

    public IETag create(String tag, boolean isWeak) {
        return new ETag(tag, isWeak);
    }

    public IETag create(String tag, boolean isWeak, boolean isWildcard) {
        return new ETag(tag, isWeak, isWildcard);
    }

    public IETag deserializeHeaderValue(String etagHeaderValue) {
        if (StringUtils.isBlank((CharSequence)etagHeaderValue)) {
            throw new RuntimeException("The ETag value can't be empty.");
        }
        Matcher matcher = ETAG_HEADER_VALUE_PATTERN.matcher(etagHeaderValue = etagHeaderValue.trim());
        if (matcher.find()) {
            boolean isWeak = false;
            if (matcher.group(2) != null) {
                isWeak = true;
            }
            String tag = "";
            boolean isWildcard = false;
            if (matcher.group(1) != null) {
                isWildcard = true;
            } else {
                tag = matcher.group(3);
            }
            return new ETag(tag, isWeak, isWildcard);
        }
        throw new RuntimeException("Invalid ETag header value format: " + etagHeaderValue);
    }
}

