/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.routing.IHandler;
import org.spincast.core.routing.IRouter;
import org.spincast.core.websocket.IWebsocketContext;
import org.spincast.core.websocket.IWebsocketController;
import org.spincast.core.websocket.IWebsocketRoute;
import org.spincast.core.websocket.IWebsocketRouteBuilder;
import org.spincast.plugins.routing.IWebsocketRouteFactory;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class WebsocketRouteBuilder<R extends IRequestContext<?>, W extends IWebsocketContext<?>>
implements IWebsocketRouteBuilder<R, W> {
    private final IWebsocketRouteFactory<R, W> websocketRouteFactory;
    private final IRouter<R, W> router;
    private String path;
    private String id;
    private List<IHandler<R>> beforeFilters;
    private IWebsocketController<R, W> websocketController;
    private Set<String> beforeFilterIdsToSkip;

    @AssistedInject
    public WebsocketRouteBuilder(IWebsocketRouteFactory<R, W> websocketRouteFactory) {
        this(null, websocketRouteFactory);
    }

    @AssistedInject
    public WebsocketRouteBuilder(@Assisted IRouter<R, W> router, IWebsocketRouteFactory<R, W> websocketRouteFactory) {
        this.router = router;
        this.websocketRouteFactory = websocketRouteFactory;
    }

    protected IWebsocketRouteFactory<R, W> getWebsocketRouteFactory() {
        return this.websocketRouteFactory;
    }

    protected IRouter<R, W> getRouter() {
        return this.router;
    }

    public String getPath() {
        return this.path;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getBeforeFilterIdsToSkip() {
        if (this.beforeFilterIdsToSkip == null) {
            this.beforeFilterIdsToSkip = new HashSet<String>();
        }
        return this.beforeFilterIdsToSkip;
    }

    public IWebsocketController<R, W> getWebsocketController() {
        return this.websocketController;
    }

    public IWebsocketRouteBuilder<R, W> path(String path) {
        this.path = path;
        return this;
    }

    public IWebsocketRouteBuilder<R, W> id(String id) {
        this.id = id;
        return this;
    }

    public IWebsocketRouteBuilder<R, W> before(IHandler<R> beforeFilter) {
        Objects.requireNonNull(beforeFilter, "beforeFilter can't be NULL");
        this.getBeforeFilters().add(beforeFilter);
        return this;
    }

    public List<IHandler<R>> getBeforeFilters() {
        if (this.beforeFilters == null) {
            this.beforeFilters = new ArrayList<IHandler<R>>();
        }
        return this.beforeFilters;
    }

    public void save(IWebsocketController<R, W> websocketController) {
        if (this.getRouter() == null) {
            throw new RuntimeException("No router specified, can't save the Websocket route!");
        }
        IWebsocketRoute<R, W> websocketRoute = this.create(websocketController);
        this.getRouter().addWebsocketRoute(websocketRoute);
    }

    public IWebsocketRoute<R, W> create(IWebsocketController<R, W> websocketController) {
        this.websocketController = websocketController;
        IWebsocketRoute<R, W> websocketRoute = this.getWebsocketRouteFactory().createRoute(this.getId(), this.getPath(), this.getBeforeFilters(), this.getBeforeFilterIdsToSkip(), websocketController);
        return websocketRoute;
    }

    public IWebsocketRouteBuilder<R, W> skip(String beforeFilterId) {
        if (StringUtils.isBlank((CharSequence)beforeFilterId)) {
            throw new RuntimeException("The beforeFilterId can't be empty.");
        }
        this.getBeforeFilterIdsToSkip().add(beforeFilterId);
        return this;
    }
}

