/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.File;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.routing.IHandler;
import org.spincast.core.routing.IRouter;
import org.spincast.core.routing.IStaticResource;
import org.spincast.core.routing.IStaticResourceBuilder;
import org.spincast.core.routing.IStaticResourceCacheConfig;
import org.spincast.core.routing.IStaticResourceCorsConfig;
import org.spincast.core.routing.IStaticResourceFactory;
import org.spincast.core.routing.StaticResourceType;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.websocket.IWebsocketContext;
import org.spincast.plugins.routing.ISpincastRouterConfig;
import org.spincast.plugins.routing.IStaticResourceCacheConfigFactory;
import org.spincast.plugins.routing.IStaticResourceCorsConfigFactory;

public class StaticResourceBuilder<R extends IRequestContext<?>, W extends IWebsocketContext<?>>
implements IStaticResourceBuilder<R> {
    protected final Logger logger = LoggerFactory.getLogger(StaticResourceBuilder.class);
    private final ISpincastConfig spincastConfig;
    private final ISpincastUtils spincastUtils;
    private final IRouter<R, W> router;
    private final boolean isDir;
    private String url = null;
    private String path = null;
    private boolean isClasspath = false;
    private IStaticResourceCorsConfig corsConfig;
    private IStaticResourceCacheConfig cacheConfig;
    private IHandler<R> generator;
    private final IStaticResourceFactory<R> staticResourceFactory;
    private final IStaticResourceCorsConfigFactory staticResourceCorsConfigFactory;
    private final IStaticResourceCacheConfigFactory staticResourceCacheConfigFactory;
    private final ISpincastRouterConfig spincastRouterConfig;

    @AssistedInject
    public StaticResourceBuilder(@Assisted boolean isDir, IStaticResourceFactory<R> staticResourceFactory, IStaticResourceCorsConfigFactory staticResourceCorsConfigFactory, IStaticResourceCacheConfigFactory staticResourceCacheConfigFactory, ISpincastConfig spincastConfig, ISpincastUtils spincastUtils, ISpincastRouterConfig spincastRouterConfig) {
        this(null, isDir, staticResourceFactory, staticResourceCorsConfigFactory, staticResourceCacheConfigFactory, spincastConfig, spincastUtils, spincastRouterConfig);
    }

    @AssistedInject
    public StaticResourceBuilder(@Assisted IRouter<R, W> router, @Assisted boolean isDir, IStaticResourceFactory<R> staticResourceFactory, IStaticResourceCorsConfigFactory staticResourceCorsConfigFactory, IStaticResourceCacheConfigFactory staticResourceCacheConfigFactory, ISpincastConfig spincastConfig, ISpincastUtils spincastUtils, ISpincastRouterConfig spincastRouterConfig) {
        this.router = router;
        this.isDir = isDir;
        this.staticResourceFactory = staticResourceFactory;
        this.staticResourceCorsConfigFactory = staticResourceCorsConfigFactory;
        this.staticResourceCacheConfigFactory = staticResourceCacheConfigFactory;
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
        this.spincastRouterConfig = spincastRouterConfig;
    }

    protected boolean isDir() {
        return this.isDir;
    }

    protected IRouter<R, W> getRouter() {
        return this.router;
    }

    protected IStaticResourceFactory<R> getStaticResourceFactory() {
        return this.staticResourceFactory;
    }

    protected IStaticResourceCorsConfigFactory getStaticResourceCorsConfigFactory() {
        return this.staticResourceCorsConfigFactory;
    }

    protected IStaticResourceCacheConfigFactory getStaticResourceCacheConfigFactory() {
        return this.staticResourceCacheConfigFactory;
    }

    protected ISpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected ISpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected ISpincastRouterConfig getSpincastRouterConfig() {
        return this.spincastRouterConfig;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isClasspath() {
        return this.isClasspath;
    }

    public IHandler<R> getGenerator() {
        return this.generator;
    }

    public IStaticResourceCorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    public IStaticResourceCacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public IStaticResourceBuilder<R> url(String url) {
        this.url = url;
        return this;
    }

    public IStaticResourceBuilder<R> classpath(String path) {
        this.path = path;
        this.isClasspath = true;
        return this;
    }

    public IStaticResourceBuilder<R> pathAbsolute(String absolutePath) {
        this.path = absolutePath;
        this.isClasspath = false;
        return this;
    }

    public IStaticResourceBuilder<R> pathRelative(String relativePath) {
        try {
            this.path = new File(this.getSpincastConfig().getSpincastWritableDir(), relativePath).getCanonicalPath();
            this.isClasspath = false;
            return this;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public IStaticResourceBuilder<R> cors() {
        return this.cors(this.getCorsDefaultAllowedOrigins(), this.getCorsDefaultExtraHeadersAllowedToBeRead(), this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public IStaticResourceBuilder<R> cors(Set<String> allowedOrigins) {
        return this.cors(allowedOrigins, this.getCorsDefaultExtraHeadersAllowedToBeRead(), this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public IStaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead) {
        return this.cors(allowedOrigins, extraHeadersAllowedToBeRead, this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public IStaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent) {
        return this.cors(allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public IStaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies) {
        return this.cors(allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, this.getCorsDefaultMaxAgeInSeconds());
    }

    public IStaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, int maxAgeInSeconds) {
        this.corsConfig = this.getStaticResourceCorsConfigFactory().create(allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, maxAgeInSeconds);
        return this;
    }

    protected int getCorsDefaultMaxAgeInSeconds() {
        return 86400;
    }

    protected Set<String> getCorsDefaultAllowedOrigins() {
        return Sets.newHashSet((Object[])new String[]{"*"});
    }

    protected Set<String> getCorsDefaultExtraHeadersAllowedToBeRead() {
        return null;
    }

    protected Set<String> getCorsDefaultExtraHeadersAllowedToBeSent() {
        return Sets.newHashSet((Object[])new String[]{"*"});
    }

    protected boolean getCorsDefaultIsCookiesAllowed() {
        return true;
    }

    protected boolean isCachePrivateDefault() {
        return false;
    }

    protected Integer getCacheCdnSecondsDefault() {
        return null;
    }

    public IStaticResourceBuilder<R> cache(int seconds) {
        return this.cache(seconds, this.isCachePrivateDefault());
    }

    public IStaticResourceBuilder<R> cache(int seconds, boolean isCachePrivate) {
        return this.cache(seconds, isCachePrivate, this.getCacheCdnSecondsDefault());
    }

    public IStaticResourceBuilder<R> cache(int seconds, boolean isCachePrivate, Integer cdnSeconds) {
        this.cacheConfig = this.getStaticResourceCacheConfigFactory().create(seconds, isCachePrivate, cdnSeconds);
        return this;
    }

    public void save() {
        this.save(null);
    }

    public void save(IHandler<R> generator) {
        if (this.getRouter() == null) {
            throw new RuntimeException("No router specified, can't save the static resource!");
        }
        if (this.isClasspath() && generator != null) {
            throw new RuntimeException("A resource generator can only be specified when a file system path is used, not a classpath path.");
        }
        this.generator = generator;
        if (this.getUrl() == null) {
            throw new RuntimeException("The URL to the resource must be specified!");
        }
        if (this.getPath() == null) {
            throw new RuntimeException("A classpath or a file system path must be specified!");
        }
        IStaticResource<R> staticResource = this.create();
        this.getRouter().addStaticResource(staticResource);
    }

    public IStaticResource<R> create() {
        StaticResourceType type = this.isDir() ? (this.isClasspath() ? StaticResourceType.DIRECTORY_FROM_CLASSPATH : StaticResourceType.DIRECTORY) : (this.isClasspath() ? StaticResourceType.FILE_FROM_CLASSPATH : StaticResourceType.FILE);
        IStaticResourceCacheConfig cacheConfig = this.getCacheConfig();
        if (cacheConfig == null) {
            cacheConfig = this.getDefaultCacheConfig();
        }
        IStaticResource staticResource = this.getStaticResourceFactory().create(type, this.getUrl(), this.getPath(), this.getGenerator(), this.getCorsConfig(), cacheConfig);
        return staticResource;
    }

    protected IStaticResourceCacheConfig getDefaultCacheConfig() {
        return this.getSpincastConfig().getDefaultStaticResourceCacheConfig(this.getGenerator() != null);
    }
}

