/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing.utils;

import java.util.Map;
import org.spincast.plugins.routing.utils.IReplaceDynamicParamsResult;
import org.spincast.plugins.routing.utils.ISpincastRoutingUtils;
import org.spincast.plugins.routing.utils.ReplaceDynamicParamsResult;

public class SpincastRoutingUtils
implements ISpincastRoutingUtils {
    @Override
    public IReplaceDynamicParamsResult replaceDynamicParamsInPath(String path, Map<String, String> dynamicParams) {
        if (path == null) {
            return this.createReplaceDynamicParamsResult(null, false);
        }
        if (dynamicParams != null && dynamicParams.size() > 0) {
            for (Map.Entry<String, String> entry : dynamicParams.entrySet()) {
                String paramName = entry.getKey();
                String paramValue = entry.getValue();
                path = path.replaceAll("(\\$|\\*)\\{" + paramName + "(|:[^\\}]+)\\}", paramValue);
            }
        }
        return this.createReplaceDynamicParamsResult(path, this.isPathContainDynamicParams(path));
    }

    protected IReplaceDynamicParamsResult createReplaceDynamicParamsResult(String path, boolean placeholdersRemaining) {
        return new ReplaceDynamicParamsResult(path, placeholdersRemaining);
    }

    @Override
    public boolean isPathContainDynamicParams(String path) {
        return path.indexOf("${") > -1 || path.indexOf("*{") > -1;
    }
}

