/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.guice.GuiceModuleUtils;
import org.spincast.core.guice.SpincastPluginBase;
import org.spincast.core.routing.Router;
import org.spincast.plugins.routing.SpincastRoutingPluginModule;

public class SpincastRoutingPlugin
extends SpincastPluginBase {
    protected final Logger logger = LoggerFactory.getLogger(SpincastRoutingPlugin.class);
    public static final String PLUGIN_ID = SpincastRoutingPlugin.class.getName();
    private Class<? extends Router<?, ?>> specificRouterImplementationClass;

    public SpincastRoutingPlugin() {
    }

    public SpincastRoutingPlugin(Class<? extends Router<?, ?>> specificRouterImplementationClass) {
        this.specificRouterImplementationClass = specificRouterImplementationClass;
    }

    protected Class<? extends Router<?, ?>> getSpecificRouterImplementationClass() {
        return this.specificRouterImplementationClass;
    }

    public String getId() {
        return PLUGIN_ID;
    }

    public Module apply(Module module) {
        GuiceModuleUtils guiceModuleUtils;
        Set classes;
        Class specificRouterImplementationClass = this.getSpecificRouterImplementationClass();
        if (specificRouterImplementationClass == null && (classes = (guiceModuleUtils = new GuiceModuleUtils(module)).getBoundClassesExtending(Router.class)).size() > 0) {
            Class temp;
            if (classes.size() > 1) {
                String msg = "More than one custom implementations of " + Router.class.getName() + " has been found. You'll have to pass the implementation to use the constructor of this plugin to remove the ambiguity about which one to use. Bindings found :\n";
                for (Class clazz : classes) {
                    msg = msg + "- " + clazz.getName() + "\n";
                }
                throw new RuntimeException(msg);
            }
            specificRouterImplementationClass = temp = (Class)classes.iterator().next();
        }
        Module pluginModule = this.getPluginModule(specificRouterImplementationClass);
        this.setContextTypes(pluginModule);
        module = Modules.override((Module[])new Module[]{module}).with(new Module[]{pluginModule});
        return module;
    }

    protected Module getPluginModule(Class<? extends Router<?, ?>> specificRouterImplementationClass) {
        return new SpincastRoutingPluginModule(specificRouterImplementationClass);
    }
}

