/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.File;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.Router;
import org.spincast.core.routing.StaticResource;
import org.spincast.core.routing.StaticResourceBuilder;
import org.spincast.core.routing.StaticResourceCacheConfig;
import org.spincast.core.routing.StaticResourceCorsConfig;
import org.spincast.core.routing.StaticResourceFactory;
import org.spincast.core.routing.StaticResourceType;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.plugins.routing.SpincastRouterConfig;
import org.spincast.plugins.routing.StaticResourceCacheConfigFactory;
import org.spincast.plugins.routing.StaticResourceCorsConfigFactory;

public class StaticResourceBuilderDefault<R extends RequestContext<?>, W extends WebsocketContext<?>>
implements StaticResourceBuilder<R> {
    protected final Logger logger = LoggerFactory.getLogger(StaticResourceBuilderDefault.class);
    private final SpincastConfig spincastConfig;
    private final SpincastUtils spincastUtils;
    private final Router<R, W> router;
    private final boolean isDir;
    private String url = null;
    private String path = null;
    private boolean isClasspath = false;
    private StaticResourceCorsConfig corsConfig;
    private StaticResourceCacheConfig cacheConfig;
    private Handler<R> generator;
    private boolean ignoreQueryString;
    private final StaticResourceFactory<R> staticResourceFactory;
    private final StaticResourceCorsConfigFactory staticResourceCorsConfigFactory;
    private final StaticResourceCacheConfigFactory staticResourceCacheConfigFactory;
    private final SpincastRouterConfig spincastRouterConfig;

    @AssistedInject
    public StaticResourceBuilderDefault(@Assisted boolean isDir, StaticResourceFactory<R> staticResourceFactory, StaticResourceCorsConfigFactory staticResourceCorsConfigFactory, StaticResourceCacheConfigFactory staticResourceCacheConfigFactory, SpincastConfig spincastConfig, SpincastUtils spincastUtils, SpincastRouterConfig spincastRouterConfig) {
        this(null, isDir, staticResourceFactory, staticResourceCorsConfigFactory, staticResourceCacheConfigFactory, spincastConfig, spincastUtils, spincastRouterConfig);
    }

    @AssistedInject
    public StaticResourceBuilderDefault(@Assisted Router<R, W> router, @Assisted boolean isDir, StaticResourceFactory<R> staticResourceFactory, StaticResourceCorsConfigFactory staticResourceCorsConfigFactory, StaticResourceCacheConfigFactory staticResourceCacheConfigFactory, SpincastConfig spincastConfig, SpincastUtils spincastUtils, SpincastRouterConfig spincastRouterConfig) {
        this.router = router;
        this.isDir = isDir;
        this.staticResourceFactory = staticResourceFactory;
        this.staticResourceCorsConfigFactory = staticResourceCorsConfigFactory;
        this.staticResourceCacheConfigFactory = staticResourceCacheConfigFactory;
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
        this.spincastRouterConfig = spincastRouterConfig;
    }

    protected boolean isDir() {
        return this.isDir;
    }

    protected Router<R, W> getRouter() {
        return this.router;
    }

    protected StaticResourceFactory<R> getStaticResourceFactory() {
        return this.staticResourceFactory;
    }

    protected StaticResourceCorsConfigFactory getStaticResourceCorsConfigFactory() {
        return this.staticResourceCorsConfigFactory;
    }

    protected StaticResourceCacheConfigFactory getStaticResourceCacheConfigFactory() {
        return this.staticResourceCacheConfigFactory;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected SpincastRouterConfig getSpincastRouterConfig() {
        return this.spincastRouterConfig;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isClasspath() {
        return this.isClasspath;
    }

    public Handler<R> getGenerator() {
        return this.generator;
    }

    public StaticResourceCorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    public StaticResourceCacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public boolean isIgnoreQueryString() {
        return this.ignoreQueryString;
    }

    public StaticResourceBuilder<R> url(String url) {
        this.url = url;
        return this;
    }

    public StaticResourceBuilder<R> classpath(String path) {
        this.path = path;
        this.isClasspath = true;
        return this;
    }

    public StaticResourceBuilder<R> pathAbsolute(String absolutePath) {
        this.path = absolutePath;
        this.isClasspath = false;
        return this;
    }

    public StaticResourceBuilder<R> pathRelative(String relativePath) {
        try {
            this.path = new File(this.getSpincastConfig().getTempDir(), relativePath).getCanonicalPath();
            this.isClasspath = false;
            return this;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public StaticResourceBuilder<R> cors() {
        return this.cors(this.getCorsDefaultAllowedOrigins(), this.getCorsDefaultExtraHeadersAllowedToBeRead(), this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public StaticResourceBuilder<R> cors(Set<String> allowedOrigins) {
        return this.cors(allowedOrigins, this.getCorsDefaultExtraHeadersAllowedToBeRead(), this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public StaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead) {
        return this.cors(allowedOrigins, extraHeadersAllowedToBeRead, this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public StaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent) {
        return this.cors(allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultMaxAgeInSeconds());
    }

    public StaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies) {
        return this.cors(allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, this.getCorsDefaultMaxAgeInSeconds());
    }

    public StaticResourceBuilder<R> cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, int maxAgeInSeconds) {
        this.corsConfig = this.getStaticResourceCorsConfigFactory().create(allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, maxAgeInSeconds);
        return this;
    }

    protected int getCorsDefaultMaxAgeInSeconds() {
        return 86400;
    }

    protected Set<String> getCorsDefaultAllowedOrigins() {
        return Sets.newHashSet((Object[])new String[]{"*"});
    }

    protected Set<String> getCorsDefaultExtraHeadersAllowedToBeRead() {
        return null;
    }

    protected Set<String> getCorsDefaultExtraHeadersAllowedToBeSent() {
        return Sets.newHashSet((Object[])new String[]{"*"});
    }

    protected boolean getCorsDefaultIsCookiesAllowed() {
        return true;
    }

    protected boolean isCachePrivateDefault() {
        return false;
    }

    protected Integer getCacheCdnSecondsDefault() {
        return null;
    }

    public StaticResourceBuilder<R> cache(int seconds) {
        return this.cache(seconds, this.isCachePrivateDefault());
    }

    public StaticResourceBuilder<R> cache(int seconds, boolean isCachePrivate) {
        return this.cache(seconds, isCachePrivate, this.getCacheCdnSecondsDefault());
    }

    public StaticResourceBuilder<R> cache(int seconds, boolean isCachePrivate, Integer cdnSeconds) {
        this.cacheConfig = this.getStaticResourceCacheConfigFactory().create(seconds, isCachePrivate, cdnSeconds);
        return this;
    }

    public void save() {
        this.save(null);
    }

    public void save(Handler<R> generator) {
        this.save(generator, false);
    }

    public void save(Handler<R> generator, boolean ignoreQueryString) {
        if (this.getRouter() == null) {
            throw new RuntimeException("No router specified, can't save the static resource!");
        }
        if (this.isClasspath() && generator != null) {
            throw new RuntimeException("A resource generator can only be specified when a file system path is used, not a classpath path.");
        }
        this.generator = generator;
        if (this.getUrl() == null) {
            throw new RuntimeException("The URL to the resource must be specified!");
        }
        if (this.getPath() == null) {
            throw new RuntimeException("A classpath or a file system path must be specified!");
        }
        this.ignoreQueryString = ignoreQueryString;
        StaticResource<R> staticResource = this.create();
        this.getRouter().addStaticResource(staticResource);
    }

    public StaticResource<R> create() {
        StaticResourceType type = this.isDir() ? (this.isClasspath() ? StaticResourceType.DIRECTORY_FROM_CLASSPATH : StaticResourceType.DIRECTORY) : (this.isClasspath() ? StaticResourceType.FILE_FROM_CLASSPATH : StaticResourceType.FILE);
        StaticResourceCacheConfig cacheConfig = this.getCacheConfig();
        if (cacheConfig == null) {
            cacheConfig = this.getDefaultCacheConfig();
        }
        StaticResource staticResource = this.getStaticResourceFactory().create(type, this.getUrl(), this.getPath(), this.getGenerator(), this.getCorsConfig(), cacheConfig, this.isIgnoreQueryString());
        return staticResource;
    }

    protected StaticResourceCacheConfig getDefaultCacheConfig() {
        return this.getSpincastConfig().getDefaultStaticResourceCacheConfig(this.getGenerator() != null);
    }
}

