/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.filters.SpincastFilters;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.Route;
import org.spincast.core.routing.RouteBuilder;
import org.spincast.core.routing.Router;
import org.spincast.core.routing.RoutingType;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.plugins.routing.RouteFactory;
import org.spincast.plugins.routing.SpincastRouterConfig;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class RouteBuilderDefault<R extends RequestContext<?>, W extends WebsocketContext<?>>
implements RouteBuilder<R> {
    protected final Logger logger = LoggerFactory.getLogger(RouteBuilderDefault.class);
    private final Router<R, W> router;
    private final RouteFactory<R> routeFactory;
    private final SpincastRouterConfig spincastRouterConfig;
    private final SpincastFilters<R> spincastFilters;
    private final SpincastConfig spincastConfig;
    private Set<HttpMethod> httpMethods;
    private String id = null;
    private String path = null;
    private int position = 0;
    private boolean skipResources = false;
    private Set<RoutingType> routingTypes;
    private List<Handler<R>> beforeFilters;
    private Handler<R> mainHandler;
    private List<Handler<R>> afterFilters;
    private Set<String> acceptedContentTypes;
    private Set<String> filterIdsToSkip;
    private boolean isSpicastCoreRouteOrPluginRoute = false;

    @AssistedInject
    public RouteBuilderDefault(RouteFactory<R> routeFactory, SpincastRouterConfig spincastRouterConfig, SpincastFilters<R> spincastFilters, SpincastConfig spincastConfig) {
        this(null, routeFactory, spincastRouterConfig, spincastFilters, spincastConfig);
    }

    @AssistedInject
    public RouteBuilderDefault(@Assisted Router<R, W> router, RouteFactory<R> routeFactory, SpincastRouterConfig spincastRouterConfig, SpincastFilters<R> spincastFilters, SpincastConfig spincastConfig) {
        this.router = router;
        this.routeFactory = routeFactory;
        this.spincastRouterConfig = spincastRouterConfig;
        this.spincastFilters = spincastFilters;
        this.spincastConfig = spincastConfig;
    }

    protected Router<R, W> getRouter() {
        return this.router;
    }

    protected RouteFactory<R> getRouteFactory() {
        return this.routeFactory;
    }

    protected SpincastRouterConfig getSpincastRouterConfig() {
        return this.spincastRouterConfig;
    }

    protected SpincastFilters<R> getSpincastFilters() {
        return this.spincastFilters;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    public String getId() {
        return this.id;
    }

    public boolean isSpicastCoreRouteOrPluginRoute() {
        return this.isSpicastCoreRouteOrPluginRoute;
    }

    public String getPath() {
        return this.path;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isSkipResources() {
        return this.skipResources;
    }

    public Set<RoutingType> getRoutingTypes() {
        if (this.routingTypes == null) {
            this.routingTypes = new HashSet<RoutingType>();
        }
        return this.routingTypes;
    }

    public Set<HttpMethod> getHttpMethods() {
        if (this.httpMethods == null) {
            this.httpMethods = new HashSet<HttpMethod>();
        }
        return this.httpMethods;
    }

    public List<Handler<R>> getBeforeFilters() {
        if (this.beforeFilters == null) {
            this.beforeFilters = new ArrayList<Handler<R>>();
        }
        return this.beforeFilters;
    }

    public List<Handler<R>> getAfterFilters() {
        if (this.afterFilters == null) {
            this.afterFilters = new ArrayList<Handler<R>>();
        }
        return this.afterFilters;
    }

    public Handler<R> getMainHandler() {
        return this.mainHandler;
    }

    public Set<String> getAcceptedContentTypes() {
        if (this.acceptedContentTypes == null) {
            this.acceptedContentTypes = new HashSet<String>();
        }
        return this.acceptedContentTypes;
    }

    public Set<String> getFilterIdsToSkip() {
        if (this.filterIdsToSkip == null) {
            this.filterIdsToSkip = new HashSet<String>();
        }
        return this.filterIdsToSkip;
    }

    public RouteBuilder<R> id(String id) {
        this.id = id;
        return this;
    }

    public RouteBuilder<R> spicastCoreRouteOrPluginRoute() {
        this.isSpicastCoreRouteOrPluginRoute = true;
        return this;
    }

    public RouteBuilder<R> pos(int position) {
        this.position = position;
        return this;
    }

    public RouteBuilder<R> allRoutingTypes() {
        this.getRoutingTypes().addAll(Sets.newHashSet((Object[])RoutingType.values()));
        return this;
    }

    public RouteBuilder<R> found() {
        this.getRoutingTypes().add(RoutingType.FOUND);
        return this;
    }

    public RouteBuilder<R> notFound() {
        this.getRoutingTypes().add(RoutingType.NOT_FOUND);
        return this;
    }

    public RouteBuilder<R> exception() {
        this.getRoutingTypes().add(RoutingType.EXCEPTION);
        return this;
    }

    public RouteBuilder<R> before(Handler<R> beforeFilter) {
        Objects.requireNonNull(beforeFilter, "beforeFilter can't be NULL");
        this.getBeforeFilters().add(beforeFilter);
        return this;
    }

    public RouteBuilder<R> after(Handler<R> afterFilter) {
        Objects.requireNonNull(afterFilter, "afterFilter can't be NULL");
        this.getAfterFilters().add(afterFilter);
        return this;
    }

    public RouteBuilder<R> acceptAsString(String ... acceptedContentTypes) {
        this.getAcceptedContentTypes().addAll(Sets.newHashSet((Object[])acceptedContentTypes));
        return this;
    }

    public RouteBuilder<R> acceptAsString(Set<String> acceptedContentTypes) {
        Objects.requireNonNull(acceptedContentTypes, "acceptedContentTypes can't be NULL");
        this.getAcceptedContentTypes().addAll(acceptedContentTypes);
        return this;
    }

    public RouteBuilder<R> accept(ContentTypeDefaults ... acceptedContentTypes) {
        if (acceptedContentTypes != null) {
            for (ContentTypeDefaults contentTypeDefault : acceptedContentTypes) {
                this.getAcceptedContentTypes().addAll(contentTypeDefault.getVariations());
            }
        }
        return this;
    }

    public RouteBuilder<R> accept(Set<ContentTypeDefaults> acceptedContentTypes) {
        Objects.requireNonNull(acceptedContentTypes, "acceptedContentTypes can't be NULL");
        for (ContentTypeDefaults contentTypeDefault : acceptedContentTypes) {
            this.accept(contentTypeDefault);
        }
        return this;
    }

    public RouteBuilder<R> html() {
        this.getAcceptedContentTypes().add(ContentTypeDefaults.HTML.getMainVariation());
        return this;
    }

    public RouteBuilder<R> json() {
        this.getAcceptedContentTypes().add(ContentTypeDefaults.JSON.getMainVariation());
        return this;
    }

    public RouteBuilder<R> xml() {
        this.getAcceptedContentTypes().add(ContentTypeDefaults.XML.getMainVariation());
        return this;
    }

    public RouteBuilder<R> path(String path) {
        this.path = path;
        return this;
    }

    public RouteBuilder<R> GET() {
        this.getHttpMethods().add(HttpMethod.GET);
        return this;
    }

    public RouteBuilder<R> POST() {
        this.getHttpMethods().add(HttpMethod.POST);
        return this;
    }

    public RouteBuilder<R> PUT() {
        this.getHttpMethods().add(HttpMethod.PUT);
        return this;
    }

    public RouteBuilder<R> DELETE() {
        this.getHttpMethods().add(HttpMethod.DELETE);
        return this;
    }

    public RouteBuilder<R> OPTIONS() {
        this.getHttpMethods().add(HttpMethod.OPTIONS);
        return this;
    }

    public RouteBuilder<R> TRACE() {
        this.getHttpMethods().add(HttpMethod.TRACE);
        return this;
    }

    public RouteBuilder<R> HEAD() {
        this.getHttpMethods().add(HttpMethod.HEAD);
        return this;
    }

    public RouteBuilder<R> PATCH() {
        this.getHttpMethods().add(HttpMethod.PATCH);
        return this;
    }

    public RouteBuilder<R> ALL() {
        this.getHttpMethods().addAll(Sets.newHashSet((Object[])HttpMethod.values()));
        return this;
    }

    public RouteBuilder<R> methods(Set<HttpMethod> httpMethods) {
        this.getHttpMethods().addAll(httpMethods);
        return this;
    }

    public RouteBuilder<R> methods(HttpMethod ... httpMethods) {
        this.getHttpMethods().addAll(Sets.newHashSet((Object[])httpMethods));
        return this;
    }

    public void handle(Handler<R> mainHandler) {
        if (this.getRouter() == null) {
            throw new RuntimeException("No router specified, can't save the route!");
        }
        Route<R> route = this.create(mainHandler);
        this.getRouter().addRoute(route);
    }

    public Route<R> create(Handler<R> mainHandler) {
        this.mainHandler = mainHandler;
        Set<RoutingType> routingTypes = this.getRoutingTypes();
        if (routingTypes == null || routingTypes.size() == 0) {
            routingTypes = new HashSet<RoutingType>();
            if (this.getPosition() != 0) {
                Set<RoutingType> defaultRoutingTypes = this.getSpincastRouterConfig().getFilterDefaultRoutingTypes();
                routingTypes.addAll(defaultRoutingTypes);
            } else {
                routingTypes.add(RoutingType.FOUND);
            }
        }
        Route<R> route = this.getRouteFactory().createRoute(this.getId(), false, this.isSpicastCoreRouteOrPluginRoute(), this.getHttpMethods(), this.getPath(), routingTypes, this.getBeforeFilters(), mainHandler, this.getAfterFilters(), this.getPosition(), this.getAcceptedContentTypes(), this.getFilterIdsToSkip(), this.isSkipResources());
        return route;
    }

    public RouteBuilder<R> noCache() {
        this.before(new Handler<R>(){

            public void handle(R context) {
                context.cacheHeaders().noCache();
            }
        });
        return this;
    }

    public RouteBuilder<R> cache() {
        return this.cache(this.getCacheSecondsByDefault());
    }

    public RouteBuilder<R> cache(int seconds) {
        return this.cache(seconds, this.isCachePrivateByDefault());
    }

    public RouteBuilder<R> cache(int seconds, boolean isPrivate) {
        return this.cache(seconds, isPrivate, this.getCacheCdnSecondsByDefault());
    }

    public RouteBuilder<R> cache(final int seconds, final boolean isPrivate, final Integer secondsCdn) {
        this.before(new Handler<R>(){

            public void handle(R context) {
                RouteBuilderDefault.this.getSpincastFilters().cache(context, seconds, isPrivate, secondsCdn);
            }
        });
        return this;
    }

    protected int getCacheSecondsByDefault() {
        return this.getSpincastConfig().getDefaultRouteCacheFilterSecondsNbr();
    }

    protected boolean isCachePrivateByDefault() {
        return this.getSpincastConfig().isDefaultRouteCacheFilterPrivate();
    }

    protected Integer getCacheCdnSecondsByDefault() {
        return this.getSpincastConfig().getDefaultRouteCacheFilterSecondsNbrCdns();
    }

    public RouteBuilder<R> skip(String filterId) {
        if (StringUtils.isBlank((CharSequence)filterId)) {
            throw new RuntimeException("The filterId can't be empty.");
        }
        this.getFilterIdsToSkip().add(filterId);
        return this;
    }

    public RouteBuilder<R> skipResourcesRequests() {
        this.skipResources = true;
        return this;
    }
}

